<?php

namespace App\Http\Controllers\Auth;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class AdminAuthController extends Controller
{
    public function adminloginPage()
    {
        return view('admin.pages.login');
    }

    public function loginPost(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required | email | exists:users',
            'password' => 'required'
        ]);
        // dd($request->all());
        if (Auth::attempt($credentials)) {
            if (Auth::user()->role == 1) {
                return redirect()->route('admin.index.get')->with('success', 'Admin login successfully !!!');
            } else {
                return redirect()->route('index.get')->with('success', 'User login successfully !!!');
            }
        }
        return back()->with('error', 'Record not matched with data !!!');
    }

    public function adminforgotPage()
    {
        return view('admin.pages.forgot-password');
    }

    public function adminresetPage($token)
    {
        return view('admin.pages.reset-password', compact('token'));
    }

    public function adminforgotPost(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);

        $token = mt_rand(100000, 999999);

        DB::table('password_resets')->insert([
            'email' => $request->email,
            'token' => $token,
            'created_at' => Carbon::now()
        ]);

        Mail::send('emails.reset-password', ['token' => $token], function ($message) use ($request) {
            $message->to($request->email);
            $message->subject('Reset Password Link');
        });
        // Alert::success('Success', 'Successfully send the reset password link on your email please check to verify !!!');
        return back()->with('success', 'Successfully send the reset password link on your email please check to verify !!!');
    }

    public function adminresetPost(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required | email | exists:users',
            'password' => 'required | min:8 | same:password',
            'cpassword' => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $updatePassword = DB::table('password_resets')
            ->where([
                'email' => $request->email,
                'token' => $request->token
            ])->first();
        if (!$updatePassword) {
            return back()->with('error', 'Something went wrong , password not updated !!!');
        }
        $user = User::where('email', $request->email)
            ->update(['password' => Hash::make($request->password)]);
        DB::table('password_resets')->where(['email' => $request->email])->delete();
        return redirect()->route('admin.login.get')->with('success', 'Successfully update password !!!');
    }

}
