$(document).ready(function(){
  setTimeout(function(){ 
    $('.loadermain').fadeOut(); 
  }, 2500);
  

})


const btnUp = document.querySelector(".btn__up");
const btnDown = document.querySelector(".btn__down");
const sliderSidebar = document.querySelector(".slider__sidebar");
const container = document.querySelector(".container-new");
const slidePreview = document.querySelector(".slider__preview");
const slideActive = document.querySelectorAll(
  ".slider__preview-item:nth-child(n)"
);
const slidesCount = document.querySelectorAll(".slider__preview-item").length;

let slideActiveIndex = 0;

const changeSlide = (d) => {
  if (d === "up") {
    slideActiveIndex++;

    if (slideActiveIndex === slidesCount) {
      slideActiveIndex = 0;
    }
  } else if (d === "down") {
    slideActiveIndex--;

    if (slideActiveIndex < 0) {
      slideActiveIndex = slidesCount - 1;
    }
  }

  const height = container.clientHeight;
  var mainHeight = slideActiveIndex * 600;
  slidePreview.style.transform = `translateY(-${mainHeight}px)`;
  sliderSidebar.style.transform = `translateY(${mainHeight}px)`;

  slideActiveIndex === 0
    ? (slideActive[0].style.filter = "blur(0px)")
    : (slideActive[0].style.filter = "blur(30px)");
  slideActiveIndex === 1
    ? (slideActive[1].style.filter = "blur(0px)")
    : (slideActive[1].style.filter = "blur(30px)");
  slideActiveIndex === 2
    ? (slideActive[2].style.filter = "blur(0px)")
    : (slideActive[2].style.filter = "blur(30px)");
  slideActiveIndex === 3
    ? (slideActive[3].style.filter = "blur(0px)")
    : (slideActive[3].style.filter = "blur(30px)");
  slideActiveIndex === 4
    ? (slideActive[4].style.filter = "blur(0px)")
    : (slideActive[4].style.filter = "blur(30px)");
};

sliderSidebar.style.top = `-${(slidesCount - 1) * 600}px`;

document.addEventListener("keydown", (e) => {
  if (e.key === "ArrowUp" || e.key === "w") {
    changeSlide("up");
  } else if (e.key === "ArrowDown" || e.key === "s") {
    changeSlide("down");
  }
});

btnUp.addEventListener("click", () => {
  changeSlide("up");
});

btnDown.addEventListener("click", () => {
  changeSlide("down");
});


// const cursor = document.createElement('div')
// const child = document.createElement('div')

// const cursorDefaultStyle = `
//     width: 28px;
//     height: 28px;
//     border-radius: 9999px;
//     border: 2px solid #000;
//     position: fixed;
//     transform: translate(-50%, -50%);
//     top: 0; left: '0';
//     transition: 150ms;
//     pointer-events: none;
// `

// const childDefaultStyle = `
//     width: 10px;
//     height: 10px;
//     border-radius: 50%;
//     background-color: #000;
//     position: fixed;
//     top: 0; left: '0';
//     transform: translate(-50%, -50%);
//     transition: 100ms;
//     pointer-events: none;
// `

// cursor.style.cssText = cursorDefaultStyle
// child.style.cssText = childDefaultStyle

// document.body.appendChild(cursor)
// document.body.appendChild(child)

// let isActived = false

window.addEventListener('mousemove', (event) => {
    if (isActived) return

    cursor.style.top = child.style.top = `${event.clientY}px`
    cursor.style.left = child.style.left = `${event.clientX}px`
})

const onHover = document.querySelectorAll('.onHover')
const fixed = (event, getTransition) => {
    event.stopPropagation()
    isActived = true
    const element = event.currentTarget
    const { width, height, top, left } = element.getBoundingClientRect()

    const style = window.getComputedStyle(element)
    const borderRadius = style.getPropertyValue('border-radius')
    const transition = style.getPropertyValue('transition')

    cursor.style.cssText = `
            ${cursorDefaultStyle}
            width: ${width}px;
            height: ${height}px;
            border-radius: ${borderRadius};
            top: ${top}px;
            left: ${left}px;
            transform: translate(0, 0);
            border-color: white;
            ${(getTransition) ? `transition: ${transition};`: ''}
        `

    child.style.cssText = `
            ${childDefaultStyle}
            display: none
        `
}

for (const hover of onHover) {
    hover.addEventListener('mousedown', (event) => fixed(event, true))
    hover.addEventListener('mouseup', (event) => fixed(event, true))
    hover.addEventListener('mouseover', (event) => fixed(event, false))
    hover.addEventListener('mouseleave', (event) => {
        isActived = false
        
        cursor.style.cssText = cursorDefaultStyle
        child.style.cssText = childDefaultStyle
    })
}
