<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ViewsController;
use App\Http\Controllers\Auth\UserAuthController;

use App\Http\Controllers\Auth\AdminAuthController;
use App\Http\Controllers\Reels\PagesController as ReelsPagesController;
use App\Http\Controllers\Store\PagesController as StorePagesController;
use App\Http\Controllers\Social\PagesController as SocialPagesController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('users.index');
})->name('index.get');


// user auth
Route::get('/register', [UserAuthController::class, 'registerPage'])->name('register.get');
Route::get('/login', [UserAuthController::class, 'loginPage'])->name('login.get');
// logout
Route::get('/logout', [UserAuthController::class, 'logout'])->name('logout');

Route::post('/register', [UserAuthController::class, 'registerPost'])->name('register.post');
Route::post('/login', [UserAuthController::class, 'loginPost'])->name('login.post');

Route::get('/forgot-password', [UserAuthController::class, 'forgotPage'])->name('forgot.get');
Route::post('/forgot-password', [UserAuthController::class, 'forgotPost'])->name('forgot.post');

Route::get('/reset/{token}/password', [UserAuthController::class, 'resetPage'])->name('reset.get');
Route::post('/reset-password', [UserAuthController::class, 'resetPost'])->name('reset.post');

//  store pages
Route::get('/store/index',[StorePagesController::class,'storeIndex'])->name('store.index.get');
Route::get('/store/products',[StorePagesController::class,'storeproducts'])->name('store.products.get');
Route::get('/store/about',[StorePagesController::class,'storeabout'])->name('store.about.get');
Route::get('/store/contact',[StorePagesController::class,'storecontact'])->name('store.contact.get');


// reesl pages
Route::get('/social/index',[SocialPagesController::class,'socialIndex'])->name('social.index.get');
Route::get('/social/contact',[SocialPagesController::class,'socialcontact'])->name('social.contact.get');
Route::get('/social/about',[SocialPagesController::class,'socialabout'])->name('social.about.get');
Route::get('/social/search',[SocialPagesController::class,'socialsearch'])->name('social.search.get');

// social pages
Route::get('/reels/index',[ReelsPagesController::class,'reelsIndex'])->name('reels.index.get');


// admin views
Route::get('/admin/index',[ViewsController::class,'adminIndex'])->name('admin.index.get');



// admin auth
Route::get('/admin', [AdminAuthController::class, 'adminloginPage'])->name('admin.login.get');

Route::get('/admin/forgot-password', [AdminAuthController::class, 'adminforgotPage'])->name('admin.forgot.get');
Route::post('/admin/forgot-password', [AdminAuthController::class, 'adminforgotPost'])->name('admin.forgot.post');

Route::get('/admin/reset/{token}/password', [AdminAuthController::class, 'adminresetPage'])->name('admin.reset.get');
Route::post('/admin/reset-password', [AdminAuthController::class, 'adminresetPost'])->name('admin.reset.post');
