<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class Message implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $message;
    public $users;
    public $path;

    public function __construct($message,$users,$path)
    {
        $this->users = $users;
        $this->path = $path;
        $this->message = $message;

    }

    public function broadcastWith()
    {
        return [
            'users' => $this->users,
            'path' => $this->path,
            'message' => $this->message
        ];
    }

    public function broadcastAs()
    {
        return 'message';
    }

    public function broadcastOn()
    {
        return new Channel('chat');
    }
}
