<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Messenger</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        .mnBox {
            width: 100%;
            height: 100vh;
            position: relative;
            background-image: url(https://w.forfun.com/fetch/75/75c280c….jpeg);
            background-position: unset;
            background-size: cover;
            background-repeat: no-repeat;
        }

        .msgBox {
            position: absolute;
            right: 75px;
            bottom: 95px;
            width: 300px;
            background: aquamarine;
            height: 450px;
        }

        .msgIcon {
            position: fixed;
            right: 39px;
            bottom: 30px;
            z-index: 99;
            font-size: 22px;
            width: 80px;
            height: 80px;
            background: aqua;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            cursor: pointer;
        }

        .msgBody {
            width: 100%;
            height: 385px;
            overflow-y: scroll;
        }

        .userProfile {
            display: flex;
            background: cadetblue;
            cursor: pointer;
            align-items: center;
            padding: 5px;
        }

        .userProfile .imgBx {
            width: 50px;
            height: 50px;
        }

        .userProfile .userName {
            margin: 0 20px;
        }

        .chatContainer {
            width: 600px;
            height: 620px;
            position: absolute;
            right: 25%;
            top: 30px;
            background: grey;
        }

        .chatBody {
            width: 100%;
            height: 480px;
            background: antiquewhite;
            overflow-y: scroll;
            padding: 10px;
        }

        .msgBody::-webkit-scrollbar {
            width: 5px;
        }

        .msgBody::-webkit-scrollbar-track {
            box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
        }

        .msgBody::-webkit-scrollbar-thumb {
            background-color: rgb(14, 85, 90);
            outline: 1px solid rgb(61, 193, 233);
        }

        .chatBody::-webkit-scrollbar {
            width: 5px;
        }

        .chatBody::-webkit-scrollbar-track {
            box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.3);
        }

        .chatBody::-webkit-scrollbar-thumb {
            background-color: rgb(14, 85, 90);
            outline: 1px solid rgb(61, 193, 233);
        }


        /* Style the search field */
        form.example input[type=text] {
            padding: 10px;
            font-size: 17px;
            border: 1px solid grey;
            float: left;
            width: 80%;
            background: #f1f1f1;
        }

        /* Style the submit button */
        form.example button {
            float: left;
            width: 20%;
            padding: 10px;
            background: #2196F3;
            color: white;
            font-size: 17px;
            border: 1px solid grey;
            border-left: none;
            /* Prevent double borders */
            cursor: pointer;
        }

        form.example button:hover {
            background: #0b7dda;
        }

        /* Clear floats */
        form.example::after {
            content: "";
            clear: both;
            display: table;
        }

        .message-user-right {
            display: flex;
            flex-direction: column;
            align-items: end;
            gap: 15px;
        }

        .message-user-right .message-user-right-img {
            display: flex;
            gap: 10px;
            justify-content: end;
            align-items: center;
        }

        .message-user-right .message-user-right-img img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }

        .message-user-right .message-user-right-text {
            position: relative;
            padding: 15px 25px;
            background-color: #c5e2e8;
            border-radius: 15px;
            color: #949494;
            width: 250px;
        }

        .message-user-right .message-user-right-text::before {
            content: '';
            position: absolute;
            top: -26px;
            right: 15px;
            border-right: 0px solid transparent;
            border-top: 15px solid transparent;
            border-left: 15px solid transparent;
            border-bottom: 15px solid #c5e2e8;
        }

        .message-user-left {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .message-user-left .message-user-left-img {
            display: flex;
            gap: 10px;
            justify-content: start;
            align-items: center;
        }

        .message-user-left .message-user-left-img img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }

        .message-user-left .message-user-left-text {
            position: relative;
            padding: 15px 25px;
            background-color: #ffffff;
            border-radius: 15px;
            color: #949494;
            max-width: 250px;
        }

        .message-user-left .message-user-left-text::before {
            content: '';
            position: absolute;
            top: -26px;
            left: 15px;
            border-right: 15px solid transparent;
            border-top: 15px solid transparent;
            border-left: 0px solid transparent;
            border-bottom: 15px solid #ffffff;
        }
    </style>
</head>

<body>
    @php
        $users = DB::table('users')
            ->where('id', '!=', Auth::user()->id)
            ->get();
        // dd($users);
    @endphp
    <section class="mnBox"
        style="background-image: url('https://w.forfun.com/fetch/75/75c280c83f2f58b1b71db86e6181d8f1.jpeg')">
        <div class="msgIcon" id="chatClck"><i class="fa fa-message text-warning"></i></div>
        <div class="msgBox">
            <div class="msgHead p-2">
                <form class="example" action="">
                    <input type="text" placeholder="Search users..." name="search">
                    <button type="submit" class="bg-warning"><i class="fa fa-search"></i></button>
                </form>
            </div>
            <div class="msgBody p-2">
                @foreach ($users as $user)
                    <div class="userProfile mb-1 uClck " id="userClck" data-username="{{ $user->name }}"
                        data-id="{{ $user->id }}">
                        <div class="imgBx">
                            <img src="{{ asset('uploads/users/' . $user->profile) }}" alt="Img"
                                style="width: 100%;">
                        </div>
                        <div class="userName">
                            <h6>{{ $user->name }}</h6>
                            <p>
                                @if ($user->status == '1')
                                    <div class="online"></div>
                                @else
                                    <div class="offline"></div>
                                @endif
                            </p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="chatContainer ">
            <div class="userProfile mb-1">
                <div class="imgBx">
                    <img src="{{ asset('uploads/users/' . Auth::user()->profile) }}" alt="Img" style="width: 100%;"
                        id="user-profile-image">
                </div>
                <div class="userName">
                    <h6 id="user-profile-name">User</h6>
                    @if (Auth::user()->status == '1')
                        <small class="text-white" id="user-status">online</small>
                    @else
                        <small class="text-white" id="user-status">offline</small>
                    @endif
                    <br>
                    <div style="position: absolute; right: 20px; top: 20px;">
                        <a href="{{ route('logout') }}"><i class="fa fa-sign-out text-white"></i></a>
                    </div>
                </div>
            </div>
            @php
                $messages = DB::table('messages')->get();
            @endphp
            <div class="chatBody body-chat-message-user">
                @foreach ($messages as $msg)
                    @php
                        $user = DB::table('users')
                            ->where('id', $msg->sender_id)
                            ->orWhere('id', $msg->receiver_id)
                            ->first();
                    @endphp
                    @if ($msg->sender_id == Auth::user()->id)
                        <div class="message-user-right">
                            <div class="message-user-right-img">
                                <p class="mt-0 mb-0"><strong>{{ Auth::user()->name }}</strong></p>
                                <img src="{{ asset('uploads/users/' . Auth::user()->profile) }}" alt="">
                            </div>
                            <div class="message-user-right-text"><strong>{{ $msg->message }}</strong></div>
                        </div>
                    @else
                        <div class="message-user-left">
                            <div class="message-user-left-img">
                                <img src="{{ asset('uploads/users/' . $user->profile) }}" alt="">
                                <p class="mt-0 mb-0"><strong>{{ $user->name }}</strong></p>
                            </div>
                            <div class="message-user-left-text"><strong>{{ $msg->message }}</strong></div>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="inputftr p-3">
                <form action="">
                    <div class="form-group position-relative">
                        <input type="hidden" name="receiver_id" id="recieverid" value="{{ Auth::user()->id }}">
                        <input type="text" id="messageInput" name="message" class="form-control"
                            placeholder="Type here....">
                        <div style="position: absolute; right: 0; top: 0;">
                            <button type="submit" class="btn btn-success"><i class="fa fa-paper-plane"
                                    id="sendMessageButton"></i></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            $('.msgBox').hide();
            $('.chatContainer').hide();

            $('#chatClck').click(function() {
                $('.msgBox').toggle();
            });
            $('.uClck').click(function() {
                $('.chatContainer').toggle();
            });
        });
    </script>


    <div id="user-info" data-name="{{ Auth::user()->name }}"
        data-profile="{{ asset('uploads/users/' . Auth::user()->profile) }}" hidden></div>
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <script>
        var authId = @json((string) auth()->user()->id);
        var authProfile = $('#user-info').data('profile');
        var authName = @json(auth()->user()->name);
        window.assetBaseUrl = "{{ asset('') }}";
        var usersUrl = "{{ url('/users') }}";
        var submitUrl = "{{ url('/send-message') }}";
        var fetchedUrl = "{{ url('/fetch-messages') }}";

        console.log(submitUrl, submitUrl, fetchedUrl);
    </script>

</body>

</html>
