<?php

use App\Events\Message;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ChatController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', function () {
    return view('login');
})->name('login.get');



Route::get('/chat', [ChatController::class, 'chatGet'])->name('chat.get');


Route::get('/messenger', function () {
    return view('messenger');
})->name('messenger.get');


Route::post('/register', [AuthController::class, 'registerPost'])->name('register.post');
Route::post('/login', [AuthController::class, 'loginPost'])->name('login.post');
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');


// get user
Route::post('/users', [ChatController::class, 'userGet'])->name('user.get');
Route::post('/send-message', [ChatController::class, 'sendMessage'])->name('send.message');
Route::post('/get-messages', [ChatController::class, 'getMessages'])->name('get.messages');

// save audio
Route::post('/save-files', [ChatController::class,'saveAudio'])->name('save.audio');

// fetch messages 5 secs
Route::post('/fetch-messages', [ChatController::class, 'fetchMessages'])->name('fetch.messages');
