$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$(document).ready(function () {
    $('.content-chat-message-user').hide();

    var userInfo = document.getElementById('user-info');
    var userName = userInfo.getAttribute('data-name');
    var userProfile = userInfo.getAttribute('data-profile');

    $('.userClck').click(function () {
        var userId = $(this).data('id');
        console.log(userId);
        $('.content-chat-message-user').show();
        $('.userClck').removeClass('active');
        $(this).addClass('active');
        $('#recieverid').val(userId);
        $.ajax({
            url: "/users",
            method: "POST",
            data: {
                user_id: userId
            },
            dataType: "json",
            success: function (data) {
                $('#user-profile-image').attr('src', data.profile_image);
                $('#user-profile-name').text(data.name);
                $('#user-status').text(data.status);
            }
        });
        fetchMessages(userId);
    });

    // fetch messages
    function fetchMessages(userId) {
        $.ajax({
            url: "/fetch-messages",
            method: "POST",
            data: {
                user_id: userId
            },
            dataType: "json",
            success: function (messages) {
                var messageContainer = $('.body-chat-message-user');
                messageContainer.empty();
                console.log(messages);
                messages.messages.forEach(function (message) {
                    var messageHtml = '';
                    if (message.sender_id == senderId) {
                        messageHtml += `<div class="message-user-right">`;
                        messageHtml +=
                            `<div class="message-user-right-img">`;
                        messageHtml +=
                            `<p class="mt-0 mb-0"><strong>${userName}</strong></p>`;
                        messageHtml +=
                            `<img src="${userProfile}" alt="">`;
                        messageHtml += `</div>`;
                        messageHtml +=
                            `<div class="message-user-right-text">`;
                        messageHtml +=
                            `<strong>${message.message}</strong>`;
                        messageHtml += `</div>`;
                        messageHtml += `</div>`;
                    } else {
                        var otherUser = message.sender_id !== senderId ? messages.users[1] : messages.users[0];
                        var profileImage = message.sender_id !== senderId ? messages.users[1].profile : messages.users[0].profile;
                        messageHtml += `<div class="message-user-left">`;
                        messageHtml +=
                            `<div class="message-user-left-img">`;
                        messageHtml += `<img src="${profileImage}" alt="">`;
                        messageHtml +=
                            `<p class="mt-0 mb-0"><strong>${otherUser.name}</strong></p>`;
                        messageHtml += `</div>`;
                        messageHtml +=
                            `<div class="message-user-left-text">`;
                        messageHtml +=
                            `<strong>${message.message}</strong>`;
                        messageHtml += `</div>`;
                        messageHtml += `</div>`;
                    }
                    messageContainer.append(messageHtml);
                });
            },
            error: function (xhr, status, error) {
                console.error("Error fetching messages: " + error);
            }
        });
    }

    $('#sendMessageButton').click(function () {
        var receiverId = $('#recieverid').val();
        var message = $('#messageInput').val();
        console.log(receiverId, message);
        sendMessage(message);
    });

    function sendMessage(message) {
        var receiverId = $('#recieverid').val();
        var fullUrl = window.location.origin + "/send-message";
        $.ajax({
            url: sendMessageRoute,
            method: "POST",
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                sender_id: senderId,
                receiver_id: receiverId,
                message: message
            },
            success: function (response) {
                if (response.success) {
                    // console.log(response.data);
                    $('#messageInput').val('');
                    var sentMessageHtml = `<div class="message-user-right">`;
                    sentMessageHtml += `<div class="message-user-right-img">`;
                    sentMessageHtml += `<p class="mt-0 mb-0"><strong>${userName}</strong></p>`;
                    sentMessageHtml += `<img src="${userProfile}" alt="">`;
                    sentMessageHtml += `</div>`;
                    sentMessageHtml += `<div class="message-user-right-text">`;
                    sentMessageHtml += `<strong>${message}</strong>`;
                    sentMessageHtml += `</div>`;
                    sentMessageHtml += `</div>`;
                    $('.body-chat-message-user').append(sentMessageHtml);
                    var container = $('.body-chat-message-user');
                    container.scrollTop(container.prop("scrollHeight"));
                } else {
                    console.log(response.error);
                }
            },
            error: function (error) {
                console.error(error);
            }
        });
    }
});


Echo.channel('PersonalChat')
    .listen('.message', (data) => {
        console.log('listening', data);
    });
