<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\CmsHome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CmsController extends Controller
{
    public function cmsHomePost(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'first_sec' => 'required',
            'second_sec' => 'required',
            'third_sec' => 'required',
            'four_sec' => 'required',
            'five_sec' => 'required',
            'six_sec' => 'required',
            'first_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'second_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'third_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'four_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'five_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'six_img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        // dd($request->all());
        $cmsHome = new CmsHome();
        // Fill the instance with data from the request
        $cmsHome->first_sec = $request->first_sec;
        $cmsHome->second_sec = $request->second_sec;
        $cmsHome->third_sec = $request->third_sec;
        $cmsHome->four_sec = $request->four_sec;
        $cmsHome->five_sec = $request->five_sec;
        $cmsHome->six_sec = $request->six_sec;
        // Upload and save the images
        $imageFields = ['first_img', 'second_img', 'third_img', 'four_img', 'five_img', 'six_img'];
        foreach ($imageFields as $field) {
            if ($request->hasFile($field)) {
                $file = $request->file($field);
                $fileName = mt_rand(100000, 999999) . '.' . $file->getClientOriginalExtension();
                $file->move('uploads/cms-images/', $fileName);
                $cmsHome->$field = $fileName;
            }
        }
        $cmsHome->save();
        return redirect()->back()->with('success', 'Home content saved successfully.');
    }
}
