@extends('users.layout.layout')

@section('title', 'Fan Club | About')

@section('main-content')

    <section class="banner home-banner">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h1>Who We Are</h1>
                        <h2>& What We Do</h2>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="service">
        <svg class="svg-top-left" viewBox="0 0 1920 469.1">
          <path d="M0,1080V610.9H1920V731.7c-19.5,12.6-304.8,186.4-783.6-21.3C640.1,495.1,641.7,726.8,357.5,819.1S204.6,1064.7,0,1080Z" transform="translate(0 -610.9)" fill="#fff"></path>
        </svg>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading text-center">
                        <h3>Each year your Fan Club Card membership renews, a portion of your membership will go to the organization you select. You can continue to support your favorite organization while saving money on the things you do everyday!</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3">
                    <div class="service-box">
                        <img src="{{asset('user-assets')}}/website/images/22guarantee.svg">
                        <h4>Easy To Sell</h4>
                        <ul>
                            <li>Online</li>
                            <li>In-person</li>
                            <li>Via Social Media</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="service-box">
                        <img src="{{asset('user-assets')}}/website/images/group.svg">
                        <h4>Amazing Deals</h4>
                        <p>A deal so good they automatically buy every year and tell other people about it!</p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="service-box">
                        <img src="{{asset('user-assets')}}/website/images/group-227.svg">
                        <h4>Big Payouts</h4>
                        <p>Your Group / Organization could make $15-$20 per membership sold, paid directly to you!</p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="service-box">
                        <img src="{{asset('user-assets')}}/website/images/group-24.svg">
                        <h4>No Fees</h4>
                        <p>No start-up fees, no minimum purchases, no inventory, no delivery and no money collection!</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="future-fundraising">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6">
                    <div class="banner-play-button">
                        <img src="{{asset('user-assets')}}/website/images/videobg.png">
                        <a href="https://www.youtube.com/watch?v=gbpZd3M8lPs"><i class="fas fa-play"></i></a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="fundraising-here">
                        <h2>The Future of <br>Fundraising is Here</h2>
                        <p>01. No more door to door for pennies.</p>
                        <p>02. Tired of deliveries, car washes, coupon books only to make no read money?</p>
                        <p>03. No more coutless admin hours managing funds.</p>
                        <a href="" class="btn btn-default"><span>More Information</span></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="contact">
        <svg class="svg-top-left" viewBox="0 0 1920 469.1">
            <path d="M0,1080V610.9H1920V731.7c-19.5,12.6-304.8,186.4-783.6-21.3C640.1,495.1,641.7,726.8,357.5,819.1S204.6,1064.7,0,1080Z" transform="translate(0 -610.9)" fill="#fff"></path>
        </svg>
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <img src="{{asset('user-assets')}}/website/images/01.gif">
                </div>
                <div class="col-lg-8">
                    <form class="contact-form">
                        <h2>Reach Member-Based Customers with Fan Club Card</h2>
                        <p>Any businesses can benefit from using FanClubCard to reach more ready-to-buy customers.</p>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="First Name*">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Last Name*">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Organization Name*">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Website Link*">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="email" class="form-control" placeholder="Email*">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Phone*">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="checkbox" class="custom-check" id="custom-check">
                                    <label class="custom-check-label light-blue-check" for="custom-check">I agree to Your <a href="#">Terms of Service</a> and <a href="#">Privacy</a></label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button class="btn btn-default"><span>More Information</span></button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
        <svg class="svg-bottom-left" viewBox="0 0 1920 469.1">
            <path d="M0,610.9V1080H1920V959.2c-19.5-12.6-304.8-186.4-783.6,21.3-496.3,215.3-494.7-16.4-778.9-108.7S204.6,626.2,0,610.9Z" transform="translate(0 -610.9)" fill="#fff"></path>
        </svg>
    </section>


@endsection
