<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Forgot Password</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;
        }

        :root {
            --hue: 223;
            --bg2: #d1c7c7;
        }

        html {
            display: grid;
            width: 100%;
            height: 100%;
            margin: center;
            background: #f2f2f2;
            background: #fcb900;
        }

        body {
            display: grid;
            width: 100%;
            margin: center;
            background: #fff;
        }

        .container {
            max-width: 80rem;
            margin: auto;
            padding: 0 1rem;
            z-index: 2;
        }

        .wrapper {
            max-width: 28rem;
            border-radius: 15px;
            box-shadow: 0px 15px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .wrapper .title-text {
            padding: 2rem;
            display: flex;
            width: 180%;
            background: #fcb900;
        }

        .wrapper .title-text .title {
            user-select: none;
            width: 50%;
            font-size: 35px;
            font-weight: 600;
            text-align: center;
            transition: all 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            color: #232323;
        }

        .wrapper .form-container {
            width: 100%;
            overflow: hidden;
        }

        .wrapper form {
            padding: 1.5rem 30px;
            padding-top: 0;
        }

        .wrapper form .field {
            height: 50px;
            width: 100%;
            margin-top: 20px;
            position: relative;
        }

        .wrapper form .field input {
            color: #232323;
            height: 100%;
            width: 100%;
            outline: none;
            font-size: 17px;
            padding-left: 20px;
            border: 1px solid lightgrey;
            border-radius: 25px;
            transition: all 0.3s ease;
            padding: 0 0.8rem;
        }

        .wrapper form .field input:focus {
            border-color: #fcb900;
        }

        .wrapper form .field input::selection {
            background: #fcb900;
            color: #232323;
        }

        .wrapper form .field input[type="submit"] {
            color: #232323;
            font-size: 20px;
            font-weight: 500;
            padding-left: 0px;
            border: none;
            cursor: pointer;
            background: #fcb900;
            font-weight: bold;
        }

        .wrapper form .field label {
            position: absolute;
            top: 50%;
            left: 20px;
            color: #999;
            font-weight: 400;
            font-size: 17px;
            pointer-events: none;
            transform: translateY(-50%);
            transition: all 0.3s ease;
        }

        .field input:valid {
            border-color: #fcb900;
        }

        .field input:valid~label {
            top: 0%;
            font-size: 16px;
            color: #999;
            background: #fff;
            transform: translateY(-50%);
        }

        .field input:focus~label {
            top: 0%;
            font-size: 16px;
            color: #d39d09;
            background: #fff;
            transform: translateY(-50%);
        }

        .form-container {
            background: #fff;
            padding: 0 30px;
        }

        .form-container .slide-controls {
            position: relative;
            display: flex;
            height: 50px;
            width: 100%;
            overflow: hidden;
            border-radius: 2rem;
            margin: 30px 0 10px 0;
            justify-content: space-between;
            border: 1px solid lightgrey;
        }

        .form-container .form-inner {
            display: flex;
            width: 200%;
        }

        .form-container .form-inner form {
            width: 50%;
            transition: all 1s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }

        .slide-controls .slide {
            color: #232323;
            height: 100%;
            width: 100%;
            z-index: 1;
            font-size: 18px;
            font-weight: 500;
            text-align: center;
            line-height: 50px;
            cursor: pointer;
            transition: all 0.6s ease;
            user-select: none;
        }

        .slide-controls .text-signup {
            color: #6f6f6f;
        }

        .slide-controls .slide-tab {
            position: absolute;
            height: 100%;
            width: 50%;
            left: 0;
            border-radius: 0.1rem;
            z-index: 0;
            background: #fcb900;
            transition: all 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }

        input[type="radio"] {
            display: none;
        }

        #signup:checked~.slide-tab {
            left: 50%;
        }

        #signup:checked~.text-signup {
            color: #232323;
        }

        #signup:checked~.text-login {
            color: #6f6f6f;
        }

        .icon-password {
            position: absolute;
            top: 50%;
            right: 20px;
            color: #999;
            font-size: 19px;
            transform: translateY(-50%);
            z-index: 5;
            cursor: pointer;
        }

        #alertuname {
            display: none;
            margin-left: 0.5rem;
            margin-top: 0.5rem;
            color: #b00;
            font-size: 0.8rem;
            animation: shake 0.5s ease-in-out;
            animation-timing-function: cubic-bezier(0.36, 0.07, 0.19, 0.97);
            animation-iteration-count: 1.5;
            transition: all 1s;
        }

        #alertpass {
            display: none;
            margin-left: 0.5rem;
            margin-top: 0.5rem;
            color: #b00;
            font-size: 0.8rem;
            animation: shake 0.5s ease-in-out;
            animation-timing-function: cubic-bezier(0.36, 0.07, 0.19, 0.97);
            animation-iteration-count: 1.5;
            transition: all 1s;
        }

        #alertcpass {
            display: none;
            margin-left: 0.5rem;
            margin-top: 0.5rem;
            color: #b00;
            font-size: 0.8rem;
            animation: shake 0.5s ease-in-out;
            animation-timing-function: cubic-bezier(0.36, 0.07, 0.19, 0.97);
            animation-iteration-count: 1.5;
            transition: all 1s;
        }

        #alertlpass {
            display: none;
            margin-left: 0.5rem;
            margin-top: 0.5rem;
            color: #b00;
            font-size: 0.8rem;
            animation: shake 0.5s ease-in-out;
            animation-timing-function: cubic-bezier(0.36, 0.07, 0.19, 0.97);
            animation-iteration-count: 1.5;
            transition: all 1s;
        }

        @keyframes shake {
            0% {
                transform: translateX(0);
            }

            25% {
                transform: translateX(-10px);
            }

            50% {
                transform: translateX(10px);
            }

            75% {
                transform: translateX(-10px);
            }

            100% {
                transform: translateX(0);
            }
        }

        .btn {
            margin: auto;
            border: 0;
            background-color: var(--bg2);
            border-radius: 1.5em;
            display: block;
            position: relative;
            width: 100%;
            height: 3em;
            transition: width 0.3s ease-in-out;
            cursor: pointer;
            font-size: 1.1rem;
            font-weight: bold;
        }

        .btn:not(:disabled):active {
            transform: translateY(0.1em);
        }

        .btn__text {
            background-image: #fcb900;
            border-radius: inherit;
            color: #232323;
            display: inline-block;
            padding: 0.75em 1.5em;
            transition: background-color 0.15s linear, color 0.15s 0.3s ease-in-out;
            width: 100%;
        }

        .btn:not(:disabled):focus .btn__text,
        .btn:not(:disabled):hover .btn__text {
            background-color: #fcb900;
        }

        .btn__progress {
            overflow: visible;
            position: absolute;
            top: 0;
            left: 0;
            width: 3em;
            height: 3em;
            visibility: hidden;
        }

        .btn__progress-track {
            r: 12px;
            stroke: var(--bg2);
            stroke-width: 24;
        }

        .btn__progress-fill {
            stroke: #fcb900;
            stroke-dashoffset: 125.66;
        }

        .btn__progress-check {
            stroke: #fff;
            stroke-dashoffset: 34;
        }

        /* Both states */
        .btn--running,
        .btn--done {
            outline: none;
            pointer-events: none;
            width: 3em;
            user-select: none;
            -moz-user-select: none;
            -webkit-user-select: none;
        }

        .btn--running .btn__text,
        .btn--done .btn__text {
            color: transparent;
            transition: background-color 0.3s ease-in-out, visibility 0.3s steps(1);
        }

        .btn--running .btn__progress,
        .btn--done .btn__progress {
            visibility: visible;
        }

        /* Running state */
        .btn--running .btn__text {
            background-color: #fcb900;
            visibility: hidden;
        }

        .btn--running .btn__progress {
            transition: visibility 0.3s 0.3s steps(1, start);
        }

        .btn--running .btn__progress-track {
            r: 20px;
            stroke-width: 8;
            transition: r 0.3s 0.3s ease-in-out, stroke-width 0.3s 0.3s ease-in-out;
        }

        .btn--running .btn__progress-fill {
            stroke-dashoffset: 0;
            transition: stroke-dashoffset 2s 0.6s linear;
        }

        /* Done state */
        .btn--done .btn__progress-track {
            stroke: #fcb900;
            transition: r 0.3s ease-in-out, stroke-width 0.3s ease-in-out;
        }

        .btn--done .btn__progress-check {
            stroke-dashoffset: 0;
            transition: stroke-dashoffset 0.3s 0.3s ease-out;
        }

        #modalContainer {
            z-index: 3;
            display: none;
            position: fixed;
            bottom: 0;
            left: 1rem;
        }

        #modalContainer .modal-content {
            border-radius: 0.5rem;
            background: #fefefe;
            margin-bottom: 15px;
            box-shadow: 0px 15px 20px rgba(0, 0, 0, 0.1);
            direction: rtl;
            animation: animatetop 1s;
            overflow: hidden;
            display: flex;
            justify-content: space-between;
            padding: 15px 15px;
            text-align: justify;
            font-size: 95%;
            color: #3d3c3c;
            color: red;
        }

        #modalContainer .modal-content i {
            margin-left: 0.5rem;
            font-size: 99%;
        }

        @keyframes animatetop {
            0% {
                margin-bottom: -500px;
                opacity: 0;
            }

            100% {
                margin-bottom: 15px;
                opacity: 1;
            }
        }

        .mooj {
            position: absolute;
            width: 100%;
            height: 100vh;
        }

        /* Project Responsive */
        @media only screen and (max-width: 1200px) {
            .container {
                max-width: 80rem;
            }
        }

        @media only screen and (max-width: 992px) {
            .container {
                max-width: 80rem;
            }
        }

        @media only screen and (max-width: 768px) {
            .container {
                max-width: 650px;
            }

            .wrapper {
                max-width: 100%;
            }
        }

        @media only screen and (max-width: 576px) {
            .container {
                max-width: 100%;
            }
        }
    </style>
</head>

<body>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
    integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

<script>
    $(document).ready(function() {
        toastr.options.timeOut = 10000;

        @if (Session::has('success'))
            toastr.success('{{ Session::get('success') }}');
        @endif

        @if (Session::has('info'))
            toastr.info('{{ Session::get('info') }}');
        @endif

        @if (Session::has('warning'))
            toastr.warning('{{ Session::get('warning') }}');
        @endif

        @if (Session::has('error'))
            toastr.error('{{ Session::get('error') }}');
        @endif
    });
</script>
    <div class="container">

        <div class="wrapper">
            <div class="title-text">
                <div class="title login">Forgot Password</div>
            </div>


            <div class="form-container">
                <div class="form-inner">
                    <form action="{{ route('forgot.post') }}" method="post" class="login">
                        @csrf
                        <div class="field">
                            <input id="uname" name="email" type="text" maxlength="22" required>
                            <label>Email</label>
                        </div>
                        <div style="margin-top: 10px; text-align: right;">
                            <a href="{{ route('register.get') }}">Login !</a>
                        </div>
                        <div class="field">
                            <input class="btn-login" type="submit" value="Submit">
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

    <div id="modalContainer">
        <div class="modal-content">
            <i class="bi bi-exclamation-circle-fill"></i>
            <p class="paragraf">
                The information entered is incorrect
            </p>
        </div>
    </div>

    <img class="mooj" src="https://iili.io/HXsukuV.png">


    <script>
        'use strict'

        const loginForm = document.querySelector('form.login')
        const signupForm = document.querySelector('form.signup')
        const loginBtn = document.querySelector('label.text-login')
        const signupBtn = document.querySelector('label.text-signup')
        const loginText = document.querySelector('.title-text .login')
        const signupText = document.querySelector('.title-text .signup')

        signupForm.style.display = 'none'

        signupBtn.onclick = () => {
            signupForm.style.display = 'block'
            loginForm.style.marginLeft = '-50%'
            loginText.style.marginLeft = '-50%'
        }

        loginBtn.onclick = () => {
            loginForm.style.display = 'block'
            loginForm.style.marginLeft = '0%'
            loginText.style.marginLeft = '0%'
            delysignup()
        }

        function delysignup() {
            setTimeout(() => {
                signupForm.style.display = 'none'
            }, 300)
        }

        const blur = () => {
            if (pass.value.length != 8) {
                alertpass.style.display = 'block'
            }
            if (pass.value == '') {
                alertpass.style.display = 'none'
            }
        }

        const keydown = () => {
            if (pass.value.length == 8) {
                alertpass.style.display = 'none'
            }
        }

        pass.addEventListener('blur', blur)
        pass.addEventListener('keydown', keydown)

        cpass.addEventListener('blur', () => {
            if (cpass.value != pass.value) {
                alertcpass.style.display = 'block'
            }
            if (cpass.value == '') {
                alertcpass.style.display = 'none'
            }
        })

        cpass.addEventListener('keyup', () => {
            if (cpass.value == pass.value) {
                alertcpass.style.display = 'none'
            }
        })

        email.addEventListener('blur', () => {
            if (email.value == '') {
                lemail.style.top = '50%'
            }
        })

        email.addEventListener('keydown', () => {
            if (email.value != '') {
                lemail.style.top = '0%'
            }
        })


        let betUsername = true

        username.addEventListener('keyup', () => {
            let formData = {
                "name": username.value
            }
            fetch('http://127.0.0.1:5000/data/signup/username', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => {
                    return response.json()
                })
                .then(response => {
                    console.log(response.data.length);
                    if (response.data.length != 0) {
                        alertuname.style.display = 'block'
                        betUsername = false
                    } else {
                        alertuname.style.display = 'none'
                        betUsername = true
                    }
                })
                .catch(error => {
                    console.log(error);
                })
        })

        window.addEventListener("DOMContentLoaded", () => {
            const btnSignup = document.querySelector('.btn-signup');
            var doneTimeout = null,
                resetTimeout = null;
            btnSignup.addEventListener("click", function(e) {
                if (username.value != '' && email.value != '' &&
                    pass.value != '' && cpass.value != '' && pass.value.length == 8 && cpass.value.length ==
                    8 && cpass.value == pass.value && betUsername == true) {
                    e.preventDefault()
                    const currentdate = new Date();
                    const datetime = currentdate.getHours() + ":" +
                        currentdate.getMinutes() + ":" + currentdate.getSeconds()

                    let formData = {
                        "name": username.value,
                        "email": email.value,
                        "password": pass.value,
                        "time": datetime
                    };
                    console.log(formData)
                    fetch('http://127.0.0.1:5000/data/signup', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify(formData)
                        })
                        .then(response => {
                            console.log(response);
                        })
                        .catch(error => {
                            console.log(error);
                        });
                    const runClass = "btn--running";
                    const doneClass = "btn--done";
                    const submitDuration = 2000;
                    const resetDuration = 1500;

                    // fake the submission
                    this.disabled = true;
                    this.classList.add(runClass);

                    clearTimeout(doneTimeout);
                    clearTimeout(resetTimeout);

                    doneTimeout = setTimeout(() => {
                        this.classList.remove(runClass);
                        this.classList.add(doneClass);

                        // reset the button
                        resetTimeout = setTimeout(() => {
                            this.disabled = false;
                            this.classList.remove(doneClass);
                        }, resetDuration);

                    }, 600 + submitDuration);
                    setTimeout(() => {
                        username.value = ''
                        email.value = ''
                        lemail.style.top = '50%'
                        pass.value = ''
                        cpass.value = ''
                    }, 3000)
                }
            });
        });




        const password = document.querySelectorAll('.password')
        const iconPassword = document.querySelectorAll('.icon-password')


        for (let i = 0; i < password.length; i++) {
            iconPassword[i].addEventListener('click', () => {
                if (iconPassword[i].className == 'icon-password  bi-eye-slash-fill') {
                    iconPassword[i].className = 'icon-password bi-eye-fill'
                    password[i].setAttribute('type', 'text')
                } else {
                    iconPassword[i].className = 'icon-password  bi-eye-slash-fill'
                    password[i].setAttribute('type', 'password')
                }
            })
        }

        lpass.addEventListener('blur', () => {
            if (lpass.value.length != 8) {
                alertlpass.style.display = 'block'
            }
            if (lpass.value == '') {
                alertlpass.style.display = 'none'
            }
        })

        lpass.addEventListener('keydown', () => {
            if (lpass.value.length == 8) {
                alertlpass.style.display = 'none'
            }
        })


        const btnLogin = document.querySelector('.btn-login')
        const modalContainer = document.querySelector('#modalContainer')


        btnLogin.addEventListener('click', () => {
            let formData = {
                "name": uname.value,
                "password": lpass.value,
            }
            fetch('http://127.0.0.1:5000/data/login', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => {
                    return response.json()
                })
                .then(response => {
                    console.log(response);
                    if (response.data.length != 0) {
                        uname.value = ''
                        lpass.value = ''
                    } else {
                        if (uname.value != '' && lpass.value != '' && alertlpass.style.display == 'none')
                            modalContainer.style.display = 'block'
                        setTimeout(() => {
                            modalContainer.style.display = 'none'
                        }, 4000)
                    }

                    setTimeout(() => {
                        if (response.data.length != 0) {
                            window.location.href = '/user account/onlineShop.html';
                        }
                    }, 1000)
                    let dataUsers = Object.entries(response)
                    let users = null
                    dataUsers.forEach(user => {
                        users = user[1]
                    })
                    users.forEach(user => {
                        console.log(user)
                    })
                })
                .catch(error => {
                    console.log(error);
                    if (uname.value != '' && lpass.value != '' && alertlpass.style.display == 'none')
                        modalContainer.style.display = 'block'
                    setTimeout(() => {
                        modalContainer.style.display = 'none'
                    }, 4000)
                })
        })
    </script>
</body>

</html>
