@extends('users.layout.layout')

@section('title', 'Fan Club | Community')

@section('main-content')

    <section class="banner community-banner">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h1>Community</h1>
                        <h2>( Events / Charities / Fundraising )</h2>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div id="service" class=" black-squeeze-bg svg-wrap">
        <svg class="svg-top-left" viewBox="0 0 1920 469.1">
            <path d="M0,1080V610.9H1920V731.7c-19.5,12.6-304.8,186.4-783.6-21.3C640.1,495.1,641.7,726.8,357.5,819.1S204.6,1064.7,0,1080Z" transform="translate(0 -610.9)" fill="#fff"></path>
        </svg>
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="section-header-3 section-header-black">
                        <h2>How Can You Help</h2>
                    </div>
                </div>

            </div>

            <div class="row">
                 <div class="col-md-7">
                    <div class="com-img">
                        <img src="{{asset('user-assets')}}/website/images/communityvidBg.png" class="img-fluid">

                        <div class="play">
                        <a href=""><i class="fa-solid fa-play"></i>    </a>
                         </div>
                    </div>
                </div>

                <div class="col-md-5">
                    <div class="com-con">
                        <h1>Help For Cause</h1>
                        <p>Our organization is dedicated to providing vital assistance to those affected by a critical cause. With your support, we can make a tangible difference in their lives. Through various initiatives and programs, we strive to alleviate suffering, offer essential resources, and empower individuals to overcome adversity. Your contribution, whether big or small, can help us bring hope.</p>
                    </div>

                    <div class="com-img-1">
                        <img src="{{asset('user-assets')}}/website/images/boyIcon.png" class="img-fluid">
                        <img src="{{asset('user-assets')}}/website/images/circleBox.png" class="img-fluid">
                        <img src="{{asset('user-assets')}}/website/images/clock.png" class="img-fluid">
                        <img src="{{asset('user-assets')}}/website/images/stars.png" class="img-fluid">
                    </div>
                </div>
            </div>

        </div>
        <svg class="svg-bottom-left" viewBox="0 0 1920 469.1">
            <path d="M0,610.9V1080H1920V959.2c-19.5-12.6-304.8-186.4-783.6,21.3-496.3,215.3-494.7-16.4-778.9-108.7S204.6,626.2,0,610.9Z" transform="translate(0 -610.9)" fill="#fff"></path>
        </svg>

    </div>



    <section class="com-sec-2">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="com-sec-2-parent">
                        <img src="{{asset('user-assets')}}/website/images/joinUs.png" class="img-fluid">
                        <h2>Join Us</h2>
                        <p>Join our community of like-minded individuals and
                            make a difference today.Be part of a movement that is changing the world. Join us in our mission
                            to create a better future for all.</p>
                    </div>
                </div>

                 <div class="col-md-3">
                    <div class="com-sec-2-parent">
                        <img src="{{asset('user-assets')}}/website/images/cause.png" class="img-fluid">
                        <h2>Urgent Cause</h2>
                        <p>URGENT CAUSE: We need your immediate support to
                            address a pressing crisis affecting vulnerable communities. Time is of the essence as lives hang
                            in the balance. </p>
                    </div>
                </div>

                 <div class="col-md-3">
                    <div class="com-sec-2-parent">
                        <img src="{{asset('user-assets')}}/website/images/donate.png" class="img-fluid">
                        <h2>Donate</h2>
                        <p>Give hope, make an impact. Donate today and change
                            lives. Your generosity matters. Donate now to support our mission and make a difference.</p>
                    </div>
                </div>


                 <div class="col-md-3">
                    <div class="com-sec-2-parent">
                        <img src="{{asset('user-assets')}}/website/images/news.png" class="img-fluid">
                        <h2>Newsletter</h2>
                        <p>Join our community and be the first to know.
                            Subscribe to our newsletter for insightful articles and exciting news.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="com-sec-3">
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <div class="com-sec-3">
                        <img src="{{asset('user-assets')}}/website/images/communityImg.png" class="img-fluid">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="com-sec-3-ha">
                        <h1>Community</h1>
                        <p>We believe that giving back to our community is an essential part of our mission as a company. That's why we're excited to offer our members the opportunity to support a nonprofit organization of their choice through our Read More.</p>
                    </div>

                    <div class="com-sec-3-he-img">
                         <img src="{{asset('user-assets')}}/website/images/bench.png" class="img-fluid">
                        <div class="com-sec-3-he-img-fl">
                           <h4>Events</h4>
                        <p>Unforgettable moments, unforgettable event. Join us for an experience like no other.</p>
                        </div>

                    </div>

                    <div class="com-sec-3-he-img">
                         <img src="{{asset('user-assets')}}/website/images/coin.png" class="img-fluid">
                        <div class="com-sec-3-he-img-fl">
                             <h4>Charities</h4>
                        <p>Make a difference today. Support impactful charities that change lives.</p>
                        </div>

                    </div>

                    <div class="com-sec-3-he-img">
                        <img src="{{asset('user-assets')}}/website/images/FundRaising.png" class="img-fluid">
                        <div class="com-sec-3-he-img-fl">
                             <h4>Fundraising</h4>
                        <p>Join our mission to raise funds and transform lives. Together, we can achieve remarkable outcomes.</p>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
