<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\User\PagesController;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\ViewsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('users.pages.index');
})->name('index.get');

Route::get('/about',[PagesController::class,'aboutPage'])->name('about.get');
Route::get('/bussiness',[PagesController::class,'bussinessPage'])->name('bussiness.get');
Route::get('/community',[PagesController::class,'communityPage'])->name('community.get');
Route::get('/deals',[PagesController::class,'dealsPage'])->name('deals.get');
Route::get('/membership',[PagesController::class,'membershipPage'])->name('membership.get');
Route::get('/social-media',[PagesController::class,'socialmediaPage'])->name('social-media.get');

// authentication
// user auth
Route::get('/register', [AuthController::class, 'registerPage'])->name('register.get');
// logout
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

Route::post('/register', [AuthController::class, 'registerPost'])->name('register.post');
Route::post('/login', [AuthController::class, 'loginPost'])->name('login.post');

Route::get('/forgot-password', [AuthController::class, 'forgotPage'])->name('forgot.get');
Route::post('/forgot-password', [AuthController::class, 'forgotPost'])->name('forgot.post');

Route::get('/reset/{token}/password', [AuthController::class, 'resetPage'])->name('reset.get');
Route::post('/reset-password', [AuthController::class, 'resetPost'])->name('reset.post');


// admin auth
Route::get('/admin', [AdminAuthController::class, 'adminloginPage'])->name('admin.login.get');

Route::get('/admin/forgot-password', [AdminAuthController::class, 'adminforgotPage'])->name('admin.forgot.get');
Route::post('/admin/forgot-password', [AdminAuthController::class, 'adminforgotPost'])->name('admin.forgot.post');

Route::get('/admin/reset/{token}/password', [AdminAuthController::class, 'adminresetPage'])->name('admin.reset.get');
Route::post('/admin/reset-password', [AdminAuthController::class, 'adminresetPost'])->name('admin.reset.post');

// admin pages
Route::get('/admin/dashboard', [ViewsController::class, 'adminindexPage'])->name('admin.index.get');
