<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
        integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css"
        integrity="sha512-sMXtMNL1zRzolHYKEujM2AqCLUR9F2C4/05cdbxjjLSRvMQIciEPCQZo++nk7go3BtSuK9kfa/s+a4f4i5pLkw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@200;300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo e(asset('user-assets')); ?>/css/style.css">
    <link href="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" rel="shortcut icon" type="image/x-icon" />
    <link href="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" rel="apple-touch-icon" />
    <title>Fan Club Card | Home</title>
</head>

<body class="home-body">
    <section class="home">
        <div class="home-slider owl-carousel owl-theme">
            <a href="<?php echo e(route('index.get')); ?>">
                <div class="item">
                    <div class="card" data-id="who-we-are">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Who We Are & <br>What We Do </h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img class="" src="<?php echo e(asset('user-assets')); ?>/image/WhoweAre.jpg" alt="">
                    </div>
                </div>
            </a>
            <a href="<?php echo e(route('deals.get')); ?>">
                <div class="item">
                    <div class="card" data-id="local-deals">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Local <br> Deals</h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="purple">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="purple">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="purple">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="purple">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img src="<?php echo e(asset('user-assets')); ?>/image/localDeals.jpg" alt="">
                    </div>
                </div>
            </a>
            <a href="<?php echo e(route('social-media.get')); ?>">
                <div class="item">
                    <div class="card" data-id="social-media">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Social Media</h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img src="<?php echo e(asset('user-assets')); ?>/image/socialMedia.jpg" alt="">
                    </div>
                </div>
            </a>
            <a href="<?php echo e(route('membership.get')); ?>">
                <div class="item">
                    <div class="card" data-id="membership">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Membership</h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img src="<?php echo e(asset('user-assets')); ?>/image/membership.jpg" alt="">
                    </div>
                </div>
            </a>
            <a href="<?php echo e(route('community.get')); ?>">
                <div class="item">
                    <div class="card" data-id="community">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Community ( Events / Charities / Fundraising )</h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img src="<?php echo e(asset('user-assets')); ?>/image/community.jpg" alt="">
                    </div>
                </div>
            </a>
            <a href="<?php echo e(route('bussiness.get')); ?>">
                <div class="item">
                    <div class="card" data-id="business-partnerships">
                        <div class="transparent"> </div>
                        <div class="card-content">
                            <h1 class="h1">Business Partnerships</h1>
                            <ul>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">JOIN FANCLUBCARD</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li>BE A PART OF FANCLUBCARD COMMUNITY</li>
                                <li>
                                    <div class="circle"></div>
                                </li>
                                <li class="orange">FREE MEMBERSHIP</li>
                            </ul>
                        </div>
                        <img src="<?php echo e(asset('user-assets')); ?>/image/businessPartnership.jpg" alt="">
                    </div>
                </div>
            </a>
        </div>
    </section>

    <section class="left-info-wrapper white-left-info-wrapper" id="who-we-are">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/WhoweAre.jpg" alt="" class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text">1 — 6</div>
                                    <div class="small-divider"></div>
                                    <div class="header-text">HOME</div>
                                </div>
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1>WHO WE ARE & WHAT WE DO</h1>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text w-clearfix"><span class="cap">W</span>elcome to our FanClubCard! We
                                are a dedicated community of fans who share a common love and passion for various
                                subjects. Whether you're a fan of music, movies, sports, or any other form of
                                entertainment, we've got you covered. <br> Our mission is to provide a platform where
                                fans can connect, share their enthusiasm, and stay updated on the latest news and
                                developments in their favorite domains. We offer a wide range of content tailored to
                                meet the interests of our diverse fan base.</p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image3_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image1_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image2_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle orange"></div>
                            <p class="rich-text w-clearfix"><span class="cap">E</span>xclusive Discounts and
                                Offers: As a member of our fan club, you'll enjoy access to special discounts and offers
                                on merchandise, tickets, and other fan-related products. We collaborate with trusted
                                partners to bring you the best deals and ensure you get the most value for your
                                money.<br><br> Fan-Generated Content: Showcase your creativity! We encourage fans to
                                contribute their own content, such as fan art, fan fiction, or cover songs. This allows
                                you to express your passion and talent while connecting with others who appreciate your
                                work.<br><br> Special Events and Contests: Participate in exciting events and contests
                                organized exclusively for our members. From meet-ups and virtual concerts to trivia
                                challenges and giveaways, we offer unique experiences to enhance your fandom journey.
                            </p>
                            <div class="divider-circle orange"></div>
                            <a href="about.php" class="link-read-more w-inline-block">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="about.php" target="_blank" class="link-read-more w-inline-block">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="left-info-wrapper" id="local-deals">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/localDeals.jpg" alt="" class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text black">2 — 6</div>
                                    <div class="small-divider black"></div>
                                    <div class="header-text black">LOCAL DEALS</div>
                                </div>
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1>Everything you need—on a budget</h1>
                            <div class="divider-circle"></div>
                            <p class="w-clearfix"><span class="cap">L</span>ooking for amazing deals and offers
                                that will blow your mind? Look no further! Our exclusive selection of unbeatable deals
                                and offers will leave you wanting more. From discounted products and services to
                                limited-time promotions, we've got everything you need to save big and shop smart. Don't
                                miss out on these incredible deals and offers - shop now and start saving!</p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image4_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image5_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image6_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle"></div>
                            <p class="w-clearfix"><span class="cap">A</span>t our online marketplace, we pride
                                ourselves on offering a wide variety of deals and offers to suit every need and taste.
                                Plus, our selection is constantly updated to ensure you never miss out on the latest and
                                greatest discounts. And with our user-friendly interface and secure payment system, it's
                                never been easier or safer to shop for deals and offers online. So why wait? Start
                                exploring our amazing deals and offers today and start saving like a pro!</p>
                            <div class="divider-circle"></div>
                            <a href="deals.php" class="link-read-more w-inline-block">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="deals.php" target="_blank" class="link-read-more w-inline-block">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="left-info-wrapper black-left-info-wrapper" id="community">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/community.jpg" alt="" class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text">3 — 6</div>
                                    <div class="small-divider"></div>
                                    <div class="header-text">COMMUNITY</div>
                                </div>
                                <div class="alt-text-header white">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1 class="heading is--white">Events / Charities / Fundraising</h1>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">W</span>elcome to our Community Fundraising, Charity, and
                                Events page! At Fan club Card, we are passionate about making a positive impact in our
                                community. Join us in our efforts to support important causes, raise funds for charity,
                                and participate in engaging events. Together, we can create a better world. Explore the
                                various ways you can get involved:</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">F</span>undraising Campaigns:<br> Stay updated with our
                                ongoing fundraising campaigns dedicated to supporting charitable organizations and
                                initiatives. Learn about the causes we are passionate about and the impact we aim to
                                make. Join our fundraising efforts by donating, spreading awareness, and sharing the
                                campaign with your network. Together, we can make a difference.</p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image7_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image8_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image9_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">C</span>ommunity Events:<br> Discover exciting community
                                events organized by Fan club Card. From charity runs and walks to food drives,
                                volunteering activities, and awareness campaigns, there are numerous opportunities to
                                get involved. Engage with like-minded individuals, connect with local organizations, and
                                contribute your time and effort to meaningful causes. Check our event calendar regularly
                                for upcoming events you can participate in.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">C</span>harity Spotlight:<br> Explore the inspiring work of
                                various charitable organizations that we support. Learn about their mission, programs,
                                and impact. We highlight their efforts to raise awareness and funds for important
                                causes. Consider getting involved directly with these organizations, volunteering, or
                                donating to support their vital work.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">V</span>olunteer Opportunities:<br> Looking to make a
                                hands-on impact? Discover volunteer opportunities available in your community. We
                                provide information about local volunteer programs, non-profit organizations, and
                                initiatives that are seeking dedicated individuals like you. Sign up for volunteer
                                opportunities and help create positive change on a personal level.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">I</span>mpact Stories:<br> Read heartwarming stories of the
                                impact our community has made through our fundraising, charity, and events initiatives.
                                Learn about the lives we've touched, the projects we've supported, and the positive
                                change we've brought about. These stories serve as inspiration and a testament to the
                                power of collective action.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">G</span>et Involved:<br> Ready to make a difference? Find
                                out how you can get involved in our community fundraising, charity, and events
                                initiatives. Whether it's through donating, volunteering, participating in events, or
                                spreading the word, your support matters. Together, we can amplify our impact and create
                                lasting change.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white">Join us in our commitment to
                                building a stronger, more compassionate community. Together, we can uplift and support
                                those in need. Stay connected with us and be part of something greater than yourself.
                            </p>
                            <div class="divider-circle orange"></div>
                            <a href="community.php" class="link-read-more w-inline-block white">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="community.php" target="_blank" class="link-read-more w-inline-block white">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="left-info-wrapper red-left-info-wrapper" id="social-media">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/socialMedia.jpg" alt="" class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text black">4 — 6</div>
                                    <div class="small-divider black"></div>
                                    <div class="header-text black">SOCIAL MEDIA</div>
                                </div>
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1>SOCIAL MEDIA</h1>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">F</span>acebook:<br> Connect with us on Facebook and become
                                a part of our online community. Like our page to receive updates on new products,
                                promotions, and upcoming events. Engage with fellow fans, share your thoughts, and get
                                involved in discussions. Join us today!</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">T</span>witter:<br> Follow us on Twitter for real-time
                                updates, short snippets of information, and behind-the-scenes insights. Get a glimpse
                                into our daily activities, industry news, and exciting announcements. Retweet, reply,
                                and join the trending conversations. Let's tweet together!</p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image7_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image8_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image9_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">I</span>nstagram:<br> Discover captivating visuals, stunning
                                product shots, and behind-the-scenes stories on our Instagram account. Follow us to get
                                inspired, stay up-to-date with the latest trends, and see how our products are being
                                used by our customers. Don't forget to double-tap those beautiful images!</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">T</span>ikTok:<br> Join us on TikTok and dive into a world
                                of short and entertaining videos. Follow our TikTok account to discover unique and
                                creative content related to our brand. From product showcases to funny skits,
                                challenges, and behind-the-scenes moments, we've got it all. Hit the "Follow" button and
                                never miss out on our viral TikTok trends.</p>
                            <div class="divider-circle orange"></div>
                            <a href="socialmedia.php" class="link-read-more w-inline-block">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="socialmedia.php" target="_blank" class="link-read-more w-inline-block">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="left-info-wrapper white-left-info-wrapper" id="membership">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/membership.jpg" alt="" class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text">5 — 6</div>
                                    <div class="small-divider orange"></div>
                                    <div class="header-text">MEMBERSHIP</div>
                                </div>
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1>BECOME A MEMBER</h1>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">W</span>elcome to our Membership page! By becoming a member,
                                you unlock a range of exclusive benefits and gain access to premium features. Join our
                                community of like-minded individuals who share a common interest in [describe the focus
                                or theme of your website]. Take your experience to the next level and enjoy the
                                following perks:</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">E</span>xclusive Content:<br> As a member, you'll have
                                access to a wealth of exclusive content not available to regular website visitors. Enjoy
                                in-depth articles, premium videos, podcasts, e-books, and other valuable resources
                                created specifically for our members. Dive deeper into your area of interest and expand
                                your knowledge.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">E</span>arly Access:<br> Be the first to know! As a member,
                                you'll receive early access to new features, products, and updates on our website. Stay
                                ahead of the curve and get a head start on the latest trends, releases, and
                                announcements. We value your membership and want to ensure you're always in the know.
                            </p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image7_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image8_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image9_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">C</span>ommunity Forum:<br> Join our vibrant community forum
                                where members can connect, engage, and share their thoughts and experiences. Participate
                                in discussions, ask questions, seek advice, and contribute your expertise. Connect with
                                fellow members, build relationships, and foster a supportive network within our
                                community.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">E</span>xclusive Events:<br> Get ready for exclusive
                                member-only events! Attend virtual meetups, webinars, workshops, and live Q&amp;A
                                sessions with industry experts and thought leaders. Interact with like-minded
                                individuals, exchange ideas, and gain valuable insights. Our events are designed to
                                enrich your knowledge and provide networking opportunities.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">D</span>iscounts and Offers:<br> Enjoy special discounts and
                                offers tailored exclusively for our members. Take advantage of discounted rates on
                                products, services, and events. We strive to provide extra value to our loyal members
                                and make your experience even more rewarding.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">P</span>ersonalized Recommendations:<br> We understand your
                                interests and preferences. As a member, you'll receive personalized recommendations
                                based on your browsing history, engagement, and feedback. Discover relevant content,
                                products, and resources that cater specifically to your needs and interests.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:black"><span
                                    class="cap is--purple">J</span>Join our membership program today and unlock a world
                                of exclusive benefits. Choose from our various membership tiers to find the option that
                                best suits you. We appreciate your support and commitment to our community. Together,
                                let's learn, grow, and thrive!</p>
                            <div class="divider-circle orange"></div>
                            <a href="memberships.php" class="link-read-more w-inline-block">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="memberships.php" target="_blank" class="link-read-more w-inline-block">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="left-info-wrapper black-left-info-wrapper" id="business-partnerships">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-6 pr-0">
                    <img src="<?php echo e(asset('user-assets')); ?>/image/businessPartnership.jpg" alt=""
                        class="left-img">
                </div>
                <div class="col-md-6 pl-0">
                    <button class="btn btn-close">
                        <div>✕</div>
                    </button>
                    <div class="left-info">
                        <div class="inner-container">
                            <div class="left-logo">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/fanclubcard.png" alt="">
                            </div>
                            <div class="header-row">
                                <div class="inner-header-col">
                                    <div class="header-text">6 — 6</div>
                                    <div class="small-divider orange"></div>
                                    <div class="header-text">BUSINESS PARTNERSHIPS</div>
                                </div>
                                <div class="alt-text-header white">© • 2023 • Fan Club Card</div>
                            </div>
                            <h1 class="is--white">JOIN HANDS AS BUSINESS PARTNERS</h1>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">W</span> elcome to our Business Partnerships page! At Fan
                                Club Card, we believe in the power of collaboration and strategic alliances. We value
                                building strong relationships with like-minded businesses to drive mutual growth and
                                success. Explore the various opportunities for business partnerships and discover how we
                                can work together:</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">J</span>oint Ventures:<br> We are open to exploring joint
                                venture opportunities with businesses that align with our vision and values. By
                                combining our expertise, resources, and networks, we can create innovative products,
                                services, or projects that benefit both parties. Let's leverage each other's strengths
                                and embark on a mutually beneficial journey.</p>
                        </div>
                        <div class="wrap-image-content">
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image7_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image8_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                            <div class="image-content">
                                <img src="<?php echo e(asset('user-assets')); ?>/image/image9_1200.png" loading="lazy"
                                    sizes="100vw" alt="" class="image">
                            </div>
                        </div>
                        <div class="inner-container">
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">A</span>ffiliate Programs:<br> Join our affiliate program
                                and become a valued partner. Promote our products or services on your platform and earn
                                a commission for every referral or sale generated. We provide comprehensive support,
                                including marketing materials, tracking tools, and dedicated affiliate management.
                                Together, we can increase brand exposure and drive revenue.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">C</span>o-Marketing Initiatives:<br> Let's join forces to
                                amplify our marketing efforts. Collaborate on co-marketing campaigns, content creation,
                                and cross-promotions to reach a wider audience. By combining our marketing resources and
                                sharing our expertise, we can maximize brand visibility, attract new customers, and
                                create compelling campaigns that leave a lasting impact.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">P</span>roduct Integration:<br> If our products or services
                                complement each other, let's explore opportunities for integration. By integrating our
                                offerings, we can provide enhanced value and a seamless experience to our customers.
                                Together, we can create innovative solutions that address their needs more effectively.
                            </p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">S</span>upplier or Vendor Partnerships:<br> We are always on
                                the lookout for reliable and high-quality suppliers or vendors. If you offer products or
                                services that align with our requirements, let's discuss how we can collaborate. By
                                establishing strong partnerships, we can ensure a consistent supply chain, improve
                                operational efficiency, and deliver exceptional experiences to our customers.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white"><span
                                    class="cap is--purple">S</span>trategic Alliances:<br> If you have a strategic
                                vision or initiative that aligns with ours, let's explore the potential for a strategic
                                alliance. Whether it's entering new markets, leveraging shared resources, or pursuing
                                common goals, strategic alliances can drive growth, expand reach, and create a
                                competitive advantage. Let's shape the future together.</p>
                            <div class="divider-circle orange"></div>
                            <p class="rich-text white w-clearfix" style="color:white">At Fan Club Card we value
                                long-term, mutually beneficial partnerships. We believe that by working together, we can
                                achieve more. If you're interested in exploring a business partnership with us, we would
                                love to hear from you. Contact our partnership team to discuss how we can collaborate
                                and unlock new opportunities.</p>
                            <div class="divider-circle orange"></div>
                            <a href="bussines.php" class="link-read-more w-inline-block white">
                                <div>Go</div>
                                <div class="arrow-read-more"><img
                                        src="<?php echo e(asset('user-assets')); ?>/image/icon-arrow.svg" loading="lazy"
                                        alt=""></div>
                            </a>
                            <a href="bussines.php" target="_blank" class="link-read-more w-inline-block white">
                                <div class="alt-text-header">© • 2023 • Fan Club Card</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"
        integrity="sha512-3P8rXCuGJdNZOnUx/03c1jOTnMn3rP63nBip5gOP2qmUh5YAdVAvFZ1E+QLZZbC1rtMrQb+mah3AfYW11RUrWA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"
        integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js"
        integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
        integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="<?php echo e(asset('user-assets')); ?>/js/script.js"></script>


    <script type="text/javascript">
        $('.home-slider').owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            responsive: {
                0: {
                    items: 1
                },
                600: {
                    items: 3
                },
                1000: {
                    items: 3
                }
            }
        });
    </script>
</body>

</html>
<?php /**PATH D:\xamp_8\htdocs\funclub\resources\views/users/pages/index.blade.php ENDPATH**/ ?>