@extends('admin.layouts.layout')

@section('title', 'Admin | Blogs')

@section('main-content')

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="page-header">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Groups</li>
                    </ol>
                </nav>
            </div>
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">Groups</h4>
                                </div>
                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 grid-margin stretch-card">
                    <div class="card" style="background: #73798b;">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-dark">
                                    <thead class="bg-dark">
                                        <tr>
                                            <th> # </th>
                                            <th class="text-white"> Profile </th>
                                            <th class="text-white"> Group Title </th>
                                            <th class="text-white"> Limit </th>
                                            <th class="text-white"> Policy </th>
                                            <th class="text-white"> Status </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($groups as $group)
                                            @php

                                            @endphp
                                            <tr>
                                                <td> {{ $i++ }} </td>
                                                @if ($group->group_profile)
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('uploads/groups/' . $group->group_profile) }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @else
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('user-assets/assets/images/avatar-5.jpg') }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @endif
                                                <td> {{ $group->group_name }} </td>
                                                <td> {{ $group->group_limit }} </td>
                                                <td> {!! Str::limit($group->group_policy, 70) !!} </td>
                                                <td>
                                                    <div style="padding: 10px; display: flex;
                                                    align-items: center; justify-content: center; background: white; font-size: 15px; cursor: pointer;"
                                                        class="removeGrp" data-groupid="{{ $group->id }}">
                                                        <i class="fa fa-trash text-danger"></i>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addCat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Blog</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-close text-white"></i>
                    </button>
                </div>
                @php
                    $cats = DB::table('blog_categories')->get();
                @endphp
                <div class="modal-body">
                    <form action="{{ route('admin.blogs.post') }}" method="post" class="forms-sample"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleFormControlSelect2">Select Category</label>
                            <select name="cat_slug" class="form-control" id="exampleFormControlSelect2">
                                @foreach ($cats as $item)
                                    <option value="{{ $item->cat_slug }}">{{ $item->cat_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Blog File</label>
                            <input type="file" name="blog_file[]" class="form-control" multiple>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Blog Title</label>
                            <input type="text" name="blog_title" class="form-control" id="exampleInputEmail1"
                                placeholder="Blog title...">
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Blog Tags</label>
                            <input type="text" name="blog_tags" class="form-control" id="exampleInputEmail1"
                                placeholder="Blog tags...">
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Blog Content</label>
                            <textarea type="text" name="blog_content" class="form-control ckeditor"></textarea>
                        </div>
                        <hr class="text-white">
                        <div class="d-flex justify-content-between">
                            <div>
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                            <div>
                                <button type="submit" class="btn btn-success mr-2">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.removeGrp').click(function() {
                var groupId = $(this).data('groupid');
                console.log(groupId);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: '{{ route('remove-group.post') }}',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "groupId": groupId,
                    },
                    dataType: "json",
                    success: function(response) {
                        if (response.success == 1) {
                            console.log(response);
                            toastr.success(response.message);
                            window.location.reload();
                        } else {
                            console.log(response);
                            toastr.error(response.message);
                            window.location.reload();
                        }
                    },
                });
            });
        });
    </script>

@endsection
