@extends('admin.layouts.layout')

@section('title', 'Admin | Group Members')

@section('main-content')

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="page-header">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Group Members</li>
                    </ol>
                </nav>
            </div>
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">Group Members</h4>
                                </div>
                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 grid-margin stretch-card">
                    <div class="card" style="background: #73798b;">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-dark">
                                    <thead class="bg-dark">
                                        <tr>
                                            <th> # </th>
                                            <th class="text-white"> Profile </th>
                                            <th class="text-white"> Name </th>
                                            <th class="text-white"> Email </th>
                                            <th class="text-white"> Status </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($users as $user)
                                            @php
                                                $grpMem = DB::table('group_members')
                                                    ->where('member_id', $user->id)
                                                    ->where('group_id', $group->id)
                                                    ->first();
                                            @endphp
                                            <tr>
                                                <td> {{ $i++ }} </td>
                                                @if ($user->profile)
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('uploads/users/' . $user->profile) }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @else
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('user-assets/assets/images/avatar-5.jpg') }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @endif
                                                <td> {{ $user->name }} </td>
                                                <td> {{ $user->email }} </td>
                                                <td>
                                                    @if ($grpMem)
                                                        <div style="padding: 10px; display: flex;
                                                    align-items: center; justify-content: center; background: #120b0b; font-size: 15px; cursor: pointer;" class="removeUser" data-groupid="{{ $group->id }}" data-friendId="{{ $user->id }}"><i class="fa fa-trash text-danger"></i></div>
                                                    @else
                                                    <div style="padding: 10px; display: flex;
                                                    align-items: center; justify-content: center; background: #120b0b; font-size: 15px; cursor: pointer;" class="removeUser" data-groupid="{{ $group->id }}" data-friendId="{{ $user->id }}"><i class="fa fa-plus text-danger"></i></div>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.removeUser').click(function() {
                var groupId = $(this).data('groupid');
                var friendId = $(this).data('friendid');
                console.log(friendId, groupId);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: '{{ route('group-remove-user.post') }}',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "groupId": groupId,
                        "friendId": friendId,
                    },
                    dataType: "json",
                    success: function(response) {
                        if (response.success == 1) {
                            console.log(response);
                            toastr.success(response.message);
                            window.location.reload();
                        } else {
                            console.log(response);
                            toastr.error(response.message);
                            window.location.reload();
                        }
                    },
                });
            });
        });
    </script>

@endsection
