@extends('admin.layouts.layout')

@section('title', 'Admin | Blogs')

@section('main-content')

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="page-header">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Groups</li>
                    </ol>
                </nav>
            </div>
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">Groups</h4>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-info mr-2" data-toggle="modal"
                                        data-target="#addCat">Create Group</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 grid-margin stretch-card">
                    <div class="card" style="background: #73798b;">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-dark">
                                    <thead class="bg-dark">
                                        <tr>
                                            <th> # </th>
                                            <th class="text-white"> Profile </th>
                                            <th class="text-white"> Group Title </th>
                                            <th class="text-white"> Limit </th>
                                            <th class="text-white"> Policy </th>
                                            <th class="text-white"> Members </th>
                                            <th class="text-white"> Status </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($groups as $group)
                                            @php

                                            @endphp
                                            <tr>
                                                <td> {{ $i++ }} </td>
                                                @if ($group->group_profile)
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('uploads/groups/' . $group->group_profile) }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @else
                                                    <td>
                                                        <div style="width: 100px; height: 100px;">
                                                            <img src="{{ asset('user-assets/assets/images/avatar-5.jpg') }}"
                                                                alt="" style="width: 100px; height: 100px;">
                                                        </div>
                                                    </td>
                                                @endif
                                                <td> {{ $group->group_name }} </td>
                                                <td> {{ $group->group_limit }} </td>
                                                <td> {!! Str::limit($group->group_policy, 70) !!} </td>
                                                <td>
                                                    <a href="{{ route('admin.group-mem.get', $group->id) }}">
                                                        <div style="padding: 10px; display: flex;
                                                    align-items: center; justify-content: center; background: rgb(68, 40, 40); font-size: 15px; cursor: pointer;"
                                                            class="">
                                                            <i class="fa fa-eye text-danger"></i>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td>
                                                    <div style="padding: 10px; display: flex;
                                                    align-items: center; justify-content: center; background: white; font-size: 15px; cursor: pointer;"
                                                        class="removeGrp" data-groupid="{{ $group->id }}">
                                                        <i class="fa fa-trash text-danger"></i>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addCat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Group Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-close text-white"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('create-group.post') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="file" class="form-control" name="group_profile" value="">
                        <div class="nk-gap-2 mb-3"></div>
                        <input type="text" class="form-control" name="group_name" placeholder="Group Name *"
                            value="">
                        <div class="nk-gap-2 mb-3"></div>
                        <input type="number" class="form-control" name="group_limit" placeholder="Group limit *"
                            value="">
                        <div class="nk-gap-2 mb-3"></div>
                        <label for="group_description">Group Description</label>
                        <textarea type="text" class="form-control ckeditor" name="group_description" placeholder="Group Description *"
                            rows="5"></textarea>
                        <div class="nk-gap mb-3"></div>
                        <label for="group_policy">Group Policy</label>
                        <textarea type="text" class="form-control ckeditor" name="group_policy" placeholder="Group policy * *"
                            rows="5"></textarea>
                        <div class="nk-gap mb-3"></div>
                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" name="notify_members" class="form-check-input">
                                Notify group members of these changes via email
                            </label>
                        </div>
                        <div class="nk-gap-2"></div>
                        <h3 class="h5">Privacy Options</h3>
                        <fieldset class="form-group">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="radio" class="form-check-input" name="group_type" id="optionsRadios1"
                                        value="public_group" checked>
                                    This is a public group
                                </label>
                            </div>
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="radio" class="form-check-input" name="group_type" id="optionsRadios2"
                                        value="private_group">
                                    This is a private group
                                </label>
                            </div>
                        </fieldset>
                        <div class="nk-gap-2"></div>
                        <div class="text-center">
                            <button class="btn btn-success text-center">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.removeGrp').click(function() {
                var groupId = $(this).data('groupid');
                console.log(groupId);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: '{{ route('remove-group.post') }}',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "groupId": groupId,
                    },
                    dataType: "json",
                    success: function(response) {
                        if (response.success == 1) {
                            console.log(response);
                            toastr.success(response.message);
                            window.location.reload();
                        } else {
                            console.log(response);
                            toastr.error(response.message);
                            window.location.reload();
                        }
                    },
                });
            });
        });
    </script>

@endsection
