@section('title','Register')
@extends('layouts.main')
@section('css')
<style>
*{
    margin: 0;
    padding: 0;
    font-family: 'poppins',sans-serif;
}
section{
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    width: 100%;
    
    background: url('https://raw.githubusercontent.com/Hashtechieofficial/Form-/main/background6.jpg')no-repeat;
    background-position: center;
    background-size: cover;
}
.form-box{
    position: relative;
    width: 400px;
    height: 450px;
    background: transparent;
    border: 2px solid rgba(255,255,255,0.5);
    border-radius: 20px;
    backdrop-filter: blur(15px);
    display: flex;
    justify-content: center;
    align-items: center;

}
h2{
    font-size: 2em;
    color: #fff;
    text-align: center;
}
.inputbox{
    position: relative;
    margin: 30px 0;
    width: 310px;
    border-bottom: 2px solid #fff;
}
.inputbox label{
    position: absolute;
    top: 50%;
    left: 5px;
    transform: translateY(-50%);
    color: #fff;
    font-size: 1em;
    pointer-events: none;
    transition: .5s;
}
input:focus ~ label,
input:valid ~ label{
top: -5px;
}
.inputbox input {
    width: 100%;
    height: 50px;
    background: transparent;
    border: none;
    outline: none;
    font-size: 1em;
    padding:0 35px 0 5px;
    color: #fff;
}
.inputbox ion-icon{
    position: absolute;
    right: 8px;
    color: #fff;
    font-size: 1.2em;
    top: 20px;
}
.forget{
    margin: -15px 0 15px ;
    font-size: .9em;
    color: #fff;
    display: flex;
    justify-content: space-between;  
}

.forget label input{
    margin-right: 3px;
    
}
.forget label a{
    color: #fff;
    text-decoration: none;
}
.forget label a:hover{
    text-decoration: underline;
}
button{
    width: 100%;
    height: 40px;
    border-radius: 40px;
    background: #fff;
    border: none;
    outline: none;
    cursor: pointer;
    font-size: 1em;
    font-weight: 600;
}
.register{
    font-size: .9em;
    color: #fff;
    text-align: center;
    margin: 25px 0 10px;
}
.register p a{
    text-decoration: none;
    color: #fff;
    font-weight: 600;
}
.register p a:hover{
    text-decoration: underline;
}
</style>
@endsection
@section('content')
<!--<section class="banner">-->
<!--    <div class="container">-->
<!--        <div class="row">-->
<!--            <div class="col-lg-12">-->
<!--                <div class="banner-wrapper inner-banner-wrapper">-->
<!--                    <div class="row justify-content-center">-->
<!--                        <div class="col-lg-10">-->
<!--                            <div class="section-heading text-center">-->
<!--                                <h1>My Account</h1>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<!--<section class="account">-->
<!--    <div class="container" id="from-wrapper">-->
<!--        <div class="form-container sign-up-container">-->
<!--            <form  method="POST" action="{{ route('register') }}">-->
<!--                @csrf-->
<!--                <h1>Sign Up</h1>-->
<!--                <div class="form-group">-->
<!--                    <label>Username*</label>-->
<!--                    <input type="text" class="form-control {{ $errors->registerForm->has('name') ? ' is-invalid' : '' }}" name="name" id="name"required>-->
<!--                    @if ($errors->registerForm->has('name'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->registerForm->first('name') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Email Address*</label>-->
<!--                    <input type="email" class="form-control {{ $errors->registerForm->has('email') ? ' is-invalid' : '' }}" name="email" id="signup-email" required>-->
<!--                    @if ($errors->registerForm->has('email'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->first('email') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Phone*</label>-->
<!--                    <input type="text" class="form-control {{ $errors->registerForm->has('phone') ? ' is-invalid' : '' }}" id="phone" name="phone" required>-->
<!--                    @if ($errors->registerForm->has('phone'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->first('phone') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Address*</label>-->
<!--                    <input type="text" class="form-control {{ $errors->registerForm->has('address') ? ' is-invalid' : '' }}" name="address" id="address" required>-->
<!--                    @if ($errors->registerForm->has('address'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->first('address') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Password*</label>-->
<!--                    <input type="password" class="form-control {{ $errors->registerForm->has('password') ? ' is-invalid' : '' }}" name="password" id="signup-password" required>-->
<!--                    @if ($errors->registerForm->has('password'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->first('password') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Confirm Password*</label>-->
<!--                    <input type="password" class="form-control" name="password_confirmation" id="signup-password" required>-->
<!--                    @if ($errors->registerForm->has('password_confirmation'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->registerForm->first('password_confirmation') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <button class="btn btn-yellow" type="submit">Sign Up</button>-->
<!--            </form>-->
<!--        </div>-->
<!--        <div class="form-container sign-in-container">-->
<!--            <form method="POST" action="{{ route('login') }}">-->
<!--                @csrf-->
<!--                <h1>Login</h1>-->
<!--                <div class="form-group">-->
<!--                    <label>Username or email address*</label>-->
<!--                    <input type="email" class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>-->
<!--                    @if ($errors->has('email'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('email') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label>Password*</label>-->
<!--                    <input type="password" class="form-control {{ $errors->has('password') ? ' is-invalid' : '' }}" name="password">-->
<!--                    @if ($errors->has('password'))-->
<!--                    <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('password') }}</small>-->
<!--                    @endif-->
<!--                </div>-->
<!--                <div class="form-group">-->
<!--                    <label class="remember"><input type="checkbox"> Remember me </label>-->
<!--                    <a href="{{ url('password/reset') }}" class="pull-right forg_text"> Forgot password? </a>-->
<!--                </div>-->
<!--                <button class="btn btn-yellow" type="submit">Login</button>-->
                <!-- <span>or</span>
<!--                <div class="social-group">-->
<!--                    <button class="loginBtn loginBtn--facebook">Login with Facebook</button>-->
<!--                    <button class="loginBtn loginBtn--google">Login with Google</button>-->
<!--                </div> -->-->
<!--            </form>-->
<!--        </div>-->
<!--        <div class="overlay-container">-->
<!--            <div class="overlay">-->
<!--                <div class="overlay-panel overlay-left">-->
<!--                    <button class="ghost btn btn-black" id="signIn">Sign In</button>-->
<!--                </div>-->
<!--                <div class="overlay-panel overlay-right">-->
<!--                    <button class="ghost btn btn-black" id="signUp">Sign Up</button>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->



<section>
        <div class="form-box">
            <div class="form-value">
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <h2>Login</h2>
                    <div class="inputbox">
                        <ion-icon name="mail-outline"></ion-icon>
                        <input type="email" class="{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>
                        <label for="">Email</label>
                        @if ($errors->has('email'))
                        <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('email') }}</small>
                        @endif
                    </div>
                    <div class="inputbox">
                        <ion-icon name="lock-closed-outline"></ion-icon>
                        <input type="password" class="{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>
                        <label for="">Password</label>
                        @if ($errors->has('password'))
                        <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('password') }}</small>
                        @endif
                    </div>
                    <div class="forget">
                        <label for=""><input type="checkbox">Remember Me  <a href="#">Forget Password</a></label>
                      
                    </div>
                    <button>Log in</button>
                    <div class="register">
                        <p>Don't have a account <a href="{{route('signup')}}">Register</a></p>
                    </div>
                </form>
            </div>
        </div>
    </section>

@endsection
@section('js')
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
<script>
    $("#phone").on("keypress keyup blur",function (event) {    
       $(this).val($(this).val().replace(/[^\d].+/, ""));
        if ((event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });
</script>
@endsection