<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\StoreProduct;

use App\PartnershipForm;
use App\SpotLightForm;
use App\AgencyApplication;
use App\StreamSchedule;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;

class ShoppingController extends Controller
{
    public function allNewProduct()
    {
        $products = StoreProduct::paginate(10);
        return view('admin.product.new-products',compact('products'));
    }
    
    public function createProductPage()
    {
        return view('admin.product.product-create');
    }
    
    public function editNewProduct($id)
    {
        $product = StoreProduct::find($id);
        // dd($product);
        return view('admin.product.new-product-edit',compact('product'));
    }
    
    public function newProductDelete($id)
    {
        $product = StoreProduct::find($id);
        $product->delete();
        return redirect()->route('new-products')->with('message','Product deleted Successfully !');
    }
    
    public function createProductPost(Request $request)
    {
        // if (!Auth::user()) {
        //     return back()->with('message', 'Please login or create an account first to participate');
        // }
        $validator = Validator::make($request->all(), [
            'category_name' => 'required',
            'pro_name' => 'required',
            'pro_price' => 'required',
            'pro_description' => 'required',
            'pro_image' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('message', 'Please enter all fields data!');
        }
        
        // dd($request->all());

        $product = new StoreProduct();
        $product->category_name = $request->category_name;
        $product->pro_name = $request->pro_name;
        $product->pro_price = $request->pro_price;
        $product->pro_description = $request->pro_description;
        
        if ($request->hasFile('pro_image')) {
            $file = $request->file('pro_image');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/products/', $fileName);
            $product->pro_image = $fileName;
        }

        if ($request->hasFile('pro_images')) {
            $fileNames = [];
            foreach ($request->file('pro_images') as $file) {
                $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $fileName = $originalFileName . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
                $file->move('uploads/products/', $fileName);
                $fileNames[] = $fileName;
            }
            $product->gallery_images = json_encode($fileNames);
        }
        $product->save();
        return back()->with('message', 'Product added successfully!');
    }
    
    public function updateProductPost(Request $request)
    {
        // Check if the product exists
        $product = StoreProduct::find($request->proId);
        if (!$product) {
            return back()->with('error', 'Product not found!');
        }
    
        // Delete the main product image if it exists
        $imagePath = 'uploads/products/' . $product->pro_image;
        if (File::exists($imagePath)) {
            File::delete($imagePath);
        }
    
        // Update the product attributes
        $product->category_name = $request->category_name;
        $product->pro_name = $request->pro_name;
        $product->pro_price = $request->pro_price;
        $product->pro_description = $request->pro_description;
        
        // Update the main product image if a new one is provided
        if ($request->hasFile('pro_image')) {
            $file = $request->file('pro_image');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/products/', $fileName);
            $product->pro_image = $fileName;
            
        }
    
        // Delete the existing gallery images
        $galleryPath = 'uploads/products/' . $product->gallery_images;
        if (File::exists($galleryPath)) {
            File::delete($galleryPath);
        }
    
        // Update the gallery images
        if ($request->hasFile('pro_images')) {
            $fileNames = [];
            foreach ($request->file('pro_images') as $file) {
                $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $fileName = $originalFileName . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
                $file->move('uploads/products/', $fileName);
                $fileNames[] = $fileName;
            }
            $product->gallery_images = json_encode($fileNames);
        }
        $product->save(); // Save the changes immediately
        return back()->with('message', 'Product updated successfully!');
    }
    
     public function partnershipsData()
    {
        $data = PartnershipForm::paginate(10);
        return view('admin.partnership.partnership-form',compact('data'));
    }
    
     public function agencyApplication()
    {
        $data = AgencyApplication::paginate(10);
        return view('admin.partnership.agency-app',compact('data'));
    }
    
     public function spotLightApplication()
    {
        $data = SpotLightForm::paginate(10);
        return view('admin.partnership.spot-light-form',compact('data'));
    }
    
     public function streaminSchedules()
    {
        $data = StreamSchedule::paginate(10);
        return view('admin.partnership.stream-schedules',compact('data'));
    }

}
