<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\CreatorFilm;
use App\ShortFilm;
use Illuminate\Support\Facades\Validator;

use Image;
use Auth;
use File;


class CreatorFilmsController extends Controller
{
    public function storeShortVideo(Request $request)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()) {
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                // 'video_trailer' => 'required|mimetypes:video/mp4|max:2048',
                'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            if ($validator->fails()) {
                // Validation failed, redirect back with errors and input data
                return redirect()->back()->with('message', 'Please enter all fields data !');
            }
            // dd($request->all());
            
            $video = new CreatorFilm();
            $video->user_id = Auth::id();
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
    
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            // if ($request->hasFile('video_trailer')) {
            //     $file = $request->file('video_trailer');
            //     $fileName = time() . '.' . $file->getClientOriginalExtension();
            //     $path = $file->move('uploads/shortfilm-videos/', $fileName);
            //     $video->video_trailer = $fileName;
            // }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->save();
            return back()->with('message', 'Video added successfully !!!');
        }
        return back()->with('message', 'Something went wrong !');
    }

    public function updateShortVideo(Request $request)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()) {
            
            $video = CreatorFilm::find($request->vId);
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
            // dd($video);
            $path = 'uploads/shortfilm-thumbnails/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            $path = 'uploads/shortfilm-videos/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->update();
            return back()->with('message', 'Video updated successfully !!!');
        }
        return back()->with('message', 'Something went wrong !');

    }

    public function destroyVideo($id)
    {
        // dd($id);
        if(auth()->user()) {
            CreatorFilm::delete($id);
            return redirect()->back()->with('message', 'Short film deleted successfully !!!');
        }
        return back()->with('message', 'Something went wrong !');
    }
    
    
    public function storeShortFilm(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'video_title' => 'required',
            'video_tags' => 'required',
            'video_description' => 'required',
            'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
            'video_trailer' => 'required|mimetypes:video/mp4|max:2048',
            'video_file' => 'required|mimetypes:video/mp4|max:2048',
        ]);
    
        if ($validator->fails()) {
            return redirect()->back()->with('message', 'Please enter all fields data!');
        }
    
        // Build the data array for insertion
        $videoData = [
            'user_id' => Auth::id(),
            'video_title' => $request->video_title,
            'video_tags' => $request->video_tags,
            'video_description' => $request->video_description,
        ];
    
        // Handle file uploads and add to the data array
        if ($request->hasFile('video_thumbnail')) {
            $file = $request->file('video_thumbnail');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/shortfilm-thumbnails/', $fileName);
            $videoData['video_thumbnail'] = $fileName;
        }
        if ($request->hasFile('video_trailer')) {
            $file = $request->file('video_trailer');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/shortfilm-videos/', $fileName);
            $videoData['video_trailer'] = $fileName;
        }
        if ($request->hasFile('video_file')) {
            $file = $request->file('video_file');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/shortfilm-videos/', $fileName);
            $videoData['video_file'] = $fileName;
        }
    
        // Insert data into the "shortfilms" table using the Query Builder
        DB::table('shortfilms')->insert($videoData);
    
        // Redirect back with a success message
        return back()->with('message', 'Film added successfully !!!');
    }
    
    public function updateShortFilm(Request $request)
    {
        if (auth()->user()) {
            // Update the record in the 'shortfilms' table
            DB::table('shortfilms')
                ->where('id', $request->vId)
                ->update([
                    'video_title' => $request->video_title,
                    'video_tags' => $request->video_tags,
                    'video_description' => $request->video_description,
                ]);
    
            // Handle video thumbnail upload
            if ($request->hasFile('video_thumbnail')) {
                $thumbnail = $request->file('video_thumbnail');
                $thumbnailName = time() . '.' . $thumbnail->getClientOriginalExtension();
                $thumbnailPath = $thumbnail->move('uploads/shortfilm-thumbnails/', $thumbnailName);
    
                // Update the 'video_thumbnail' column
                DB::table('shortfilms')
                    ->where('id', $request->vId)
                    ->update(['video_thumbnail' => $thumbnailName]);
            }
    
            // Handle video file upload
            if ($request->hasFile('video_file')) {
                $videoFile = $request->file('video_file');
                $videoFileName = time() . '.' . $videoFile->getClientOriginalExtension();
                $videoFilePath = $videoFile->move('uploads/shortfilm-videos/', $videoFileName);
    
                // Update the 'video_file' column
                DB::table('shortfilms')
                    ->where('id', $request->vId)
                    ->update(['video_file' => $videoFileName]);
            }
    
            return back()->with('message', 'Video updated successfully!');
        }
    
        return back()->with('message', 'Something went wrong!');
    }
    
    public function destroyShortFilm($id)
    {
        if (auth()->user()) {
            // Get the path of the video thumbnail and video file
            $video = DB::table('shortfilms')->where('id', $id)->first();
            $thumbnailPath = public_path('uploads/shortfilm-thumbnails/') . $video->video_thumbnail;
            $videoFilePath = public_path('uploads/shortfilm-videos/') . $video->video_file;
    
            // Delete the video thumbnail and video file
            if (File::exists($thumbnailPath)) {
                File::delete($thumbnailPath);
            }
            if (File::exists($videoFilePath)) {
                File::delete($videoFilePath);
            }
    
            // Delete the record from the 'shortfilms' table
            DB::table('shortfilms')->where('id', $id)->delete();
    
            return redirect()->back()->with('message', 'Short film deleted successfully!');
        }
    
        return back()->with('message', 'Something went wrong!');
    }

}
