<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\CreatorSqVideo;
use Illuminate\Support\Facades\Validator;

use Image;
use Auth;
use DB;
use File;

class CreatorVideoController extends Controller
{
    public function storeSqVideo(Request $request)
    {
        if(auth()->user()) {
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            // if ($validator->fails()) {
            //     // Validation failed, redirect back with errors and input data
            //     return redirect()->back()->with('message', 'Please enter all fields data !');
            // }
            // dd($request->all());
            
            $video = new CreatorSqVideo();
            $video->user_id = Auth::id();
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
    
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->save();
            return back()->with('message', 'Video added successfully !!!');
        }
    }

    public function updateSqVideo(Request $request)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()) {
            
            $video = CreatorSqVideo::find($request->vId);
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
            // dd($video);
            $path = 'uploads/square-thumbnails/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            $path = 'uploads/square-videos/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->update();
            return back()->with('message', 'Video updated successfully !!!');
        }
    }
    
    public function destroy($id)
    {
        CreatorSqVideo::destroy($id);
        return redirect()->back()->with('message', 'Square video deleted!');
    }
    
    public function storeSqVideoSeries(Request $request)
    {
        if (auth()->user()) {
            // Get the user's ID
            $userId = auth()->user()->id;
            
            // Count the number of existing video series uploaded by the user
            $seriesCount = DB::table('creators')->where('user_id', $userId)->count();
            
            // Check if the user has already uploaded the maximum allowed number of video series (15 in this case)
            if ($seriesCount >= 15) {
                return redirect()->back()->with('message', 'You have already uploaded the maximum allowed number of video series.');
            }
            
            // Validate the request data
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            if ($validator->fails()) {
                return redirect()->back()->with('message', 'Please enter all fields data!');
            }
    
            // Process the request data
            $videoData = [
                'user_id' => $userId,
                'video_title' => $request->video_title,
                'video_tags' => $request->video_tags,
                'video_description' => $request->video_description,
            ];
    
            // Handle file upload for video thumbnail
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/series-thumbnails/', $fileName);
                $videoData['video_thumbnail'] = $fileName;
            }
    
            // Handle file upload for video file
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-series/', $fileName);
                $videoData['video_file'] = $fileName;
            }
    
            // Insert data into the "creators" table
            DB::table('creators')->insert($videoData);
    
            // Redirect back with a success message
            return back()->with('message', 'Series Video added successfully !!!');
        }else{
            return back()->with('message', 'Please login or create account first !!!');
        }
    }


    public function updateSqVideoSeries(Request $request)
    {
        if (auth()->check()) {
            $video = DB::table('creators')->where('id', $request->vId)->first();
            
            if ($video) {
                // Update video details
                $updateData = [
                    'video_title' => $request->video_title,
                    'video_tags' => $request->video_tags,
                    'video_description' => $request->video_description,
                ];
                
                // Handle file upload for video thumbnail
                if ($request->hasFile('video_thumbnail')) {
                    $file = $request->file('video_thumbnail');
                    $fileName = time() . '.' . $file->getClientOriginalExtension();
                    $path = $file->move('uploads/series-thumbnails/', $fileName);
                    $updateData['video_thumbnail'] = $fileName;
                }
    
                // Handle file upload for video file
                if ($request->hasFile('video_file')) {
                    $file = $request->file('video_file');
                    $fileName = time() . '.' . $file->getClientOriginalExtension();
                    $path = $file->move('uploads/square-series/', $fileName);
                    $updateData['video_file'] = $fileName;
                }
    
                // Update the record
                DB::table('creators')->where('id', $request->vId)->update($updateData);
    
                return back()->with('message', 'Series Video updated successfully !!!');
            } else {
                return back()->with('error', 'Video not found!');
            }
        }
    }
    
    public function destroyVideoSeries($id)
    {
        $video = DB::table('creators')->where('id', $id)->first();
        if ($video) {
            // Delete video files
            if ($video->video_thumbnail) {
                $thumbnailPath = public_path('uploads/series-thumbnails/') . $video->video_thumbnail;
                if (File::exists($thumbnailPath)) {
                    File::delete($thumbnailPath);
                }
            }
            if ($video->video_file) {
                $videoPath = public_path('uploads/square-series/') . $video->video_file;
                if (File::exists($videoPath)) {
                    File::delete($videoPath);
                }
            }
    
            // Delete the record from the database
            DB::table('creators')->where('id', $id)->delete();
    
            return redirect()->back()->with('message', 'Series video deleted!');
        } else {
            return redirect()->back()->with('error', 'Video not found!');
        }
    }
}
