<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\inquiry;
use App\schedule;
use App\newsletter;
use App\post;
use App\banner;
use App\imagetable;
use DB;
use Mail;use View;
use Session;
use App\Http\Helpers\UserSystemInfoHelper;
use App\Http\Traits\HelperTrait;
use Auth;
use App\Profile;
use App\Page;
use Image;

class HomeController extends Controller
{   
    use HelperTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
     // use Helper;
     
    public function __construct()
    {
        //$this->middleware('auth');

        $logo = imagetable::
                     select('img_path')
                     ->where('table_name','=','logo')
                     ->first();
             
        $favicon = imagetable::
                     select('img_path')
                     ->where('table_name','=','favicon')
                     ->first(); 
        
        View()->share('logo',$logo);
        View()->share('favicon',$favicon);

    } 

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
        $page = DB::table('pages')->where('id', 1)->first();
        $section = DB::table('section')->where('page_id',1)->get(); 
        $banner = DB::table('banners')->first();
        $whatWe = DB::table('whatwedos')->get();
        $popularMovies = DB::table('products')->where('is_popular',1)->get();
        $creatorVideo = DB::table('creators')->orderBy('id','DESC')->take(6)->get();
        $shortFilms = DB::table('shortfilms')->get();
       return view('welcome', compact('page','section','banner','whatWe','popularMovies','creatorVideo','shortFilms'));
    }
    
        public function cs()
    { 
        
       return view('coming-soon');
    }
    
    public function about(){
        $page = DB::table('pages')->where('id',11)->first();
        $section = DB::table('section')->where('page_id',11)->get();      
        return view('about', compact('page','section'));
    }
    
    public function userAccountInfo(){     
        return view('account.new-account');
    }
    
    public function squareVideo(){
        $page = DB::table('pages')->where('id',10)->first();
        $section = DB::table('section')->where('page_id',10)->get(); 
        $squareVideos = DB::table('squarevideos')->get();
        return view('square-video', compact('page','section','squareVideos'));
    }
    
    public function movies(){
        $page = DB::table('pages')->where('id',9)->first();
        $section = DB::table('section')->where('page_id',9)->get();    
        $movies = DB::table('products')->get();
        return view('movies', compact('page','section','movies'));
    }

    public function calender(){
        $page = DB::table('pages')->where('id',8)->first();
        $section = DB::table('section')->where('page_id',8)->get();         
        return view('calender', compact('page','section'));
    }
    
    public function guideline(){
        $page = DB::table('pages')->where('id',7)->first();
        $section = DB::table('section')->where('page_id',7)->get();          
        return view('guideline', compact('page','section'));
    }
    
    public function privacyPolicy(){
        $page = DB::table('pages')->where('id',2)->first();
        $section = DB::table('section')->where('page_id',2)->get();          
        return view('privacy-policy',compact('page'));
    }
    
    public function broadcaster(){
        $page = DB::table('pages')->where('id',3)->first();
        $section = DB::table('section')->where('page_id',3)->get();        
        return view('broadcaster-guidelines',compact('page','section'));
    }
    
    public function uploadAgree(){
        $page = DB::table('pages')->where('id',6)->first();
        $section = DB::table('section')->where('page_id',6)->get();
        return view('uploading-agreement',compact('page','section'));
    }
    
    public function contact(){
        $page = DB::table('pages')->where('id',4)->first();
        $section = DB::table('section')->where('page_id',4)->get();
        return view('contact',compact('page','section'));
    }
    
    public function careerSubmit(Request $request)
    {

       
        inquiry::create($request->all());


        return response()->json(['message'=>'Thank you for contacting us. We will get back to you asap', 'status' => true]);
        return back();
    }

    public function newsletterSubmit(Request $request){

        $is_email = newsletter::where('newsletter_email',$request->newsletter_email)->count();
        if($is_email == 0) {        
            $inquiry = new newsletter;
            $inquiry->newsletter_email = $request->newsletter_email;
            $inquiry->save();
            return response()->json(['message'=>'Thank you for contacting us. We will get back to you asap', 'status' => true]);
            
        }else{
            return response()->json(['message'=>'Email already exists', 'status' => false]);
        }
            
    }

    public function updateContent(Request $request){
        $id = $request->input('id');
        $keyword = $request->input('keyword');
        $htmlContent = $request->input('htmlContent');
        if($keyword == 'page'){
            $update = DB::table('pages')
                        ->where('id', $id)
                        ->update(array('content' => $htmlContent));

            if($update){
                return response()->json(['message'=>'Content Updated Successfully', 'status' => true]);
            }else{
                return response()->json(['message'=>'Error Occurred', 'status' => false]);
            }
        }else if($keyword == 'section'){
            $update = DB::table('section')
                        ->where('id', $id)
                        ->update(array('value' => $htmlContent));
            if($update){
                return response()->json(['message'=>'Content Updated Successfully', 'status' => true]);
            }else{
                return response()->json(['message'=>'Error Occurred', 'status' => false]);
            }
        }
    }

}
