<?php

namespace App\Http\Controllers;
use Hash;
use Illuminate\Http\Request;
use App\inquiry;
use App\newsletter;
use App\Program;
use App\imagetable;
use App\Banner;
use App\Profile;
use DB;
use View;
use File;
use App\orders_products;
use App\orders;
use Auth;
use Session;
use App\Http\Traits\HelperTrait;
use App\UserWallet;

class LoggedInController extends Controller
{	
	use HelperTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
	 // use Helper;
	 
    public function __construct()
    {

		// $this->middleware('guest');
        $this->middleware('auth');
        $logo = imagetable::
                     select('img_path')
                     ->where('table_name','=','logo')
                     ->first();
             
		$favicon = imagetable::
                     select('img_path')
                     ->where('table_name','=','favicon')
                     ->first();	 

        View()->share('logo',$logo);
		View()->share('favicon',$favicon);
        //View()->share('config',$config);
    }

	
	public function orders()
    {
		
		$orders = orders::where('orders.user_id', Auth::user()->id)
				->orderBy('orders.id', 'desc')
				->get();
		return view('account.orders',['ORDERS'=>$orders]); 
		
	}
	

	public function account()
    {
		$orders = orders::where('orders.user_id', Auth::user()->id)
				->orderBy('orders.id', 'desc')
				->get();
		$walletStrips = UserWallet::where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 0)->sum('value');
		$walletSnacks = UserWallet::where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 1)->sum('value');
// 		dd($orders,$walletStrips,$walletSnacks);
		return view('account.index',['ORDERS'=>$orders, 'walletSnacks'=>$walletSnacks,'walletStrips'=>$walletStrips]); 
// 		before it has return to indexin account 
	}


		public function update_profile(Request $request) {
		
		$user = DB::table('profiles')->where('id', Auth::user()->id)->first();
		
		$validateArr = array();
		$messageArr = array();
		$insertArr = array();
		$validateArr = [ 

			'uname' => 'required',
			'email' => array(),
			
		 ];
		 
		 if($user->email != $_POST['email']) {
			$validateArr['email'] = 'required|unique:users,email,NULL,id';
		 }

		if(trim($_POST['password']) != "") {
		
			$validateArr['password'] = 'required|min:6|confirmed'; 
            $validateArr['password_confirmation'] = 'required|min:6'; 
		}
		
		$this->validate($request,$validateArr,$messageArr);
		
		$insertArr['name'] = $_POST['uname'];	
		$insertArr['email'] = $_POST['email'];
	
		if(trim($_POST['password']) != "") {
				$insertArr['password'] = Hash::make($_POST['password']);
		}
			
		DB::table('users')
		->where('id', Auth::user()->id)
		->update(
					$insertArr
				);
					
					
		Session::flash('message', 'Your Profile Settings has been changed'); 
		Session::flash('alert-class', 'alert-success'); 
		return back();			
		
	}


	public function uploadPicture(Request $request) {	

		$user = DB::table('profiles')->where('id', Auth::user()->id)->first();
	
        if ($file = $request->file('pic')) {
            $extension = $file->extension()?: 'jpg|png';
            $destinationPath = public_path() . '/storage/uploads/users/';
            $safeName = str_random(10) . '.' . $extension;
            $file->move($destinationPath, $safeName);
            //delete old pic if exists
            if (File::exists($destinationPath . $user->pic)) {
                File::delete($destinationPath . $user->pic);
            }
            //save new file path into db
            $profile->pic = $safeName;
        }

			$insertArr['pic'] = $safeName;

			DB::table('profiles')
			->where('id', Auth::user()->id)
			->update(
						$insertArr
					);

		Session::flash('message', 'Your Profile has been changed'); 
		Session::flash('alert-class', 'alert-success'); 
		return back();			

	}

    public function updateAccount(Request $request) 
    {
        $user = Auth::user();
        
        $request->validate([ 
            'name' => 'required',
            'email' => 'required|email|unique:users,email,'.$user->id,
            // 'phone' => 'nullable', // Make phone field nullable
            // 'gender' => 'nullable', // Make gender field nullable
            // 'country' => 'nullable', // Make country field nullable
            // 'state' => 'nullable', // Make state field nullable
            // 'profile_pic' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Make profile_pic nullable
        ]);
    
        $user->name = $request->input('name');
        $user->email = $request->input('email');
    
        // Get or create profile
        $profile = Profile::where('user_id', $user->id)->first();
        if (!$profile) {
            $profile = new Profile();
            $profile->user_id = $user->id;
        }
    
        // Update profile fields
        $profile->phone = $request->input('phone');
        $profile->gender = $request->input('gender');
        $profile->country = $request->input('country');
        $profile->state = $request->input('state');
        
        // dd($request->all(),$user,$profile);
        
        // Update profile picture if provide
        if ($request->hasFile('profile')) {
            $file = $request->file('profile');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $file->move('uploads/users/', $fileName);
            
            // Delete old pic if exists
            if ($profile->pic && File::exists($profile->pic)) {
                File::delete($profile->pic);
            }
            
            $profile->pic = $fileName;
            $user->profile = $fileName;
        }
    
        // Save user and profile
        $user->save();
        $profile->save();
    
        Session::flash('message', 'Your Account has been changed'); 
        Session::flash('alert-class', 'alert-success'); 
        return back();
    }


    public function updatePass(Request $request){
      
        $password = $_POST['password'];
		$confirmpass = $_POST['password_confirmation'];
		  if($password == $confirmpass ){
        		if(trim($_POST['password']) != "") {
        		  $insertArr['password'] = Hash::make($_POST['password']);
        		} 
        }
        
        DB::table('users')
		->where('id', Auth::user()->id)
		->update(
		    $insertArr
		  );
		Session::flash('message', 'Your Password has been changed'); 
		Session::flash('alert-class', 'alert-success'); 
		return back();  
    }
	public function accountDetail()
    {
		$orders = orders::where('orders.user_id', Auth::user()->id)
						->orderBy('orders.id', 'desc')
						->get();
		
		return view('account.account',['ORDERS'=>$orders]); 
		
	}
	
	public function invoice($id)
    {
		$order_id = $id;
		$order = orders::where('id',$order_id)->first();
		$order_products = orders_products::where('orders_id',$order_id)->get();
		
		return view('account.invoice')->with('title','Invoice #'.$order_id)->with(compact('order','order_products'))->with('order_id',$order_id);; 
	}


	public function friends()
    {
		return view('account.friends'); 
		
	}

	public function upload()
    {
		return view('account.upload'); 
		
	}

	public function password()
    {
		return view('account.password'); 
		
	}
	
}	
	
