<?php

namespace App\Http\Controllers;

use App\UserWallet;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Auth;
class MerchandiseController extends Controller
{
    public function index(){
        $page = DB::table('pages')->where('id',12)->first();
        return view('merchandise.index')->with(compact('page'));
    }
    
    public function purchase($purchaseId){
        if(Auth::check()){
            $value = 0;
            $amount = 0;
            $is_snack = 1;
            if($purchaseId==1){
                $amount = 1;
                $value = 5000;
            }else if($purchaseId==2){
                $amount = 5;
                $value = 25000;
            }else if($purchaseId==3){
                $amount = 10;
                $value = 50000;
            }else if($purchaseId==4){
                $amount = 20;
                $value = 100000;
            }else if($purchaseId==5){
                $amount = 100;
                $value = 50000;
            }else if($purchaseId==6){
                $amount = 200;
                $value = 100000;
            }else if($purchaseId==7){
                $amount = 500;
                $value = 2500000;
            }else if($purchaseId==8){
                $amount = 1000;
                $value = 5000000;
            }else if($purchaseId==9){
                $amount = 3000;
                $value = 15000000;
            }else if($purchaseId==10){
                $is_snack = 0;
                $amount = 50;
                $value = 20000;
            }else if($purchaseId==11){
                $is_snack = 0;
                $amount = 100;
                $value = 40000;
            }else if($purchaseId==12){
                $is_snack = 0;
                $amount = 200;
                $value = 80000;
            }else if($purchaseId==13){
                $is_snack = 0;
                $amount = 500;
                $value = 200000;
            }else if($purchaseId==14){
                $is_snack = 0;
                $amount = 1000;
                $value = 400000;
            }
            $userWallet = UserWallet::create([
                'user_id' => Auth::user()->id,
                'value' => $value,
                'is_snack' => $is_snack,
                'payment_status' => 0
            ]);
            
            // Get the Stripe secret key or provide a default value
            $stripeSecret = getenv('STRIPE_SECRET') ?: 'sk_test_tufroxQif3WXYBXnpE7654Lc00ELByYsKj';
    
            // Create a Stripe client
            $stripe = new \Stripe\StripeClient($stripeSecret);
    
            try {
                // Create a checkout session
                $csCheckout = $stripe->checkout->sessions->create([
                    'success_url' => route('merchandise.purchase.success', $userWallet),
                    'line_items' => [
                        [
                            'price_data' => [
                                'currency' => 'USD',
                                'product_data' => [
                                    'name' => 'Snacks Purchase',
                                ],
                                'unit_amount' => ($amount * 100),
                            ],
                            'quantity' => 1,
                        ],
                    ],
                    'mode' => 'payment',
                ]);
                // Save the charge ID to the user wallet
                $userWallet->charge_id = $csCheckout->id;
                // dd($userWallet);
                $userWallet->save();
                // Redirect the user to the Stripe checkout page
                return redirect()->away($csCheckout->url);
            } catch (\Stripe\Exception\ApiErrorException $e) {
                // Handle Stripe API errors
                return redirect()->back()->with('error', $e->getError()->message);
            } catch (\Exception $e) {
                // Handle other exceptions
                return redirect()->back()->with('error', $e->getMessage());
            }
        }
    
        // Redirect back if the user is not authenticated
        return redirect()->back();

    }
    
    // public function orderPayment(Request $request)
    // {
    //     // dd($request);
    //     $amn = $request->amount;
    //     // dd($id);
    //     if (!$amn) {
    //         Alert::info('Information !', 'Please enter some amount !!!');
    //         return back();
    //     }
    //     // Stripe payment start
    //     try {
    //         $stripe = Stripe::setApiKey("sk_test_51M8ALKAgW8OMwbeWY0N8Nkzj62ePjyaJBmvHGJF0tZ6I9M1bVXeKLBYrPxsTB3Jt99fnTOILrDs0pg54eZDY9Lgt00Nv6wVDTH");
    //         $response = Token::create(array(
    //             "card" => array(
    //                 "number"    => $request->cc_number,
    //                 "exp_month" => $request->cc_mm,
    //                 "exp_year"  => $request->cc_yy,
    //                 "cvc"       => $request->cc_cvc
    //             )
    //         ));
    //         // dd($data,1);
    //         if (!isset($response['id'])) {
    //             // dd($data,2);
    //             $request->session()->flash('ERROR', 'Some error occurred during payment processing! please try again1.');
    //             return redirect()->back()->withInput($request->input());
    //         }
    
    //         $customer = Customer::create(array(
    //         // "address" => [
    //         //         "line1" => "Virani Chowk",
    //         //         "postal_code" => "360001",
    //         //         "city" => "Rajkot",
    //         //         "state" => "GJ",
    //         //         "country" => "IN",
    //         //     ],
    //         "email" => Auth::user()->email,
    //         "name" => Auth::user()->name,
    //         "source" => $request->stripeToken
    //      ));

    //     $charge = \Stripe\Charge::create([
    //         'currency' => 'USD',
    //         'amount' =>  $amn * 100,
    //         "customer" => $customer->id,
    //         "description" => "Payment from Industril depot."
    //     ]);
    //         // dd($data,4);
    //         if ($charge->captured == true) {
    //             // img upload
    //             DB::table('orders')->insert([
    //                 // dd('ok'),
    //                 'user_id'             => Auth::user()->id,
    //                 'txn_id'         => $charge->id,
    //                 'total_amount'             => $amn,
    //                 'phone'             => '123567899000',
    //                 'country'             => 'XYZ',
    //                 'postal_code'             => '******',
    //                 'method'     => 'Stripe'
    //             ]);
                
    //             DB::table('shopping_carts')->truncate();
    //             Alert::success('Thank You !', 'Payment done successfully !!!');
    //             return redirect()->route('tid.index');
    //         } else {
    //             $request->session()->flash('ERROR', 'Some error occurred during payment processing! please try again2');
    //             return redirect()->back()->withInput($request->input());
    //         }
    //     } catch (\Exception $e) {
    //         //$request->session()->flash('ERROR', 'Some error occurred during payment processing! please try again...');
    //         $request->session()->flash('ERROR', $e->getMessage());

    //         return redirect()->back()->withInput($request->input());
    //     }
    //     // Stripe payment end
    // }
    
    public function purchaseSuccess(UserWallet $userWallet)
    {
        if(Auth::check()){
            $page = DB::table('pages')->where('id', 12)->first();
            
            // Get the Stripe secret key or provide a default value
            $stripeSecret = getenv('STRIPE_SECRET') ?: 'sk_test_tufroxQif3WXYBXnpE7654Lc00ELByYsKj';
            
            // Create a Stripe client
            $stripe = new \Stripe\StripeClient($stripeSecret);
    
            try {
                // Retrieve the checkout session from Stripe
                $csCheckout = $stripe->checkout->sessions->retrieve($userWallet->charge_id, []);
    
                // Check payment status and update user wallet if necessary
                if ($csCheckout->payment_status == 'paid' && $userWallet->payment_status == 0) {
                    $userWallet->payment_status = 1;
                    $userWallet->save();
                }
                // Render the purchase success view
                return view('merchandise.purchase-success')->with(compact('userWallet', 'page'));
            } catch (\Stripe\Exception\ApiErrorException $e) {
                // Handle Stripe API errors
                return redirect()->back()->with('error', $e->getError()->message);
            } catch (\Exception $e) {
                // Handle other exceptions
                return redirect()->back()->with('error', $e->getMessage());
            }
        }
    
        // Redirect back if the user is not authenticated
        return redirect()->route('merchandise');
    }

    
    public function convertStrips($id){
        if(Auth::check()){

        }
        return redirect()->back();
    }
}
