<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\StoreCartOrder;
use App\StoreProduct;
use App\StoreCart;
use App\UserWallet;
use Illuminate\Support\Facades\Auth;

class ShoppingController extends Controller
{
    public function newStore()
	{
	    $products = DB::table('products')
			->join('categories', 'products.category', '=', 'categories.id')
			->select('products.*', 'categories.name as category_title')
			->get();
		return view('shop.new-store',compact('products'));
	}
	
	public function newCheckout($totalPrice = '')
	{
		return view('shop.new-checkout',compact('totalPrice'));
	}
    
    public function newCart()
	{
		return view('shop.new-cart');
	}
	
	public function newCartPost($id)
	{
	    if (!Auth::user()) {
            return back()->with('message','Please Create an Account, or Log in first !');
        }
        $product = StoreProduct::where('id', '=', $id)->first();
        if (!$product) {
            return back()->with('message','Product not found !');;
        }
        // dd($product);
        $cart = new StoreCart();
        $cart->user_id = Auth::user()->id;
        $cart->category_name = $product->category_name;
        $cart->pro_id = $product->id;
        $cart->save();
        return redirect()->route('new.cart')->with('message','Product added to cart successfully !');
	}
	
	public function newCheckoutPost(Request $request)
    {
    if (!Auth::user()) {
        return back()->with('message', 'Please Create an Account, or Log in first!');
    }

    $cart = StoreCart::where('user_id', Auth::id())->where('status', '0')->first();
    $wallet = UserWallet::where('user_id', Auth::id())->where('is_snack', '1')->where('payment_status', '1')->latest()->first();
    $product = StoreProduct::where('id', $cart->pro_id)->first();

    if ($wallet->value > $request->total_price) {
        DB::beginTransaction();

        try {
            $wallet->value -= $request->total_price;

            $checkout = new StoreCartOrder();
            $checkout->user_id = Auth::user()->id;
            $checkout->category_name = $product->category_name;
            $checkout->pro_id = $product->id;
            $checkout->quantity = $cart->quantity;
            $checkout->total_price = $request->total_price;
            $checkout->points_used = $request->total_price;
            $checkout->name = $request->fname . ' ' . $request->lname;
            $checkout->email = $request->email;
            $checkout->first_address = $request->first_address;
            $checkout->second_address = $request->second_address;
            $checkout->reciever_phone = $request->phone;
            $checkout->country = $request->country;
            $checkout->state = $request->state;
            $checkout->zip_code = $request->zip_code;
            $checkout->is_paid = '1';

            $cart->status = '1';
            $cart->update();

            $wallet->update();

            $checkout->save();

            // Commit the transaction
            DB::commit();

            return redirect()->route('new.store')->with('message', 'Successfully order placed !');
        } catch (\Exception $e) {
            // Rollback the transaction in case of an exception
            DB::rollback();

            return redirect()->route('new.store')->with('message', 'Failed to place an order. Please try again.');
        }
    } else {
        return redirect()->route('new.store')->with('message', 'You don\'t have enough points to buy!');
    }
}

    public function newCartUpdate(Request $request)
    {
        $productId = $_POST['productId'];
        $quantity = $_POST['quantity'];
        $storeCart = StoreCart::find($productId);
        // dd($storeCart);
        if ($storeCart) {
            $storeCart->quantity = $quantity;
            $storeCart->save();
            return response()->json(['success' => true, 'message' => 'Quantity updated successfully']);
        } else {
            return response()->json(['success' => false, 'message' => 'Product not found'], 404);
        }
    }
    
    public function newCartRemove(Request $request)
    {
        $productId = $_POST['productId'];
        $storeCart = StoreCart::find($productId);

        if ($storeCart) {
            $storeCart->delete();

            return response()->json(['success' => true, 'message' => 'Product removed successfully']);
        } else {
            return response()->json(['success' => false, 'message' => 'Product not found'], 404);
        }
    }
}

