<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\PartnershipForm;
use App\SpotLightForm;
use App\AgencyApplication;
use App\StreamSchedule;

use Auth;

class StreamingController extends Controller
{
    public function viewStreamingPage()
    {
        return view('streaming');
    }
    
    public function viewPartnershipPage()
    {
        return view('partnership-form');
    }
    
    public function viewagencyApplicationPage()
    {
        return view('agency-application');
    }
    
    public function viewSpotLightForm()
    {
        return view('spot-light-form');
    }
    
    public function streamSchedulePage()
    {
        if(!Auth::user())
        {
            return redirect()->back()->with('error','You have to create account or login first !!!');
        }
        $data = StreamSchedule::where('user_id',Auth::id())->get();
        return view('schedule-stream',compact('data'));
    }
    
   public function streamSchedulePost(Request $request)
    {
        if(!Auth::user())
        {
            return redirect()->back()->with('error','You have to create account or login first !!!');
        }
        // Validate the request data
        $validatedData = $request->validate([
            'schedule_time' => 'required',
            'schedule_date' => 'required',
        ]);
    
        // Extract schedule time and date from the request
        $schedule_time = $request->input('schedule_time');
        $schedule_date = $request->input('schedule_date');
    
        // Create a new StreamSchedule instance
        $data = new StreamSchedule;
    
        // Assign user ID if needed (uncomment if applicable)
        // $data->user_id = Auth::id();
    
        // Assign schedule time and date after formatting
        $data->user_id = Auth::id();
        $data->schedule_time = date('H:i', strtotime($schedule_time)); // Format time as HH:ii
        $data->schedule_date = date('m/d/Y', strtotime($schedule_date)); // Format date as MM/DD/YYYY
        
        // dd($request->all(),$data);
        // Attempt to save the data
        try {
            $data->save();
            return redirect()->back()->with('success', 'Streaming scheduled successfully');
        } catch (\Exception $e) {
            // Log or handle the exception
            return redirect()->back()->with('error', 'An error occurred while saving the stream schedule.');
        }
    }

    
    public function storePartnership(Request $request)
    {
        if(!Auth::user())
        {
            return redirect()->back()->with('error','You have to create account or login first !!!');
        }
        $validatedData = $request->validate([
            'name' => 'required|string',
            'email' => 'required|email',
            'square_id' => 'required|string',
            'insta_link' => 'required',
            'youtube_link' => 'required',
            'tiktok_link' => 'required',
            'sound_cloud_link' => 'required',
            'spotify_link' => 'required',
            'content_category' => 'required|string',
        ]);
        // dd($request->all());
        $data = new PartnershipForm;
        $data->user_id = Auth::user()->id;
        $data->name = $validatedData['name'];
        $data->email = $validatedData['email'];
        $data->square_id = $validatedData['square_id'];
        $data->insta_link = $validatedData['insta_link'];
        $data->youtube_link = $validatedData['youtube_link'];
        $data->tiktok_link = $validatedData['tiktok_link'];
        $data->sound_cloud_link = $validatedData['sound_cloud_link'];
        $data->spotify_link = $validatedData['spotify_link'];
        $data->content_category = $validatedData['content_category'];
        $data->save();
        return redirect()->back()->with('success', 'Partnership form submitted successfully');
    }
    
    public function storeAgencyForm(Request $request)
    {
        if (!Auth::user()) {
            return redirect()->back()->with('error', 'You have to create account or login first !!!');
        }
    
        $validatedData = $request->validate([
            'agency_name' => 'required|string',
            'agency_instagram' => 'required',
            'agency_website' => 'required|url',
            'num_influencers' => 'required|string',
            'associated_apps' => 'array',
            'website_link' => 'required|url',
            'email' => 'required|email',
            'phone' => 'required|string',
        ]);
    
        $data = new AgencyApplication;
        $data->user_id = Auth::id();
        $data->agency_name = $validatedData['agency_name'];
        $data->agency_insta_handle = $validatedData['agency_instagram'];
        $data->agency_website = $validatedData['agency_website'];
        $data->website_link = $validatedData['website_link'];
        $data->total_influencer = $validatedData['num_influencers'];
        $data->associated_web_apps = json_encode($validatedData['associated_apps']); // Convert to JSON
        $data->email = $validatedData['email'];
        $data->phone = $validatedData['phone'];
        // dd($request->all(),$data);
        $data->save();
    
        return redirect()->back()->with('success', 'Partnership form submitted successfully');
    }
    
    public function spotLightForm(Request $request)
    {
        if (!Auth::user()) {
            return redirect()->back()->with('error', 'You have to create an account or login first!');
        }
    
        $validatedData = $request->validate([
            'filmName' => 'required|string',
            'filmType' => 'required|string',
            'filmSummary' => 'required|string',
            'filmRating' => 'required|string',
            'squareID' => 'required|string',
            'email' => 'required|email',
            'firstEpisodeUpload' => 'required|file',
            'filmTrailerUpload' => 'required|file',
        ]);
    
        $data = new SpotLightForm; // Instantiate the SpotLightForm model
    
        // Handle file uploads
        if ($request->hasFile('filmTrailerUpload')) {
            $file = $request->file('filmTrailerUpload');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/trailer-files', $fileName); // Use 'trailer-files' folder
            $data->film_trailer = $fileName;
        }
    
        if ($request->hasFile('firstEpisodeUpload')) {
            $file = $request->file('firstEpisodeUpload');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->move('uploads/episode-files', $fileName); // Use 'episode-files' folder
            $data->series_episode = $fileName;
        }
    // $validatedData['squareID']
        $data->user_id =  Auth::id();
        $data->square_id =  Auth::id();
        $data->email = $validatedData['email'];
        $data->series_name = $validatedData['filmName'];
        $data->series_content_type = $validatedData['filmType'];
        $data->series_description = $validatedData['filmSummary'];
        $data->series_rating = $validatedData['filmRating'];
        // dd($request->all(),$data);
        // Save the data to the database
        $data->save();
    
        return redirect()->back()->with('success', 'Spotlight form submitted successfully');
    }


    
}
