<?php

namespace App\Http\Controllers\creator;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;

use App\Models\Creator;
use Illuminate\Http\Request;
use Image;
use File;

class CreatorController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $keyword = $request->get('search');
            $perPage = 25;

            if (!empty($keyword)) {
                $creator = Creator::where('name', 'LIKE', "%$keyword%")
                ->orWhere('image', 'LIKE', "%$keyword%")
                ->orWhere('video_url', 'LIKE', "%$keyword%")
                ->paginate($perPage);
            } else {
                $creator = Creator::paginate($perPage);
            }

            return view('creator.creator.index', compact('creator'));
        }
        return response(view('403'), 403);

    }

    public function create()
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            return view('creator.creator.create');
        }
        return response(view('403'), 403);

    }

    public function storeCreatorVideo(Request $request)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                // 'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                // 'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            if ($validator->fails()) {
                // Validation failed, redirect back with errors and input data
                return redirect()->back()->with('message', 'Please enter all fields data !');
            }
            // dd($request->all());
            
            $video = new Creator();
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
    
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/creator-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/creator-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->save();
            return back()->with('message', 'Video added successfully !!!');
            // $creator = new Creator($request->all());

            // if ($request->hasFile('image')) {

            //     $file = $request->file('image');
                
            //     //make sure yo have image folder inside your public
            //     $creator_path = 'uploads/creators/';
            //     $fileName = $file->getClientOriginalName();
            //     $profileImage = date("Ymd").$fileName.".".$file->getClientOriginalExtension();

            //     Image::make($file)->save(public_path($creator_path) . DIRECTORY_SEPARATOR. $profileImage);

            //     $creator->image = $creator_path.$profileImage;
            // }
            
            // $creator->save();
            // return redirect()->back()->with('message', 'Creator added!');
        }
        return response(view('403'), 403);
    }

    public function show($id)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $creator = Creator::findOrFail($id);
            return view('creator.creator.show', compact('creator'));
        }
        return response(view('403'), 403);
    }

    public function edit($id)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            $creator = Creator::findOrFail($id);
            return view('creator.creator.edit', compact('creator'));
        }
        return response(view('403'), 403);
    }

    public function updateCreatorVideo(Request $request)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            
            $video = Creator::find($request->vId);
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
            // dd($video);
            $path = 'uploads/creator-thumbnails/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/creator-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            $path = 'uploads/creator-videos/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/creator-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->update();
            return back()->with('message', 'Video updated successfully !!!');
            
        //     $requestData = $request->all();
            

        // if ($request->hasFile('image')) {
            
        //     $creator = Creator::where('id', $id)->first();
        //     $image_path = public_path($creator->image); 
            
        //     if(File::exists($image_path)) {
        //         File::delete($image_path);
        //     }

        //     $file = $request->file('image');
        //     $fileNameExt = $request->file('image')->getClientOriginalName();
        //     $fileNameForm = str_replace(' ', '_', $fileNameExt);
        //     $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
        //     $fileExt = $request->file('image')->getClientOriginalExtension();
        //     $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
        //     $pathToStore = public_path('uploads/creators/');
        //     Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);

        //      $requestData['image'] = 'uploads/creators/'.$fileNameToStore;               
        // }


        //     $creator = Creator::findOrFail($id);
        //     $creator->update($requestData);
        //     return redirect()->back()->with('message', 'Creator updated!');
        }
        return response(view('403'), 403);

    }

    public function destroy($id)
    {
        $model = str_slug('creator','-');
        if(auth()->user()->permissions()->where('name','=','delete-'.$model)->first()!= null) {
            Creator::destroy($id);
            return redirect()->back()->with('message', 'Creator deleted!');
        }
        return response(view('403'), 403);

    }
}
