<?php

namespace App\Http\Controllers\shortfilm;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use App\Models\Shortfilm;
use Illuminate\Http\Request;
use Image;
use File;

class ShortfilmController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $keyword = $request->get('search');
            $perPage = 25;

            if (!empty($keyword)) {
                $shortfilm = Shortfilm::where('name', 'LIKE', "%$keyword%")
                ->orWhere('image', 'LIKE', "%$keyword%")
                ->orWhere('description', 'LIKE', "%$keyword%")
                ->paginate($perPage);
            } else {
                $shortfilm = Shortfilm::paginate($perPage);
            }

            return view('shortfilm.shortfilm.index', compact('shortfilm'));
        }
        return response(view('403'), 403);

    }

    public function create()
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            return view('shortfilm.shortfilm.create');
        }
        return response(view('403'), 403);

    }


    public function storeShortVideo(Request $request)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                // 'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                // 'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            if ($validator->fails()) {
                // Validation failed, redirect back with errors and input data
                return redirect()->back()->with('message', 'Please enter all fields data !');
            }
            // dd($request->all());
            
            $video = new Shortfilm();
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
    
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->save();
            return back()->with('message', 'Video added successfully !!!');
            // $shortfilm = new Shortfilm($request->all());

            // if ($request->hasFile('image')) {

            //     $file = $request->file('image');
                
            //     //make sure yo have image folder inside your public
            //     $shortfilm_path = 'uploads/shortfilms/';
            //     $fileName = $file->getClientOriginalName();
            //     $profileImage = date("Ymd").$fileName.".".$file->getClientOriginalExtension();

            //     Image::make($file)->save(public_path($shortfilm_path) . DIRECTORY_SEPARATOR. $profileImage);

            //     $shortfilm->image = $shortfilm_path.$profileImage;
            // }
            
            // $shortfilm->save();
            // return redirect()->back()->with('message', 'Shortfilm added!');
        }
        return response(view('403'), 403);
    }


    public function show($id)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $shortfilm = Shortfilm::findOrFail($id);
            return view('shortfilm.shortfilm.show', compact('shortfilm'));
        }
        return response(view('403'), 403);
    }


    public function edit($id)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            $shortfilm = Shortfilm::findOrFail($id);
            return view('shortfilm.shortfilm.edit', compact('shortfilm'));
        }
        return response(view('403'), 403);
    }


    public function updateShortVideo(Request $request)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            
            $video = Shortfilm::find($request->vId);
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
            // dd($video);
            $path = 'uploads/shortfilm-thumbnails/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            $path = 'uploads/shortfilm-videos/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/shortfilm-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->update();
            return back()->with('message', 'Video updated successfully !!!');
        //     $requestData = $request->all();
            

        // if ($request->hasFile('image')) {
            
        //     $shortfilm = Shortfilm::where('id', $id)->first();
        //     $image_path = public_path($shortfilm->image); 
            
        //     if(File::exists($image_path)) {
        //         File::delete($image_path);
        //     }

        //     $file = $request->file('image');
        //     $fileNameExt = $request->file('image')->getClientOriginalName();
        //     $fileNameForm = str_replace(' ', '_', $fileNameExt);
        //     $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
        //     $fileExt = $request->file('image')->getClientOriginalExtension();
        //     $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
        //     $pathToStore = public_path('uploads/shortfilms/');
        //     Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);

        //      $requestData['image'] = 'uploads/shortfilms/'.$fileNameToStore;               
        // }


        //     $shortfilm = Shortfilm::findOrFail($id);
        //     $shortfilm->update($requestData);
        //     return redirect()->back()->with('message', 'Shortfilm updated!');
        }
        return response(view('403'), 403);

    }

    public function destroy($id)
    {
        $model = str_slug('shortfilm','-');
        if(auth()->user()->permissions()->where('name','=','delete-'.$model)->first()!= null) {
            Shortfilm::destroy($id);
            return redirect()->back()->with('message', 'Shortfilm deleted!');
        }
        return response(view('403'), 403);

    }
}
