<?php

namespace App\Http\Controllers\squarevideo;

use App\Http\Controllers\Controller;
use App\Http\Requests;

use App\Models\Squarevideo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use Image;
use File;

class SquarevideoController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */

    public function index(Request $request)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $keyword = $request->get('search');
            $perPage = 25;

            if (!empty($keyword)) {
                $squarevideo = Squarevideo::where('title', 'LIKE', "%$keyword%")
                ->orWhere('video link', 'LIKE', "%$keyword%")
                ->paginate($perPage);
            } else {
                $squarevideo = Squarevideo::paginate($perPage);
            }

            return view('squarevideo.squarevideo.index', compact('squarevideo'));
        }
        return response(view('403'), 403);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            return view('squarevideo.squarevideo.create');
        }
        return response(view('403'), 403);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function storeSqVideo(Request $request)
    {
        $model = str_slug('squarevideo','-');
        // if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            $validator = Validator::make($request->all(), [
                'video_title' => 'required',
                'video_tags' => 'required',
                'video_description' => 'required',
                // 'video_thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                // 'video_file' => 'required|mimetypes:video/mp4|max:2048',
            ]);
    
            if ($validator->fails()) {
                // Validation failed, redirect back with errors and input data
                return redirect()->back()->with('message', 'Please enter all fields data !');
            }
            // dd($request->all());
            
            $video = new Squarevideo();
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
    
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->save();
            return back()->with('message', 'Video added successfully !!!');
        // }
        // return response(view('403'), 403);
        // $model = str_slug('squarevideo','-');
        // if(auth()->user()->permissions()->where('name','=','add-'.$model)->first()!= null) {
            

        //     $squarevideo = new Squarevideo($request->all());

        //     if ($request->hasFile('image')) {

        //         $file = $request->file('image');
                
        //         //make sure yo have image folder inside your public
        //         $squarevideo_path = 'uploads/squarevideos/';
        //         $fileName = $file->getClientOriginalName();
        //         $profileImage = date("Ymd").$fileName.".".$file->getClientOriginalExtension();

        //         Image::make($file)->save(public_path($squarevideo_path) . DIRECTORY_SEPARATOR. $profileImage);

        //         $squarevideo->image = $squarevideo_path.$profileImage;
        //     }
            
        //     $squarevideo->save();
        //     return redirect()->back()->with('message', 'Squarevideo added!');
        // }
        // return response(view('403'), 403);
    }


    public function show($id)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','view-'.$model)->first()!= null) {
            $squarevideo = Squarevideo::findOrFail($id);
            return view('squarevideo.squarevideo.show', compact('squarevideo'));
        }
        return response(view('403'), 403);
    }


    public function edit($id)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            $squarevideo = Squarevideo::findOrFail($id);
            return view('squarevideo.squarevideo.edit', compact('squarevideo'));
        }
        return response(view('403'), 403);
    }

    public function updateSqVideo(Request $request)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','edit-'.$model)->first()!= null) {
            
            $video = Squarevideo::find($request->vId);
            $video->video_title = $request->video_title;
            $video->video_tags = $request->video_tags;
            $video->video_description = $request->video_description;
            // dd($video);
            $path = 'uploads/square-thumbnails/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_thumbnail')) {
                $file = $request->file('video_thumbnail');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-thumbnails/', $fileName);
                $video->video_thumbnail = $fileName;
            }
            $path = 'uploads/square-videos/' . $video->file;
            if(File::exists($image_path)) {
                File::delete($image_path);
            }
            if ($request->hasFile('video_file')) {
                $file = $request->file('video_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/square-videos/', $fileName);
                $video->video_file = $fileName;
            }
            $video->update();
            return back()->with('message', 'Video updated successfully !!!');
            
        //     $requestData = $request->all();
            

        // if ($request->hasFile('image')) {
            
        //     $squarevideo = Squarevideo::where('id', $id)->first();
        //     $image_path = public_path($squarevideo->image); 
            
        //     if(File::exists($image_path)) {
        //         File::delete($image_path);
        //     }

        //     $file = $request->file('image');
        //     $fileNameExt = $request->file('image')->getClientOriginalName();
        //     $fileNameForm = str_replace(' ', '_', $fileNameExt);
        //     $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
        //     $fileExt = $request->file('image')->getClientOriginalExtension();
        //     $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
        //     $pathToStore = public_path('uploads/squarevideos/');
        //     Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);

        //      $requestData['image'] = 'uploads/squarevideos/'.$fileNameToStore;               
        // }


        //     $squarevideo = Squarevideo::findOrFail($id);
        //     $squarevideo->update($requestData);
        //     return redirect()->back()->with('message', 'Squarevideo updated!');
        }
        return response(view('403'), 403);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        $model = str_slug('squarevideo','-');
        if(auth()->user()->permissions()->where('name','=','delete-'.$model)->first()!= null) {
            Squarevideo::destroy($id);
            return redirect()->back()->with('message', 'Squarevideo deleted!');
        }
        return response(view('403'), 403);

    }
}
