<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreatorFilmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('creator_films', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('video_title')->nullable();
            $table->string('video_thumbnail')->nullable();
            $table->string('video_file')->nullable();
            $table->string('video_tags')->nullable();
            $table->string('video_description')->nullable();
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('creator_films');
    }
}
