<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAgencyApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agency_applications', function (Blueprint $table) {
            $table->id();
            $table->string('agency_name')->nullable();
            $table->string('agency_insta_handle')->nullable();
            $table->string('agency_website')->nullable();
            $table->string('website_link')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('total_influencer')->nullable();
            $table->string('associated_web_apps')->nullable();
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agency_applications');
    }
}
