<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSpotLightFormsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('spot_light_forms', function (Blueprint $table) {
            $table->id();
            $table->string('square_id')->nullable();
            $table->string('email')->nullable();
            $table->string('series_name')->nullable();
            $table->string('series_content_type')->nullable();
            $table->string('series_description')->nullable();
            $table->string('series_rating')->nullable();
            $table->string('series_episode')->nullable();
            $table->string('film_trailer')->nullable();
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('spot_light_forms');
    }
}
