@extends('layouts.main')
@section('title', 'Account Details')
@section('content')

<?php $segment = Request::segments(); ?>

@php
        $profile = DB::table('profiles')
            ->where('user_id', Auth::id())
            ->first();
        $orders = DB::table('orders')->where('orders.user_id', Auth::user()->id)
				->orderBy('orders.id', 'desc')
				->get();
		$walletStrips = DB::table('user_wallets')->where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 0)->sum('value');
		$walletSnacks = DB::table('user_wallets')->where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 1)->sum('value');
    @endphp

<section class="banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="banner-wrapper inner-banner-wrapper">
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="section-heading text-center">
                                <h1>Account Details</h1>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<main class="my-cart">
    <!-- banner start -->
    <!-- banner end -->

<!-- main content start -->

 <!-- my account wrapper start -->
    <div class="my-account-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <!-- My Account Page Start -->
                    <div class="myaccount-page-wrapper">
                        <!-- My Account Tab Menu Start -->
                        <div class="row">
                            @include('account.sidebar')
                            <!-- My Account Tab Menu End -->
    
                            <!-- My Account Tab Content Start -->
                            <div class="col-lg-9 col-md-8">
                                <div class="tab-content" id="myaccountContent">
                                   
                                   <!-- Single Tab Content Start -->
                                    <div class="tab-pane active" id="account-info" role="tabpanel">
                                        <div class="myaccount-content">
                                            <!--<div class="section-heading">-->
                                            <!--    <h2>Account Details</h2>-->
                                            <!--</div>-->
    
                                            <div class="account-details-form">
                                               <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data" id="accountForm">
                                                @csrf
                                                    <div class="row">
                                                        
                                                        <div class="col-lg-6">
                                                            <label for="last-name" class="required">Profile Image</label>
                                                            <div class="profile-pic">
                                                              <label class="-label" for="file">
                                                                <span class="glyphicon glyphicon-camera"></span>
                                                                <span>Change Image</span>
                                                              </label>
                                                              <input id="file" type="file" name="profile_pic" onchange="loadFile(event)"/>
                                                              <img src="https://cdn.pixabay.com/photo/2017/08/06/21/01/louvre-2596278_960_720.jpg" id="output" width="200" value="<?php echo Auth::user()->name; ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="last-name" class="required">Name</label>
                                                                <input type="text" id="last-name" name="uname" placeholder="Last Name" value="<?php echo Auth::user()->name; ?>">
                                                            </div>
                                                        </div>
                                                    
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="email" class="required">Email Addres</label>
                                                                <input type="email" id="email" placeholder="Email Address" name="email" value="<?php echo Auth::user()->email; ?>">
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="email" class="required">Phone No</label>
                                                                <input type="number" id="p-no" placeholder="Phone number" name="phone" value="<?php echo Auth::user()->profile->phone; ?>">
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="email" class="required">Gender</label>
                                                                <select name="gender" class="form-control">
                                                                    <option value="Male" {{ (Auth::user()->profile->gender == 'Male') ? 'selected':''}} >Male</option>
                                                                    <option value="Female" {{ (Auth::user()->profile->gender == 'Female') ? 'selected':''}} >Female</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="email" class="required">Country</label>
                                                                <input type="text" id="p-no" placeholder="Country" name="country" value="<?php echo Auth::user()->profile->country; ?>">
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-lg-6">
                                                            <div class="single-input-item">
                                                                <label for="email" class="required">State</label>
                                                                <input type="text" id="p-no" placeholder="State" name="state" value="<?php echo Auth::user()->profile->state; ?>">
                                                            </div>
                                                        </div>
                                                        
                                                    </div>
                                                    <div class="single-input-item">
                                                        <button class="check-btn sqr-btn btn btn-red" id="updateProfile">Save Changes</button>
                                                    </div>
                                                    
                                                </form>
                                                <fieldset class="mt-3">
                                                    <form action="{{ route('update.password') }}" method="post" enctype="multipart/form-data" >
                                                       @csrf
                                                        <legend>Change Password</legend>
    
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                                <div class="single-input-item">
                                                                    <!--<label for="new-pwd" class="required">New Password</label>-->
                                                                    <input type="password" id="new-pwd" placeholder="New Password" name="password">
                                                                </div>
                                                            </div>
    
                                                            <div class="col-lg-6">
                                                                <div class="single-input-item">
                                                                    <!--<label for="confirm-pwd" class="required">Confirm Password</label>-->
                                                                    <input type="password" id="confirm-pwd" placeholder="Confirm Password" name="password_confirmation">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div class="single-input-item">
                                                                    <button class="check-btn sqr-btn btn btn-red" id="updateProfile">Update Password</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </fieldset>
    
                                            </div>
                                        </div>
                                    </div> <!-- Single Tab Content End -->
    
                                    
                                </div>
                            </div> <!-- My Account Tab Content End -->
                        </div>
                    </div> <!-- My Account Page End -->
                </div>
            </div>
        </div>
    </div>
    <!-- my account wrapper end -->


<!-- main content end -->   
</main>
@endsection
@section('css')
<style type="text/css">
.profile-pic {
	 color: transparent;
	 transition: all 0.3s ease;
	 display: flex;
	 justify-content: center;
	 align-items: center;
	 position: relative;
	 transition: all 0.3s ease;
}
 .profile-pic input {
	 display: none;
}
 .profile-pic img {
	 position: absolute;
	 object-fit: cover;
	 width: 165px;
	 height: 165px;
	 box-shadow: 0 0 10px 0 rgba(255, 255, 255, .35);
	 border-radius: 100px;
	 z-index: 0;
}
 .profile-pic .-label {
	 cursor: pointer;
	 height: 165px;
	 width: 165px;
}
 .profile-pic:hover .-label {
	 display: flex;
	 justify-content: center;
	 align-items: center;
	 background-color: rgba(0, 0, 0, .8);
	 z-index: 10000;
	 color: #fafafa;
	 transition: background-color 0.2s ease-in-out;
	 border-radius: 100px;
}
 .profile-pic span {
	 display: inline-flex;
	 padding: 0.2em;
	 height: 2em;
}
.check-btn{
    background-color: red;
    color: white;
}
/* body {*/
/*	 height: 100vh;*/
/*	 background-color: #191815;*/
/*	 display: flex;*/
/*	 justify-content: center;*/
/*	 align-items: center;*/
/*}*/
/* body a:hover {*/
/*	 text-decoration: none;*/
/*}*/
     
</style>
@endsection
@section('js')

<script type="text/javascript">
var loadFile = function (event) {
  var image = document.getElementById("output");
  image.src = URL.createObjectURL(event.target.files[0]);
  
  var imgName = event.target.files[0].name
  console.log(image.src);
  $('.pic_profile').val(imgName);
};

 $(document).on('click', "#updateProfile", function(e){
        $('#accountForm').submit();
  });

</script>

@endsection