@extends('layouts.main')
@section('title', 'Account Details')
@section('content')
<?php $segment = Request::segments(); ?>
    <style>
        section.banner {
            /* background-image: url(../img/home-banner.jpg); */
            padding-top: 150px !important;
            background-size: cover !important;
            background-repeat: no-repeat;
            background-position: bottom !important;
            padding-bottom: 70px !important;
        }

        .imgBox {
            width: 200px;
            height: 200px;
            background: aquamarine;
            border-radius: 50%;
        }

        .imgBox img {
            width: 200px;
            height: 200px;
            border-radius: 50%;
        }

        .proBg {
            background: linear-gradient(45deg, black, #ff000094);
        }

        .proBg1 {
            padding: 30px;
            background: linear-gradient(45deg, #ff000094, black);
        }

        .tab {
            padding: 10px 20px;
            margin: 5px;
            border: 1px solid #ccc;
            cursor: pointer;
        }

        .active {
            background-color: white;
            color: black;
        }

        .tab-content {
            display: none;
            border: 1px solid #ccc;
            height: 900px;
        }

        .tab-content.active {
            display: block;
        }

        .proBg {
            padding: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    
        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid transparent;
            border-radius: .25rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 6px 0 rgb(218 218 253 / 65%), 0 2px 6px 0 rgb(206 206 238 / 54%);
        }

        .me-2 {
            margin-right: .5rem !important;
        }
        
        .input-group-addon{
            display: flex;
            align-items: center;
            justify-content: center;
            background: black;
            padding: 6px 10px;
        }
        
    </style>
    <section class="banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-wrapper inner-banner-wrapper">
                        <div class="row justify-content-center">
                            <div class="col-lg-12">
                                <div class="section-heading text-center">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @php
        $profile = DB::table('profiles')
            ->where('user_id', Auth::id())
            ->first();
        $orders = DB::table('orders')->where('orders.user_id', Auth::user()->id)
				->orderBy('orders.id', 'desc')
				->get();
		$walletStrips = DB::table('user_wallets')->where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 0)->sum('value');
		$walletSnacks = DB::table('user_wallets')->where('user_id', Auth::user()->id)->where('payment_status',1)->where('is_snack', 1)->sum('value');
		//dd($profile);
    @endphp
    <!-- my account wrapper start -->
    <div class="my-account-wrapper">
        <div class="container">
            <div class="row proBg">
                <div class="banner-wrapper inner-banner-wrapper">
                    <div class="section-heading text-center">
                        <h1 class="fw-bold" style="font-size: 50px; font-weight: 700;">Account Details</h1>
                    </div>
                </div>
            </div>
            <div class="row proBg1 justify-content-around">
                <div class="tab active" data-tab="1">Profile</div>
                <div class="tab inactive" data-tab="2">Square Videos</div>
                <div class="tab inactive" data-tab="3">Short Reels</div>
                <div class="tab inactive" data-tab="6">Square Series</div>
                <div class="tab inactive" data-tab="4">Short Films</div>
                <div class="tab inactive" data-tab="5">Settings</div>
            </div>
                    @php
                        $squarevideos = DB::table('creator_sq_videos')->where('user_id',Auth::id())->get();
                        $creatorReels = DB::table('creator_films')->where('user_id',Auth::id())->get();
                        $shortfilms = DB::table('shortfilms')->where('user_id',Auth::id())->get();
                        $series = DB::table('creators')->where('user_id',Auth::id())->get();
                        $userInfo = DB::table('profiles')->where('user_id',Auth::id())->first();
                        $schedules = DB::table('stream_schedules')->where('user_id',Auth::id())->first();
                        //dd($userInfo);
                    @endphp
            <div class="">
                <div class="tab-content active" id="content1">
                    <div class="d-flex align-items-center">
                        <div class="container">
                            <div class="main-body">
                                <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data" id="accountForm">
                                    @csrf
                                    <div class="row mt-4" style="display: flex; align-items: center; justify-content: center; flex-direction: column;">
                                        <div class="col-lg-8">
                                            <div class="row">
                                                <div class="card col-md-6">
                                                    <div class="card-body">
                                                        <div class="d-flex flex-column align-items-center text-center">
                                                            <div class="profile-pic">
                                                                @if(Auth::user()->profile)
                                                                    <img src="{{ asset('uploads/users/'.Auth::user()->profile) }}" id="output" width="200" value="<?php echo Auth::user()->name; ?>"/>
                                                                @else
                                                                    <img src="https://cdn.pixabay.com/photo/2017/08/06/21/01/louvre-2596278_960_720.jpg" id="output" width="200" value="<?php echo Auth::user()->name; ?>"/>
                                                                @endif
                                                            </div>
                                                            <div class="mt-3">
                                                                <h4>{{ Auth::user()->name }}</h4>
                                                                <p class="text-muted font-size-sm">{{ Auth::user()->email }}</p>
                                                                <a href="{{ url('logout') }}"><button type="button" class="btn btn-outline-danger">logout</button></a>
                                                                @if($schedules)
                                                                <a href="{{route('get.streaming.page',Auth::id())}}"><button type="button" class="btn btn-danger"><i class="fa fa-video mx-3"></i>Go Live</button></a>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card col-md-6">
                                                    <div class="card-body">
                                                        <div class="mt-3">
                                                            <h4 class="text-center">Your Wallet</h4>
                                                            <p class="text-muted font-size-sm"></p>
                                                            <div class="text-left">
                                                                <p>
                                                                    <strong>Snacks: </strong> {{$walletSnacks}}
                                                                </p>
                                                                <p>
                                                                    <strong>Film Strips: </strong> {{$walletStrips}}
                                                                </p>
                                                                <p>
                                                                    <strong>USD: </strong> 0
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <div class="text-secondary">
                                                                <input id="file" type="text" name="convert_snacks" class="form-control" placeholder="Snacks to USD"/>
                                                            </div>
                                                            <div>
                                                                <button class="btn btn-outline-primary">Convert</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Profile</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input id="file" type="file" name="profile" class="form-control" value="<?php echo Auth::user()->name; ?>"/>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Full Name</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input type="text" name="name" class="form-control" value="<?php echo Auth::user()->name; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Email</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input type="text" name="email" class="form-control" value="<?php echo Auth::user()->email; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Phone</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input type="text" name="phone" class="form-control" value="<?php echo isset($userInfo->phone) ? $userInfo->phone : 'N/A'; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Gender</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <select name="gender" class="form-control">
                                                                <option value="Male" {{ ($userInfo->gender == 'Male') ? 'selected':''}} >Male</option>
                                                                <option value="Female" {{ ($userInfo->gender == 'Female') ? 'selected':''}} >Female</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">Country</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input type="text" class="form-control" name="country"
                                                                value="<?php echo isset($userInfo->country) ? $userInfo->country : 'N/A'; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-3">
                                                            <h6 class="mb-0">State</h6>
                                                        </div>
                                                        <div class="col-sm-9 text-secondary">
                                                            <input type="text" class="form-control"
                                                                   name="state" value="<?php echo isset($userInfo->state) ? $userInfo->state : 'N/A'; ?>">
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row text-center">
                                                        <div class="col-sm-12 text-secondary">
                                                            <input type="submit" class="btn btn-danger px-4" value="Save Changes">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-content bg-white" id="content2" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="d-flex align-items-center justify-content-between px-5" style="height: 60px; background: skyblue;">
                        <div>
                            <h4 class="fw-bold">Square Videos</h4>
                        </div>
                        <div>
                            <button class="btn btn-primary float-end" data-toggle="modal" data-target="#addSqVideo">Add video</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Thumbnail</th>
                                        <th>File</th>
                                        <th>Title</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($squarevideos as $item)
                                    <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <img src="{{ asset('uploads/square-thumbnails/' . $item->video_thumbnail) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;">
                                        </div>
                                    </td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <video controls="true" muted="true" src="{{ asset('uploads/square-videos/' . $item->video_file) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;"></video>
                                        </div>
                                    </td>
                                    <td>{{ $item->video_title }}</td>
                                    <td>
                                            <a href="javascript:void(0);"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-primary btn-sm">
                                                    <i class="fa fa-pencil-square-o" aria-hidden="true"> </i> Edit
                                                </button>
                                            </a>
                                            <a href="{{ route('creator.delete.video',$item->id) }}"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash-o" aria-hidden="true"> </i> Delete
                                                </button>
                                            </a>
                                    </td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                </div>
                <div class="tab-content bg-white" id="content3" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="d-flex align-items-center justify-content-between px-5" style="height: 60px; background: skyblue;">
                        <div>
                            <h4 class="fw-bold">Short Videos</h4>
                        </div>
                        <div>
                            <button class="btn btn-primary float-end" data-toggle="modal" data-target="#addShrtVideo">Add video</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Thumbnail</th>
                                        <th>File</th>
                                        <th>Title</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($creatorReels as $item)
                                    <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <img src="{{ asset('uploads/shortfilm-thumbnails/' . $item->video_thumbnail) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;">
                                        </div>
                                    </td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <video controls="true" muted="true" src="{{ asset('uploads/shortfilm-videos/' . $item->video_file) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;"></video>
                                        </div>
                                    </td>
                                    <td>{{ $item->video_title }}</td>
                                    <td>
                                            <a href="javascript:void(0);"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-primary btn-sm">
                                                    <i class="fa fa-pencil-square-o" aria-hidden="true"> </i> Edit
                                                </button>
                                            </a>
                                            <a href="{{ route('creator.delete.film',$item->id) }}"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash-o" aria-hidden="true"> </i> Delete
                                                </button>
                                            </a>
                                    </td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                </div>
                <div class="tab-content bg-white" id="content4" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="d-flex align-items-center justify-content-between px-5" style="height: 60px; background: skyblue;">
                        <div>
                            <h4 class="fw-bold">Short Films</h4>
                        </div>
                        <div>
                            <button class="btn btn-primary float-end" data-toggle="modal" data-target="#addShrtFilm">Add Film</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Thumbnail</th>
                                        <th>File</th>
                                        <th>Title</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($shortFilms as $item)
                                    <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <img src="{{ asset('uploads/series-thumbnails/' . $item->video_thumbnail) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;">
                                        </div>
                                    </td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <video controls="true" muted="true" src="{{ asset('uploads/square-series/' . $item->video_file) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;"></video>
                                        </div>
                                    </td>
                                    <td>{{ $item->video_title }}</td>
                                    <td>
                                            <a href="javascript:void(0);"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-primary btn-sm">
                                                    <i class="fa fa-pencil-square-o" aria-hidden="true"> </i> Edit
                                                </button>
                                            </a>
                                            <a href="{{ route('delete.short.film',$item->id) }}"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash-o" aria-hidden="true"> </i> Delete
                                                </button>
                                            </a>
                                    </td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="tab-content bg-white" id="content5" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-7 mx-auto text-dark">
                                    <div class="card p-5">
                                        <h2 class="text-center text-dark mt-4 mb-4" style="font-weight: bold;">Change Password</h2>
                                        <hr>
                                        <form action="{{ route('update.password') }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label for="password">Password</label>
                                                <div class="input-group" id="show_hide_password">
                                                    <input class="form-control" name="password" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="password_confirmation">Confirm Password</label>
                                                <div class="input-group" id="show_hide_confirm_password">
                                                    <input class="form-control" name="password_confirmation" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="confirm_password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row justify-content-center">
                                                <button class="btn btn-danger">Update Password</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                <div class="tab-content bg-white" id="content6" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="d-flex align-items-center justify-content-between px-5" style="height: 60px; background: skyblue;">
                        <div>
                            <h4 class="fw-bold">Square Series</h4>
                        </div>
                        <div>
                            <button class="btn btn-primary float-end" data-toggle="modal" data-target="#addSqSeries">Add video</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Thumbnail</th>
                                        <th>File</th>
                                        <th>Title</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($series as $item)
                                    <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <img src="{{ asset('uploads/series-thumbnails/' . $item->video_thumbnail) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;">
                                        </div>
                                    </td>
                                    <td>
                                        <div style="width: 100%; height: 200px;">
                                            <video controls="true" muted="true" src="{{ asset('uploads/square-series/' . $item->video_file) }}" alt="Card Image: 2"
                                                class="card-image" style="width: 100%; height: 200px;"></video>
                                        </div>
                                    </td>
                                    <td>{{ $item->video_title }}</td>
                                    <td>
                                            <a href="javascript:void(0);"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-primary btn-sm">
                                                    <i class="fa fa-pencil-square-o" aria-hidden="true"> </i> Edit
                                                </button>
                                            </a>
                                            <a href="{{ route('creator.delete.series',$item->id) }}"
                                               title="Edit Squarevideo">
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash-o" aria-hidden="true"> </i> Delete
                                                </button>
                                            </a>
                                    </td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                </div>
            </div>
        </div>
    </div>


<!--add sq video-->
<div class="modal fade" id="addSqVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Video Detail</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="{{ route('creator.store.video') }}" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea type="text" name="video_description" class="form-control ckeditor"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>

<!--add sq video-->
<div class="modal fade" id="addSqSeries" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Series Detail</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="{{ route('creator.store.series') }}" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea type="text" name="video_description" class="form-control ckeditor"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>

<!--add short video-->
<div class="modal fade" id="addShrtVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Short Video</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="{{ route('creator.store.film') }}" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea class="form-control ckeditor" name="video_description" cols="50" rows="10"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>

<!--add short film -->
<!--add short video-->
<div class="modal fade" id="addShrtFilm" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Short Film</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="{{ route('store.short.film') }}" accept-charset="UTF-8" enctype="multipart/form-data">
            @csrf
            <div class="form-body text-dark">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                           <label for="product_title">Video Title</label>
                           <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="price">Tags</label>
                            <input class="form-control" required="required" name="video_tags" type="text" id="price">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control ckeditor" name="video_description" cols="50" rows="10"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="image">Video Thumbnail</label>
                            <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="image">Video Trailer</label>
                            <input class="form-control dropify" name="video_trailer" type="file" id="image">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="image">Video File</label>
                            <input class="form-control dropify" name="video_file" type="file" id="image">
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <div>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
                <div class="form-actions text-right pb-0">
                    <input class="btn btn-success" type="submit" value="Create">
                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
                $(document).ready(function () {
                    $('.tab-content:not(.active)').hide();
                    // Handle tab clicks
                    $('.tab').click(function () {
                        // Get the data-tab attribute value
                        var tabNumber = $(this).data('tab');
                        // Hide all tab contents
                        $('.tab-content').hide().find('*').hide();
                        // Show the selected tab content
                        $('#content' + tabNumber).show().find('*').show();
                        // Remove 'active' class from all tabs
                        $('.tab').removeClass('active');
                        // Add 'active' class to the selected tab
                        $(this).addClass('active');
                    });
                    
                    $("#show_hide_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_password input').attr("type") == "text"){
                            $('#show_hide_password input').attr('type', 'password');
                            $('#show_hide_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_password input').attr("type") == "password"){
                            $('#show_hide_password input').attr('type', 'text');
                            $('#show_hide_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_password i').addClass( "fa-eye" );
                        }
                    });
                    
                    $("#show_hide_confirm_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_confirm_password input').attr("type") == "text"){
                            $('#show_hide_confirm_password input').attr('type', 'password');
                            $('#show_hide_confirm_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_confirm_password input').attr("type") == "password"){
                            $('#show_hide_confirm_password input').attr('type', 'text');
                            $('#show_hide_confirm_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').addClass( "fa-eye" );
                        }
                    });

                });
            </script>
<script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>
    
    <script src="https://meet.jit.si/external_api.js"></script>
    <script>
        const domain = 'meet.jit.si';
        const options = {
            roomName: 'Live-Streaming',
            width: '100%',
            height: '100%',
            parentNode: document.querySelector('#streamVideo'),
            configOverwrite: {
                startWithAudioMuted: true,
                startWithVideoMuted: true,
            },
            interfaceConfigOverwrite: {
                SHOW_CHROME_EXTENSION_BANNER: false,
            },
        };

        const api = new JitsiMeetExternalAPI(domain, options);

        api.addEventListener('videoConferenceJoined', () => {
            console.log('Video conference joined');
        });

        api.addEventListener('videoConferenceLeft', () => {
            console.log('Video conference left');
        });
    </script>
    
<script type="text/javascript">
var loadFile = function (event) {
  var image = document.getElementById("output");
  image.src = URL.createObjectURL(event.target.files[0]);
  
  var imgName = event.target.files[0].name
  console.log(image.src);
  $('.pic_profile').val(imgName);
};


</script>

@endsection

