@section('title','Register')
@extends('layouts.main')
@section('css')
<style>
*{
    margin: 0;
    padding: 0;
    font-family: 'poppins',sans-serif;
}
section{
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    width: 100%;
    
    background: url('https://raw.githubusercontent.com/Hashtechieofficial/Form-/main/background6.jpg')no-repeat;
    background-position: center;
    background-size: cover;
}
.form-box{
    position: relative;
    width: 400px;
    height: 450px;
    background: transparent;
    border: 2px solid rgba(255,255,255,0.5);
    border-radius: 20px;
    backdrop-filter: blur(15px);
    display: flex;
    justify-content: center;
    align-items: center;

}
h2{
    font-size: 2em;
    color: #fff;
    text-align: center;
}
.inputbox{
    position: relative;
    margin: 30px 0;
    width: 310px;
    border-bottom: 2px solid #fff;
}
.inputbox label{
    position: absolute;
    top: 50%;
    left: 5px;
    transform: translateY(-50%);
    color: #fff;
    font-size: 1em;
    pointer-events: none;
    transition: .5s;
}
input:focus ~ label,
input:valid ~ label{
top: -5px;
}
.inputbox input {
    width: 100%;
    height: 50px;
    background: transparent;
    border: none;
    outline: none;
    font-size: 1em;
    padding:0 35px 0 5px;
    color: #fff;
}
.inputbox ion-icon{
    position: absolute;
    right: 8px;
    color: #fff;
    font-size: 1.2em;
    top: 20px;
}
.forget{
    margin: -15px 0 15px ;
    font-size: .9em;
    color: #fff;
    display: flex;
    justify-content: space-between;  
}

.forget label input{
    margin-right: 3px;
    
}
.forget label a{
    color: #fff;
    text-decoration: none;
}
.forget label a:hover{
    text-decoration: underline;
}
button{
    width: 100%;
    height: 40px;
    border-radius: 40px;
    background: #fff;
    border: none;
    outline: none;
    cursor: pointer;
    font-size: 1em;
    font-weight: 600;
}
.register{
    font-size: .9em;
    color: #fff;
    text-align: center;
    margin: 25px 0 10px;
}
.register p a{
    text-decoration: none;
    color: #fff;
    font-weight: 600;
}
.register p a:hover{
    text-decoration: underline;
}
</style>
@endsection
@section('content')


    <section class="py-5" style="padding: 200px 0px !important;">
        <div class="container">
            <div class="row justify-content-around">
                <div class="col-md-5">
                    <div class="form-box" style="background: linear-gradient(45deg, #6A2541, #CE3E69);">
                    <div class="form-value">
                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <h2>Creator Login</h2>
                            <div class="inputbox">
                                <ion-icon name="mail-outline"></ion-icon>
                                <input type="email" class="{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>
                                <label for="">Email</label>
                                @if ($errors->has('email'))
                                <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('email') }}</small>
                                @endif
                            </div>
                            <div class="inputbox">
                                <ion-icon name="lock-closed-outline"></ion-icon>
                                <input type="password" class="{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>
                                <label for="">Password</label>
                                @if ($errors->has('password'))
                                <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('password') }}</small>
                                @endif
                            </div>
                            <div class="forget">
                                <label for=""><input type="checkbox">Remember Me  <a href="#">Forget Password</a></label>
                              
                            </div>
                            <button>Log in</button>
                            <div class="register">
                                <p>Don't have a account <a href="{{route('signup')}}">Register</a></p>
                            </div>
                        </form>
                    </div>
                </div>
                </div>
                <div class="col-md-5">
                    <div class="form-box" style="background: linear-gradient(45deg, black, #600202);">
                    <div class="form-value">
                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <h2>Public Login</h2>
                            <div class="inputbox">
                                <ion-icon name="mail-outline"></ion-icon>
                                <input type="email" class="{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>
                                <label for="">Email</label>
                                @if ($errors->has('email'))
                                <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('email') }}</small>
                                @endif
                            </div>
                            <div class="inputbox">
                                <ion-icon name="lock-closed-outline"></ion-icon>
                                <input type="password" class="{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>
                                <label for="">Password</label>
                                @if ($errors->has('password'))
                                <small class="alert alert-danger w-100 d-block p-2 mt-2">{{ $errors->first('password') }}</small>
                                @endif
                            </div>
                            <div class="forget">
                                <label for=""><input type="checkbox">Remember Me  <a href="#">Forget Password</a></label>
                              
                            </div>
                            <button>Log in</button>
                            <div class="register">
                                <p>Don't have a account <a href="{{route('signup')}}">Register</a></p>
                            </div>
                        </form>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('js')
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
<script>
    $("#phone").on("keypress keyup blur",function (event) {    
       $(this).val($(this).val().replace(/[^\d].+/, ""));
        if ((event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });
</script>
@endsection