@extends('layouts.app')

@push('before-css')
    <link href="{{asset('plugins/components/datatables/jquery.dataTables.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="https://cdn.datatables.net/buttons/1.2.2/css/buttons.dataTables.min.css" rel="stylesheet"
          type="text/css"/>
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">      
@endpush

@section('content')
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2 breadcrumb-new">
        <h3 class="content-header-title mb-0 d-inline-block">Partnership</h3>
        <div class="row breadcrumbs-top d-inline-block">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">Home</li>
                    <li class="breadcrumb-item active">Partnership</li>
                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="btn-group float-md-right">
            <!--<a class="btn btn-info mb-1" href="{{ url('admin/product/create') }}">Add Product</a>-->
        </div>
    </div>
</div>

<section id="configuration">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Partnership Data</h4>
                    <a class="heading-elements-toggle"><i class="la la-ellipsis-v font-medium-3"></i></a>
                    <div class="heading-elements">
                        <ul class="list-inline mb-0">
                            <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                            <li><a data-action="reload"><i class="ft-rotate-cw"></i></a></li>
                            <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                            <li><a data-action="close"><i class="ft-x"></i></a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-content collapse show">
                    <div class="card-body card-dashboard">
                        <div class="">
                            <table class="table table-striped table-bordered zero-configuration" id="myTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Agency Name</th>
                                        <th>Agency Instagram Handle</th>
                                        <th>Agency Website</th>
                                        <th>Website Link</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <!--<th>Total Influencer</th>-->
                                        <!--<th>Associated Web Apps</th>-->
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($data as $data)
                                    @php
                                       // dd($data);
                                    @endphp
                                        <tr>
                                            <td>{{ $data['id'] }}</td>
                                            <td>{{ $data['agency_name'] }}</td>
                                            <td>{{ $data['agency_insta_handle'] }}</td>
                                            <td>{{ $data['agency_website'] }}</td>
                                            <td>{{ $data['website_link'] }}</td>
                                            <td>{{ $data['email'] }}</td>
                                            <td>{{ $data['phone'] }}</td>
                                            <!--<td>{{ $data['total_influencer'] }}</td>-->
                                            <!--<td>{{ $data['associated_web_apps'] }}</td>-->
                                        </tr>
                                    @endforeach  
                                </tbody>
                                <tfoot>
                                     <tr>
                                        <th>ID</th>
                                        <th>Agency Name</th>
                                        <th>Agency Instagram Handle</th>
                                        <th>Agency Website</th>
                                        <th>Website Link</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <!--<th>Total Influencer</th>-->
                                        <!--<th>Associated Web Apps</th>-->
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('js')<!-- ============================================================== -->
<script src="{{asset('plugins/components/datatables/jquery.dataTables.min.js')}}"></script>
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<script>
  $(function() {
    $('.toggle-class').change(function() {
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var movie_id = $(this).data('id'); 
         
        $.ajax({
            type: "GET",
            dataType: "json",
            url: '{{route("changePopularStatus")}}',
            data: {'status': status, 'movie_id': movie_id},
            success: function(data){
             
               $.toast({
                heading: 'Success!',
                position: 'top-center',
                text: data.success,
                loaderBg: '#ff6849',
                icon: 'success',
                hideAfter: 3000,
                stack: 6
                });
            }
        });
    })
  })
</script>
<script>
    $(function () {
        $('#myTable').DataTable();
        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 18,
            "drawCallback": function (settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function (group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
    });
</script>
@endpush