@extends('layouts.app')
@push('before-css')
    <link rel="stylesheet" href="{{asset('plugins/vendors/dropify/dist/css/dropify.min.css')}}">
@endpush
@section('content')
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2 breadcrumb-new">
        <h3 class="content-header-title mb-0 d-inline-block">Product</h3>
        <div class="row breadcrumbs-top d-inline-block">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">Home</li>
                    <li class="breadcrumb-item active">Product</li>
                    <li class="breadcrumb-item active">Edit Product</li>
                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="btn-group float-md-right">
        </div>
    </div>
</div>

<div class="content-body">
  <section id="basic-form-layouts">
      <div class="row ">
          <div class="col-md-8 mx-auto">
              <div class="card">
                  <div class="card-header">
                      <h4 class="card-title" id="basic-layout-form">Product Info</h4>
                      <a class="heading-elements-toggle"><i class="la la-ellipsis-v font-medium-3"></i></a>
                      <div class="heading-elements">
                          <ul class="list-inline mb-0">
                              <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                              <li><a data-action="reload"><i class="ft-rotate-cw"></i></a></li>
                              <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                              <li><a data-action="close"><i class="ft-x"></i></a></li>
                          </ul>
                      </div>
                  </div>
                  <div class="card-content collapse show">
                        <div class="card-body">
                            <form method="POST" action="{{ route('admin.product.update.post') }}" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <input class="form-control" type="hidden" required="required" name="proId" value="{{ $product->id }}" type="text" id="product_title">
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="item">Select Category:</label>
                                                <select class="form-control" name="category_name">
                                                    <option value="t-shirts" {{ $product->category_name === 't-shirts' ? 'selected' : '' }}>T-shirts</option>
                                                    <option value="shorts" {{ $product->category_name === 'shorts' ? 'selected' : '' }}>Shorts</option>
                                                    <option value="shoes" {{ $product->category_name === 'shoes' ? 'selected' : '' }}>Shoes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Product Title</label>
                                               <input class="form-control" required="required" name="pro_name" value="{{ $product->pro_name }}" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Price</label>
                                                <input class="form-control" required="required" name="pro_price" value="{{ $product->pro_price }}" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea class="form-control" id="summary-ckeditor" name="pro_description" value="{{ $product->pro_description }}"
                                                cols="50" rows="10" style="visibility: hidden; display: none;">{!! $product->pro_description !!}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Image</label>
                                                <input class="form-control dropify" name="pro_image" value="{{ $product->pro_image }}" type="file" id="image">
                                                <div>
                                                    <img src="{{ asset('uploads/products/'.$product->pro_image) }}" alt="" style="width: 200px; height: 200px;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="additional_image">Gallary Image</label>
                                                <input class="form-control dropify" name="pro_images[]" value="{{ $product->pro_images }}" type="file" id="image" multiple>
                                                @if ($product->gallery_images)
                                                    <div>
                                                        @foreach (json_decode($product->gallery_images) as $image)
                                                            <img src="{{ asset('uploads/products/'.$image) }}" alt="" style="width: 200px; height: 200px;">
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-actions text-right pb-0">
                                    <input class="btn btn-success" type="submit" value="Update">
                                </div>
                            </form>
                        </div>
                  </div>
              </div>
          </div>
      </div>
  </section>
</div>
@endsection
@push('js')
  
  <script src="{{asset('js/jquery.repeater.min.js')}}"></script>
  <script src="{{asset('plugins/vendors/dropify/dist/js/dropify.min.js')}}"></script>
  <script>
      $(function() {
          $('.dropify').dropify();
      });
      !function(e,t,r){"use strict";r(".repeater-default").repeater(),r(".file-repeater, .contact-repeater").repeater({show:function(){r(this).slideDown()},hide:function(e){confirm("Are you sure you want to remove this item?")&&r(this).slideUp(e)}})}(window,document,jQuery);
      
      function getval(sel)
        {
            var globelsel = sel;
            let value = sel.value;

            // alert(value);
            
            $.ajax({
            url: "{{ route('get-attributes')}}",
                type:"POST",
                data:{
                    "_token": "{{ csrf_token() }}",
                    value:value
                },
                success:function(response){
                    $(globelsel).parent().parent().find('.value').html('');
                    if(response.status){
                        var html = '';
                        for(var i = 0; i < response.message.length; i++){
                            html += '<option value="'+response.message[i].id+'">'+response.message[i].value+'</option>';
                        }
                        $(globelsel).parent().parent().find('.value').html(html);
                    }
                    else{

                    }
                },
                });
        }
  </script>
@endpush
