@extends('layouts.main')

@section('content')

<!-- Include Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- Include Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
    // Display success message
    toastr.success('{{ session("success") }}');

    // Display error message
    toastr.error('{{ session("error") }}');

    // Display warning message
    toastr.warning('{{ session("warning") }}');

    // Display info message
    toastr.info('{{ session("info") }}');
</script>

<style>
    .MoviesVector {
    /* left: 7%; */
    /* top: 61%; */
    right: 0;
    width: 50%;
}
</style>
    
    <!--agency form -->
    <section class="youtubeSec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="InnerBannerContent">
                        <h1>Agency Application</h1>
                        <div class="AboutVector MoviesVector">
                            <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/images/heading-bg.png"
                                class="img-fluid" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <p style="line-height: 2; font-size: 20px;">
                        Our Agency Program offers special incentives, income with a bonus structure chart and exclusive features.
                        Please fill out the questions below and a Talent representative will respond in 3 to 7 days.
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 mx-auto">
                    <div class="card p-4" style="background: #0d0d0e;">
                        <form action="{{ route('agency.form.post') }}" method="post">
                            @csrf
                            <div class="form-group">
                                <label for="agencyName">Name of Agency or LLC</label>
                                <input type="text" class="form-control" id="agencyName" name="agency_name" placeholder="Enter the name of your agency or LLC" required>
                            </div>
                            <div class="form-group">
                                <label for="agencyInstagram">Agency Instagram</label>
                                <input type="text" class="form-control" id="agencyInstagram" name="agency_instagram" placeholder="Enter your agency's Instagram handle">
                            </div>
                            <div class="form-group">
                                <label for="agencyWebsite">Agency Website</label>
                                <input type="text" class="form-control" id="agencyWebsite" name="agency_website" placeholder="Enter your agency's website">
                            </div>
                            <div class="form-group">
                                <label for="numInfluencers">Number of influencers under the agency</label>
                                <select class="form-control" id="numInfluencers" name="num_influencers">
                                    <option value="1-24">1 - 24</option>
                                    <option value="25-49">25 - 49</option>
                                    <option value="50-75">50 – 75</option>
                                    <option value="75+">75 +</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="app_web_associated">Apps or Websites Associated</label>
                            </div>
                            <div class="form-group d-flex justify-content-between">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="app17Live" value="17live">
                                    <label class="form-check-label" for="app17Live">17live</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appAmazon" value="Amazon">
                                    <label class="form-check-label" for="appAmazon">Amazon</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appBigo" value="Bigo">
                                    <label class="form-check-label" for="appBigo">Bigo</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appBLK">
                                    <label class="form-check-label" for="appBLK">BLK</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appCoco">
                                    <label class="form-check-label" for="appCoco">Coco</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appDiscord">
                                    <label class="form-check-label" for="appDiscord">Discord</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appKik">
                                    <label class="form-check-label" for="appKik">Kik</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appKick">
                                    <label class="form-check-label" for="appKick">Kick</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appLiveme">
                                    <label class="form-check-label" for="appLiveme">Liveme</label>
                                </div>
                            </div>
                            <div class="form-group d-flex justify-content-between">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appMeetme">
                                    <label class="form-check-label" for="appMeetme">Meetme</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appMico">
                                    <label class="form-check-label" for="appMico">Mico</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appSuperlive">
                                    <label class="form-check-label" for="appSuperlive">Superlive</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appSpotify">
                                    <label class="form-check-label" for="appSpotify">Spotify</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appTango">
                                    <label class="form-check-label" for="appTango">Tango</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appTubi">
                                    <label class="form-check-label" for="appTubi">Tubi</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appTwitch">
                                    <label class="form-check-label" for="appTwitch">Twitch</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appUplive">
                                    <label class="form-check-label" for="appUplive">Uplive</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appYounow">
                                    <label class="form-check-label" for="appYounow">Younow</label>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="associated_apps[]" id="appYoutube">
                                    <label class="form-check-label" for="appYoutube">Youtube</label>
                                </div>
                            </div>
                            <div class="form-group mt-2">
                                <label for="otherApp">Website Link</label>
                                <input type="text" class="form-control" id="otherApp" name="website_link" placeholder="Specify other app/website">
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" required>
                            </div>
                            <div class="form-group">
                                <label for="phone">Phone</label>
                                <input type="tel" class="form-control" id="phone" name="phone" placeholder="Enter your phone number">
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn w-25" style="background: #A60000; color: white;">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection
@section('css')
    <style>

    </style>
@endsection

@section('js')
@endsection