@extends('layouts.main')
@section('content')
    <style>
        button+button {
            margin-left: 0.75em;
        }

        .upload {
            text-align: center;
            margin-bottom: 0;
            padding-bottom: 0;
        }

        .video-box {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .player {
            width: 100%;
            border: 0.25rem solid rgba(0, 0, 0, 0.445);
            position: relative;
            font-size: 0;
            overflow: hidden;
        }

        .player_video {
            width: 100%;
            cursor: pointer;
        }

        .fa {
            color: white;
            font-size: 1rem;
        }

        .fa-play:hover,
        .fa-pause:hover,
        .fa-stop:hover,
        .fa-volume-up:hover,
        .fa-fast-backward:hover,
        .fa-fast-forward:hover {
            color: dodgerblue;
            cursor: pointer;
        }

        .player_button {
            background: none;
            border: 0;
            line-height: 1;
            color: white;
            text-align: center;
            outline: 0;
            padding: 0;
            cursor: pointer;
            max-width: 50px;
            font-size: 1rem;
        }

        .player_button:focus,
        .player_button:hover {
            border-color: #ffc600;
            border-color: blue;
        }

        .player_slider {
            width: 0.75rem;
            height: 3rem;
        }

        .player_controls {
            display: flex;
            position: absolute;
            bottom: 0;
            width: 100%;
            transform: translateY(100%) translateX(-5px);
            transition: all 0.3s;
            flex-wrap: wrap;
            background: rgba(0, 0, 0, 0.1);
            padding: 0 1.5rem;
        }

        .player:hover .player_controls {
            transform: translateY(0);
        }

        .player:hover .progress-range {
            height: 0.75rem;
        }

        .right-controls {
            display: flex;
            justify-content: flex-end;
        }

        .left-controls {
            display: flex;
            justify-content: flex-start;
        }

        .player_controls>* {
            flex: 1;
        }

        .progress-range {
            flex: 10;
            position: relative;
            display: flex;
            flex-basis: 100%;
            height: 1.5em;
            transition: height 0.3s;
            background: rgba(0, 0, 0, 0.25);
            cursor: pointer;
        }

        .progress-bar {
            background: dodgerblue;
            width: 50%;
            height: 100%;
            border-radius: 1.5em;
            transition: all 250ms ease;
        }

        .player:fullscreen {
            max-width: none;
            width: 100%;
        }

        .player:-webkit-full-screen {
            /*CHROME*/
            max-width: none;
            width: 100%;
        }

        .player:-moz-full-screen {
            /*FIREFOX*/
            max-width: none;
            width: 100%;
        }

        .time {
            text-align: right;
            position: relative;
            top: 0.85em;
            padding-left: 0.5em;
            margin-right: 1em;
            color: white;
            font-weight: 600;
            font-size: 1rem;
            /* user-select: none; */
        }

        .time-elapsed,
        .fa-fast-forward {
            padding-left: 0.75em;
        }

        /**/
        /*css to style input type="range"*/
        input[type='range'] {
            -webkit-appearance: none;
            background: transparent;
            width: 40%;
            margin: 0 20px;
        }

        input[type='range']:focus {
            outline: none;
        }

        input[type='range']::-webkit-slider-runnable-track {
            width: 100%;
            height: 5px;
            cursor: pointer;
            box-shadow: inset 1px 1px 1px rgba(0, 0, 0, 0), 0 0 1px rgba(13, 13, 13, 0);
            background: rgba(255, 255, 255, 0.8);
            border-radius: 50px;
            border: 0.2px solid rgba(1, 1, 1, 0);
        }

        input[type='range']::-webkit-slider-thumb {
            height: 0.75em;
            width: 1em;
            border-radius: 0.25em;
            background: dodgerblue;
            cursor: pointer;
            -webkit-appearance: none;
            margin-top: -4px;
            box-shadow: 0 0 2px rgb(15, 14, 80);
        }

        input[type='range']::-moz-range-track {
            /*?*/
            width: 100%;
            height: 8.4px;
            cursor: pointer;
            box-shadow: 1px 1px 1px rgba(0, 0, 0, 0), 0 0 1px rgba(13, 13, 13, 0);
            background: #ffffff;
            border-radius: 1.3px;
            border: 0.2px solid rgba(1, 1, 1, 0);
        }

        input[type='range']::-moz-range-thumb {
            /*?*/
            box-shadow: 0 0 0 rgba(0, 0, 0, 0), 0 0 0 rgba(13, 13, 13, 0);
            height: 12px;
            width: 17px;
            border-radius: 50px;
            /* background: #ffc600; */
            background: blue;
            cursor: pointer;
        }

        @media (max-width: 827px) {
            .fa {
                color: white;
                font-size: 0.9rem;
            }

            button+button {
                margin-left: 0;
            }

            .time {
                padding-left: 0;
                margin-right: 0.5em;
            }

            .time-elapsed,
            .fa-fast-forward {
                padding-left: 0.75em;
            }

            .player {
                width: 80%;
            }
        }

        @media (max-width: 600px) {
            .player {
                width: 95%;
            }
        }
    </style>

    <section class="youtubeSec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="InnerBannerContent">
                        <h1>Enjoy</h1>
                        <div class="AboutVector MoviesVector">
                            <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/uploads/pages/aboutvector_1690931670.png"
                                class="img-fluid" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="popular popular-1">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="video-box">
                        <div class="player" id="player">
                                <video class="player_video viewer"
                                    src=""></video>
                            <div class="player_controls">
                                <div class="progress-range" title="Jump-to">
                                    <div class="progress-bar"></div>
                                </div>
                                <div class="left-controls">
                                    <button class="player_button toggle" title='Toggle Play'><i class="fa fa-play"
                                            title="Play" id="play-btn"></i></button>
                                    <button class="player_button stop" title='Start over'><i class="fa fa-stop"
                                            title="Play" id="stop-btn"></i></button>
                                    <button class="player_button speaker"><i id="speaker_icon" class="fa fa-volume-up"
                                            aria-hidden="true"></i></button>
                                    <input type="range" name="volume" class="player_slider" min="0" max="1"
                                        step="0.05" value="1"></input>
                                </div>
                                <div class="right-controls">
                                    <button data-skip="-10" class="player_button"><i class="fa fa-fast-backward"
                                            aria-hidden="true"></i></button>
                                    <button data-skip="10" class="player_button"><i class="fa fa-fast-forward"
                                            aria-hidden="true"></i></button>
                                    <div class="time">
                                        <span class="time-elapsed">00:00 / </span>
                                        <span class="time-duration">2:38</span>
                                    </div>
                                    <button class="player_button screenSize"><i id="screenSize_icon" class="fa fa-expand"
                                            aria-hidden="true"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @php
        $dataName = request('dataName');
        //dd($dataName);
        $sqvideos = DB::table('creator_sq_videos')->get();
    @endphp
    <section class="youtubeSec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="InnerBannerContent" style="padding-top: 0px;">
                        <h1>Popular videos</h1>
                        <hr class="bg-danger" style="height: 1px;">
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid" style="padding: 10px 50px;">
            <div class="row">
                @foreach ($sqvideos as $item)
                    <div class="col-lg-4">
                        <a href="{{ route('get.video.player', ['id' => $item->id, 'dataName' => 'sqr_video']) }}">
                            <div class="video-wrapper">
                                <div class="MainYoutube">
                                    <!--<div class="iconbar">-->
                                    <!--    <a href="#">-->
                                    <!--        <img src="{{ asset('uploads/square-thumbnails/', $item->video_thumbnail) }}" alt="">-->
                                    <!--    </a>-->
                                    <!--</div>-->
                                    <video title="Dummy Video" class="videoClick" width="500" height="281" controls>
                                        <source src="{{ asset('uploads/square-videos/' . $item->video_file) }}"
                                            type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
@section('css')
    <style>

    </style>
@endsection

@section('js')
    <script src="/Users/CMurphy/Desktop/JavaScript30-Challenge/Custom HTML5 Video Player/Custom HTML5 Video Player.js">
    </script>
    <script type="text/javascript">
    </script>
@endsection
