@extends('admin.layouts.layout')

@section('title', 'Admin | Categories')

@section('main-content')

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="page-header">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Blog Categories</li>
                    </ol>
                </nav>
            </div>
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">Blog Categories</h4>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-info mr-2" data-toggle="modal"
                                        data-target="#addCat">Add Category</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 grid-margin stretch-card">
                    <div class="card" style="background: #73798b;">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-dark">
                                    <thead class="bg-dark">
                                        <tr>
                                            <th> # </th>
                                            <th> Category </th>
                                            <th> Slug </th>
                                            <th> Status </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($blogCats as $cat)
                                            <tr>
                                                <td> {{ $i++ }} </td>
                                                <td> {{ $cat->cat_name }} </td>
                                                <td> {{ $cat->cat_slug }} </td>
                                                <td>
                                                    <div
                                                        style="width: 50px; padding: 10px; display: flex; align-items: center; justify-content: center; background: currentColor; font-size: 15px; cursor: pointer;">
                                                        <i class="fa fa-trash text-danger"></i>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addCat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-x text-white"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.blogs-cat.post') }}" method="post" class="forms-sample">
                        @csrf
                        <div class="form-group">
                            <label for="catTitle">Category</label>
                            <input type="text" name="cat_name" class="form-control" id="catTitle"
                                placeholder="Category name...">
                        </div>
                        <div class="form-group">
                            <label for="slug">Slug</label>
                            <input type="text" name="cat_slug" class="form-control" id="slug"
                                placeholder="Category slug...">
                        </div>
                        <hr class="text-white">
                        <div class="d-flex justify-content-between">
                            <div>
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                            <div>
                                <button type="submit" class="btn btn-success mr-2">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function() {
            $('#catTitle').on("change keyup paste click", function() {
                var text = $(this).val();
                text = text.toLowerCase();
                text = text.replace(/[^a-zA-Z0-9]+/g, '-');
                $('#slug').val(text);
            });
        });
    </script>

@endsection
