@extends('layouts.main')
@section('content')
<!-- Include Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- Include Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
    // Display success message
    toastr.success('{{ session("success") }}');

    // Display error message
    toastr.error('{{ session("error") }}');

    // Display warning message
    toastr.warning('{{ session("warning") }}');

    // Display info message
    toastr.info('{{ session("info") }}');
</script>

<!-- ============================================================== -->
<!-- BODY START HERE -->

<!-- SECTION INNERPAGES BANNER START -->
<section class="Sec-InnerBanner">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<div class="InnerBannerContent">
					<h1>Schedule Stream</h1>
					<div class="AboutVector MoviesVector">
						<img src="{{asset($page->image)}}" class="img-fluid" alt="">
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<style>
    .calendar-table__event .calendar-table__item {
    background-color: #AC0000;
    border-color: #FEFEFE;
    -moz-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    -webkit-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    color: #fff;
}
.events__item {
    background: #fff;
    border-left: 8px solid #AC0000;
    border-radius: 2px;
    -moz-box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.05);
    -webkit-box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.05);
    box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.05);
    padding: 15px 16px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}
.events__tag {
    background: #E0E0E0;
    border: 2px solid #FEFEFE;
    -moz-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    -webkit-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);
    border-radius: 20px;
    color: black;
    font-size: 10px;
    font-weight: 600;
    width: 60px;
    margin-left: 16px;
    padding: 5px 2px;
    text-align: center;
}
</style>


<section class="main-calen-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="main-container-wrapper">
                    <main class="row">
                        <div class="col-md-6">
                            <form id="scheduleForm" action="{{ route('stream.schedule.post') }}" method="post">
                                @csrf
                                <div class="form-group">
                                    <label class="text-dark">Schedule Time</label>
                                    <input type="time" name="schedule_time" class="form-control" />
                                    <input type="hidden" name="schedule_date" class="form-control" id="scheduleDate" />
                                </div>
                                <div class="form-group">
                                    <label class="text-dark">Schedule Time</label>
                                    <div class="calendar-container" id="datepicker">
                                    </div>
                                </div>
                            </form>
                        </div>
                        @php
                            $schedules = DB::table('stream_schedules')->where('user_id',Auth::id())->first();
                        @endphp
                        <div class="col-md-6">
                            <div class="events-container">
                                <div class="d-flex align-item-center justify-content-between">
                                    <div>
                                        <span class="events__title">My Schedules</span>
                                    </div>
                                    @if($schedules)
                                    <div>
                                        <a href="{{route('get.streaming.page',Auth::id())}}"><button class="btn btn-success"><i class="fa fa-video mx-3"></i>Go Live</button></a>
                                    </div>
                                    @endif
                                </div>
                            <ul class="events__list">
                                @foreach($data as $item)
                                    <a href="{{ route('get.streaming.page',$item->id) }}" style="text-decoration:none;">
                                        <li class="events__item">
                                            <div class="events__item--left">
                                                <span class="events__name">Stream Time</span>
                                                <span class="events__date" id="">{{ $item->schedule_date }}</span>
                                            </div>
                                            <span class="events__tag">{{ $item->schedule_time }}</span>
                                        </li>
                                    </a>
                                @endforeach
                            </ul>
                        </div>
                        </div>
                    </main>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- ============================================================== -->


@endsection
@section('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<style>
.ui-datepicker-inline{
    display: block;
    width: 100%;
    height: 430px;
}
.ui-datepicker-calendar thead{
    background: #18395cad;
    color: white;
}
.ui-datepicker-calendar tr td {
    width: 55px;
    height: 55px;
}
.ui-datepicker-calendar tr td .ui-state-default{
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 21px;
    border-radius: 50%;
}
.ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default, .ui-button, html .ui-button.ui-state-disabled:hover, html .ui-button.ui-state-disabled:active {
    border: 1px solid #c5c5c566;
    background: #f6f6f6;
    font-weight: normal;
    color: #454545;
    box-shadow: 5px 5px 5px #c5c5c566;
}
.ui-datepicker .ui-datepicker-header {
    position: relative;
    padding: 6px 0px;
    background: #BD3333;
    color: white;
    font-size: 18px;
}
.ui-datepicker .ui-datepicker-prev {
    left: 2px;
    top: 8px;
}
.ui-datepicker .ui-datepicker-next {
    right: 2px;
    top: 8px;
}
.ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight {
    border: 1px solid #BD3333;
    background: #BD3333;
    color: white;
}
.ui-state-active, .ui-widget-content .ui-state-active, .ui-widget-header .ui-state-active, a.ui-button:active, .ui-button:active, .ui-button.ui-state-active:hover {
    border: 1px solid #BD3333;
    background: #BD3333;
    color: white;
}
</style>
@endsection

@section('js')
  <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
  <script>
    $(function() {
        $("#datepicker").datepicker({
            onSelect: function(dateText, inst) {
                var selectedDate = $.datepicker.formatDate("M d", new Date(dateText));
                $("#selectedDate").text(selectedDate);
                $("#scheduleDate").val(selectedDate);
                $('#scheduleForm').submit();
            }
        }).datepicker("show");

        // Listen for keypress event on datepicker input field
        $(document).on("keypress", function(e) {
            if (e.which == 13) { // Check if Enter key is pressed
                if ($('#datepicker').is(':focus')) { // Check if datepicker is focused
                    e.preventDefault();
                    $('#scheduleForm').submit(); // Submit the form
                }
            }
        });
    });
</script>
  <script>
    // Get the current date and time
    var currentDate = new Date();

    // Options for formatting the date
    var options = { month: 'short', day: 'numeric' };

    // Format the current date as "Month Day" (e.g., "Feb 5")
    var formattedDate = currentDate.toLocaleDateString('en-US', options);

    // Extract time components
    var hours = currentDate.getHours();
    var minutes = currentDate.getMinutes();
    var seconds = currentDate.getSeconds();

    // Format hours, minutes, and seconds with leading zero if needed
    hours = (hours < 10 ? "0" : "") + hours;
    minutes = (minutes < 10 ? "0" : "") + minutes;
    seconds = (seconds < 10 ? "0" : "") + seconds;
    
    // $('.events__date').text(formattedDate);
    // $('.events__tag').text(hours + ":" + minutes);
    // Output the current date and time separately
    console.log("Current Date: " + formattedDate);
    console.log("Current Time: " + hours + ":" + minutes + ":" + seconds);
 </script>
@endsection