@extends('layouts.main')
@section('title', 'Cart')
@section('css')
    <style>
        @import "compass/css3";
        
        .mainSec{
            padding: 200px 0px;
        }
        
        .product-image {
            float: left;
            width: 20%;
        }

        .product-details {
            float: left;
            width: 37%;
        }

        .product-price {
            float: left;
            width: 12%;
        }

        .product-quantity {
            float: left;
            width: 10%;
        }

        .product-removal {
            float: left;
            width: 9%;
        }

        .product-line-price {
            float: left;
            width: 12%;
            text-align: right;
        }

        /* This is used as the traditional .clearfix class */
        .group:before,
        .shopping-cart:before,
        .column-labels:before,
        .product:before,
        .totals-item:before,
        .group:after,
        .shopping-cart:after,
        .column-labels:after,
        .product:after,
        .totals-item:after {
            content: '';
            display: table;
        }

        .group:after,
        .shopping-cart:after,
        .column-labels:after,
        .product:after,
        .totals-item:after {
            clear: both;
        }

        .group,
        .shopping-cart,
        .column-labels,
        .product,
        .totals-item {
            zoom: 1;
        }

        /* Apply clearfix in a few places */
        /* Apply dollar signs */
        .product .product-price:before,
        .product .product-line-price:before,
        .totals-value:before {
            content: '';
        }

        /* Body/Header stuff */
        body {
            padding: 0px 30px 30px 20px;
            font-family: 'HelveticaNeue-Light', 'Helvetica Neue Light', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-weight: 100;
        }

        h1 {
            font-weight: 100;
        }

        label {
            color: #aaa;
        }

        .shopping-cart {
            margin-top: -45px;
        }

        /* Column headers */
        .column-labels label {
            padding-bottom: 15px;
            margin-bottom: 15px;
            border-bottom: 1px solid #eee;
        }

        .column-labels .product-image,
        .column-labels .product-details,
        .column-labels .product-removal {
            text-indent: -9999px;
        }

        /* Product entries */
        .product {
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .product .product-image {
            text-align: center;
        }

        .product .product-image img {
            width: 100px;
        }

        .product .product-details .product-title {
            margin-right: 20px;
            font-family: 'HelveticaNeue-Medium', 'Helvetica Neue Medium';
        }

        .product .product-details .product-description {
            margin: 5px 20px 5px 0;
            line-height: 1.4em;
        }

        .product .product-quantity input {
            width: 40px;
        }

        .product .remove-product {
            border: 0;
            padding: 4px 8px;
            background-color: #c66;
            color: #fff;
            font-family: 'HelveticaNeue-Medium', 'Helvetica Neue Medium';
            font-size: 12px;
            border-radius: 3px;
        }

        .product .remove-product:hover {
            background-color: #a44;
        }

        /* Totals section */
        .totals .totals-item {
            float: right;
            clear: both;
            width: 100%;
            margin-bottom: 10px;
        }

        .totals .totals-item label {
            float: left;
            clear: both;
            width: 79%;
            text-align: right;
        }

        .totals .totals-item .totals-value {
            float: right;
            width: 21%;
            text-align: right;
        }

        .totals .totals-item-total {
            font-family: 'HelveticaNeue-Medium', 'Helvetica Neue Medium';
        }

        .checkout {
            float: right;
            border: 0;
            margin-top: 20px;
            padding: 6px 25px;
            background-color: #6b6;
            color: #fff;
            font-size: 25px;
            border-radius: 3px;
        }

        .checkout:hover {
            background-color: #494;
        }

        /* Make adjustments for tablet */
        @media screen and (max-width: 650px) {
            .shopping-cart {
                margin: 0;
                padding-top: 20px;
                border-top: 1px solid #eee;
            }

            .column-labels {
                display: none;
            }

            .product-image {
                float: right;
                width: auto;
            }

            .product-image img {
                margin: 0 0 10px 10px;
            }

            .product-details {
                float: none;
                margin-bottom: 10px;
                width: auto;
            }

            .product-price {
                clear: both;
                width: 70px;
            }

            .product-quantity {
                width: 100px;
            }

            .product-quantity input {
                margin-left: 20px;
            }

            .product-quantity:before {
                content: 'x';
            }

            .product-removal {
                width: auto;
            }

            .product-line-price {
                float: right;
                width: 70px;
            }
        }

        /* Make more adjustments for phone */
        @media screen and (max-width: 350px) {
            .product-removal {
                float: right;
            }

            .product-line-price {
                float: right;
                clear: left;
                width: auto;
                margin-top: 10px;
            }

            .product .product-line-price:before {
                content: 'Item Total: ';
            }

            .totals .totals-item label {
                width: 60%;
            }

            .totals .totals-item .totals-value {
                width: 40%;
            }
        }
    </style>
@endsection
@section('content')

@php
    $products = DB::table('store_carts')->where('user_id',Auth::id())->where('status','0')->get();
    $totalSum = DB::table('store_products')->where('pro_price');
    //dd($products);
    $totalSum = 0;
@endphp
    <section class="mainSec">
        <div class="container">
        <h1>Shopping Cart</h1>
        <div class="shopping-cart">

            <div class="column-labels">
                <label class="product-image">Image</label>
                <label class="product-details">Product</label>
                <label class="product-price">Price</label>
                <label class="product-quantity">Quantity</label>
                <label class="product-removal">Remove</label>
                <label class="product-line-price">Total</label>
            </div>
            
            @foreach($products as $product)
                @php
                    $item = DB::table('store_products')->where('id',$product->pro_id)->first();
                    $totalSum += $item->pro_price * $product->quantity;
                    //dd($item,$totalSum);
                @endphp
                <div class="product">
                    <div class="product-image">
                        <img src="{{ asset('uploads/products/'. $item->pro_image) }}">
                    </div>
                    <div class="product-details">
                        <div class="product-title">{{ $item->pro_name }}</div>
                        <p class="product-description">{!! $item->pro_description !!}</p>
                    </div>
                    <div class="product-price">{{ $item->pro_price }} Points</div>
                    <div class="product-quantity">
                        <input type="number" value="{{ $product->quantity }}" min="1" data-product-id="{{ $product->id }}">
                    </div>
                    <div class="product-removal">
                        <button class="remove-product" data-id="{{ $product->id }}">
                            Remove
                        </button>
                    </div>
                    <div class="product-line-price">{{ $item->pro_price }} Points</div>
                </div>
            @endforeach
            <div class="totals">
                <div class="totals-item">
                    <label>Subtotal</label>
                    <div class="totals-value" id="cart-subtotal">{{ $totalSum }}</div>
                </div>
                <div class="totals-item">
                    <label>Tax (5%)</label>
                    <div class="totals-value" id="cart-tax">3.60</div>
                </div>
                <div class="totals-item totals-item-total">
                    <label>Grand Total</label>
                    <div class="totals-value" id="cart-total">{{ $totalSum }}</div>
                </div>
            </div>

            <a href="{{ route('new.checkout', $totalSum) }}">
                <button class="checkout" {{ $totalSum == 0 ? 'disabled' : '' }}>Checkout</button>
            </a>
        </div>
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Add an event listener for input changes
        document.querySelectorAll('.product-quantity input').forEach(function (input) {
            input.addEventListener('change', function () {
                const productId = this.dataset.productId;
                const quantity = this.value;

                // Make an AJAX request to update the quantity
                const xhr = new XMLHttpRequest();
                xhr.open('POST', '/cart-update', true);
                xhr.setRequestHeader('Content-Type', 'application/json');

                xhr.onreadystatechange = function () {
                    if (xhr.readyState === XMLHttpRequest.DONE) {
                        if (xhr.status === 200) {
                            // Handle the response if needed
                            console.log(JSON.parse(xhr.responseText));
                        } else {
                            // Handle errors
                            console.error('Error updating quantity:', xhr.status, xhr.statusText);
                        }
                    }
                };

                const data = JSON.stringify({ productId, quantity });
                xhr.send(data);
            });
        });
    });
    
    document.addEventListener('DOMContentLoaded', function () {
        // Add an event listener for button clicks
        document.querySelectorAll('.remove-product').forEach(function (button) {
            button.addEventListener('click', function () {
                const productId = this.dataset.id;
    
                // Make an AJAX request to remove the product
                fetch('/cart-remove', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    },
                    body: JSON.stringify({ productId }),
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    // Handle the response if needed
                    console.log(data);
                    // You can update the UI or perform additional actions here
                })
                .catch(error => {
                    // Handle errors
                    console.error('Error removing product:', error);
                });
            });
        });
    });
</script>
@endsection
