@extends('layouts.main')
@section('title', 'Checkout')
@section('content')
<style>
    .mainSec{
        padding: 200px 0px;
    }
</style>
<section class="mainSec">
<div class="container">
    <div class="py-5 text-center">
        <h2>Checkout form</h2>
    </div>
    @php
        $products = DB::table('store_carts')->where('user_id',Auth::id())->where('status','0')->get();
        $totalSum = DB::table('store_products')->where('pro_price');
        //dd($products);
        $totalSum = 0;
        
        $curl = curl_init();
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://countriesnow.space/api/v0.1/countries/states',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'GET',
                        ));
                        $response = curl_exec($curl);
                        curl_close($curl);
                        //dd($response);
                        $data = json_decode($response, true);
    @endphp
    <div class="row">
        <div class="col-md-4 order-md-2 mb-4">
            <h4 class="d-flex justify-content-between align-items-center mb-3">
                <span class="text-muted">Your cart</span>
                <span class="badge badge-secondary badge-pill">{{ $products->count() }}</span>
            </h4>
            <ul class="list-group mb-3">
                @foreach($products as $product)
                     @php
                        $item = DB::table('store_products')->where('id',$product->pro_id)->first();
                        $totalSum += $item->pro_price * $product->quantity;
                        $totalTax = $totalSum * 3.60;
                        //dd($totalSum);
                    @endphp
                    <li class="list-group-item d-flex justify-content-between lh-condensed">
                        <div>
                            <h6 class="my-0 text-dark">{{ $item->pro_name }}</h6>
                            <small class="text-muted">{!! Str::limit($item->pro_description,30) !!}</small>
                        </div>
                        <span class="text-muted">{{ $item->pro_price }} Points</span>
                    </li>
                @endforeach
                
                <li class="list-group-item d-flex justify-content-between">
                    <span class="text-dark">Total</span>
                    <strong class="text-dark">{{ $totalPrice }}</strong>
                </li>
            </ul>
        </div>
        <div class="col-md-8 order-md-1">
            <h4 class="mb-3">Billing address</h4>
            <form action="{{route('checkout.post')}}" method="post" class="needs-validation" novalidate>
                @csrf
                <input type="hidden" class="form-control" name="total_price" id="" placeholder="" value="{{ $totalPrice }}"
                            required readonly>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="firstName">First name</label>
                        <input type="text" class="form-control" name="fname" id="firstName" placeholder="" value=""
                            required>
                        <div class="invalid-feedback">
                            Valid first name is required.
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="lastName">Last name</label>
                        <input type="text" class="form-control" name="lname" id="lastName" placeholder="" value=""
                            required>
                        <div class="invalid-feedback">
                            Valid last name is required.
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="email">Email <span class="text-muted"></span></label>
                    <input type="email" class="form-control" name="email" id="email" placeholder="you@example.com">
                    <div class="invalid-feedback">
                        Please enter a valid email address for shipping updates.
                    </div>
                </div>
                
                <div class="mb-3">
                    <label for="address">Phone</label>
                    <input type="text" class="form-control" name="phone" id="phone" placeholder="1234 *** ***" required>
                    <div class="invalid-feedback">
                        Please enter your contact.
                    </div>
                </div>

                <div class="mb-3">
                    <label for="address">Address</label>
                    <input type="text" class="form-control" name="first_address" id="address" placeholder="1234 Main St" required>
                    <div class="invalid-feedback">
                        Please enter your shipping address.
                    </div>
                </div>

                <div class="mb-3">
                    <label for="address2">Address 2 <span class="text-muted">(Optional)</span></label>
                    <input type="text" class="form-control" name="second_address" id="address2" placeholder="Apartment or suite">
                </div>

                <div class="row">
                    <div class="col-md-5 mb-3">
                        <label for="country">Country</label>
                        <select class="custom-select d-block w-100" name="country" id="country" required>
                            <option value="">Choose...</option>
                            <?php
                                if ($data && isset($data['data']) && is_array($data['data'])) {
                                    foreach ($data['data'] as $state) {
                                        echo '<option>' . $state['name'] . '</option>';
                                    }
                                }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Please select a valid country.
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="state">State</label>
                        <select class="custom-select d-block w-100" name="state" id="state" required>
                            <option value="">Choose...</option>
                            <?php
                                if ($data && isset($data['data']) && is_array($data['data'])) {
                                    foreach ($data['data'] as $state) {
                                        echo '<option>' . $state['name'] . '</option>';
                                    }
                                }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Please provide a valid state.
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="zip">Zip</label>
                        <input type="text" class="form-control" name="zip_code" id="zip" placeholder="" required>
                        <div class="invalid-feedback">
                            Zip code required.
                        </div>
                    </div>
                </div>
                <hr class="mb-4">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="same-address">
                    <label class="custom-control-label" for="same-address">Shipping address is the same as my billing
                        address</label>
                </div>
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="save-info">
                    <label class="custom-control-label" for="save-info">Save this information for next time</label>
                </div>
                <hr class="mb-4">
                <!--<h4 class="mb-3">Payment</h4>-->
                <!--<div class="d-block my-3">-->
                <!--    <div class="custom-control custom-radio">-->
                <!--        <input id="credit" name="paymentMethod" type="radio" class="custom-control-input"-->
                <!--            checked required>-->
                <!--        <label class="custom-control-label" for="credit">Credit card</label>-->
                <!--    </div>-->
                <!--    <div class="custom-control custom-radio">-->
                <!--        <input id="debit" name="paymentMethod" type="radio" class="custom-control-input"-->
                <!--            required>-->
                <!--        <label class="custom-control-label" for="debit">Debit card</label>-->
                <!--    </div>-->
                <!--    <div class="custom-control custom-radio">-->
                <!--        <input id="paypal" name="paymentMethod" type="radio" class="custom-control-input"-->
                <!--            required>-->
                <!--        <label class="custom-control-label" for="paypal">PayPal</label>-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="row">-->
                <!--    <div class="col-md-6 mb-3">-->
                <!--        <label for="cc-name">Name on card</label>-->
                <!--        <input type="text" class="form-control" id="cc-name" placeholder="" required>-->
                <!--        <small class="text-muted">Full name as displayed on card</small>-->
                <!--        <div class="invalid-feedback">-->
                <!--            Name on card is required-->
                <!--        </div>-->
                <!--    </div>-->
                <!--    <div class="col-md-6 mb-3">-->
                <!--        <label for="cc-number">Credit card number</label>-->
                <!--        <input type="text" class="form-control" id="cc-number" placeholder="" required>-->
                <!--        <div class="invalid-feedback">-->
                <!--            Credit card number is required-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="row">-->
                <!--    <div class="col-md-3 mb-3">-->
                <!--        <label for="cc-expiration">Expiration</label>-->
                <!--        <input type="text" class="form-control" id="cc-expiration" placeholder="" required>-->
                <!--        <div class="invalid-feedback">-->
                <!--            Expiration date required-->
                <!--        </div>-->
                <!--    </div>-->
                <!--    <div class="col-md-3 mb-3">-->
                <!--        <label for="cc-cvv">CVV</label>-->
                <!--        <input type="text" class="form-control" id="cc-cvv" placeholder="" required>-->
                <!--        <div class="invalid-feedback">-->
                <!--            Security code required-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                <hr class="mb-4">
                <button class="btn btn-primary btn-lg btn-block" type="submit">Continue</button>
            </form>
        </div>
    </div>
</div>
</section>

@endsection
