@extends('layouts.main')
@section('content')
    <!-- ============================================================== -->
    <!-- BODY START HERE -->
    <!-- ============================================================== -->
    <?php
    
    $categories = DB::table('categories')->get();
    use App\wishlists;
    
    ?>


    <section class="banner inner-banner" style="background-image: url({{ asset('images/banner.png') }});">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <ul>
                        <li>
                            <img src="{{ asset('images/1-star.png') }}" alt="">
                        </li>
                        <li>
                            <div class="banner-content">
                                <div class="section-heading">
                                    <h1 class="red">Store</h1>
                                </div>
                            </div>
                        </li>
                        <li>
                            <img src="{{ asset('images/1-star.png') }}" alt="">
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section class="shop">
        <div class="container">
            <div class="row">

                @foreach ($shops as $shops)
                    <div class="col-lg-3 col-lg-4 col-md-6">
                        <div class="shop-box">
                            <figure>
                                <img src="{{ asset($shops->image) }}" alt="">
                            </figure>
                            <h6>{{ $shops->product_title }}</h6>
                            <div class="stars">
                                <i class="fas fa-star checked"></i>
                                <i class="fas fa-star checked"></i>
                                <i class="fas fa-star checked"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                            <ul>
                                <li>
                                    <h5>${{ $shops->price }}</h5>
                                </li>
                                <li>
                                    <a
                                        href="{{ route('shopDetail', ['id' => $item->id, 'name' => preg_replace('/[^A-Za-z0-9\-]/', '', strtolower(str_replace(' ', '-', $item->product_title)))]) }}}">Add
                                        to cart</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>

@endsection
@section('css')
    <style>
        .filter_sorting ul.list-group {
            margin-right: 25px !important;
            margin-top: 15px;
        }

    </style>
@endsection
@section('js')
    <script type="text/javascript">

    </script>
@endsection
