@extends('layouts.main')

@section('content')

<!-- Include Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- Include Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
    // Display success message
    toastr.success('{{ session("success") }}');

    // Display error message
    toastr.error('{{ session("error") }}');

    // Display warning message
    toastr.warning('{{ session("warning") }}');

    // Display info message
    toastr.info('{{ session("info") }}');
</script>
    
    <style>
    .MoviesVector {
    /* left: 7%; */
    /* top: 61%; */
    right: 0;
    width: 50%;
}
</style>
    
    <!--spot light form-->
    <section class="youtubeSec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="InnerBannerContent">
                        <h1>Spot Light Application</h1>
                        <div class="AboutVector MoviesVector">
                            <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/images/heading-bg.png"
                                class="img-fluid" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <p style="line-height: 2; font-size: 20px;">
                        Livestream Square works hard towards bringing your content to appear on Spotlight Square.
                        Our team will place your work on the trending page for 1 to 3 months. We also offer in app promotion throughout the website and application,
                        to include advertisement on all Livestream Square social media’s through our reliable promotion team. Up and coming prior to live, series or film going to public.
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 mx-auto">
                    <div class="card p-4" style="background: #0d0d0e;">
                        <form action="{{ route('spot.light.post') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="filmName">Name of Series or Film</label>
                                <input type="text" class="form-control" id="filmName" name="filmName" placeholder="Enter the name of your series or film" required>
                            </div>
                            <div class="form-group">
                                <label for="filmType">Type of Film Content</label>
                                <input type="text" class="form-control" id="filmType" name="filmType" placeholder="Enter the type of film content" required>
                            </div>
                            <div class="form-group">
                                <label for="filmSummary">Film Summary</label>
                                <textarea class="form-control" id="filmSummary" name="filmSummary" rows="4" placeholder="Enter a brief film summary" required></textarea>
                            </div>
                            <div class="form-group">
                                <label for="filmRating">Film Rating</label>
                                <select class="form-control" id="filmRating" name="filmRating">
                                    <option>G</option>
                                    <option>PG</option>
                                    <option>PG-13</option>
                                    <option>NC17</option>
                                    <option>R</option>
                                </select>
                            </div>
                            <!--<div class="form-group">-->
                            <!--    <label for="squareID">Square ID</label>-->
                            <!--    <input type="text" class="form-control" id="squareID" name="squareID" placeholder="Enter your Square ID" required>-->
                            <!--</div>-->
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" required>
                            </div>
                            <div class="form-group">
                                <label for="firstEpisodeUpload">Upload First Episode Below</label>
                                <input type="file" class="form-control-file" id="firstEpisodeUpload" name="firstEpisodeUpload" style="padding: 5px; border: 1px solid grey;">
                            </div>
                            <div class="form-group">
                                <label for="filmTrailerUpload">Upload For Film Trailer Below</label>
                                <input type="file" class="form-control-file" id="filmTrailerUpload" name="filmTrailerUpload" style="padding: 5px; border: 1px solid grey;">
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn w-25" style="background: #A60000; color: white;">Submit</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection
@section('css')
    <style>

    </style>
@endsection

@section('js')
@endsection