@extends('layouts.main')
@section('content')

    <section class="youtubeSec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="InnerBannerContent">
                        <h1>Enjoy Stream</h1>
                        <div class="AboutVector MoviesVector">
                            <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/uploads/pages/aboutvector_1690931670.png"
                                class="img-fluid" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="popular popular-1">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-7 col-md-7">
                    <div class="row card video-box liveStream">
                        <div class="col-md-12">
                        </div>
                        <style>
                            .topProfile{
                                width: 430px;
                                height: 90px;
                                background: black;
                                position: absolute;
                                z-index: 100;
                                border-radius: 20px;
                                left: 22%;
                                top: 2%;
                                padding-left: 25px;
                            }
                            .topBotBar{
                                width: 430px;
                                height: 90px;
                                background: black;
                                position: absolute;
                                z-index: 100;
                                border-radius: 20px;
                                left: 22%;
                                bottom: 3%;
                                padding-left: 25px;
                            }
                            .topProfile img{
                                width: 70px;
                            }
                            .rightBar{
                                width: 100%;
                                height: 730px;
                                padding: 5px;
                            }
                            .uProf{
                                width: 100%;
                                height: 100px;
                                background: black;
                            }
                            .uProf img{
                                width: 100%;
                            }
                            .videoElement{
                                width: 100%;
                                height: 730px;
                                background: grey;
                            }
                        </style>
                        <div class="col-md-12" >
                            <div class="row" style="height: 750px; position: relative;">
                                <a href="javascript:void(0);" style="text-decoration: none;">
                                    <div class="topProfile d-flex align-items-center">
                                        <div class="">
                                            <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                        </div>
                                        <div class="mx-2 w-100">
                                            <h4 class="ml-2 text-white">James Rogers</h4>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div style="font-size: 22px;"><i class="fa fa-play mx-2"></i>56k</div>
                                                <div style="font-size: 22px;"><i class="fa fa-star mx-2"></i>20k</div>
                                                <div style="font-size: 22px;"><i class="fa fa-eye mx-2"></i>30k</div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                                <div class="col-md-2">
                                    <div class="sideBar" style="width: 100%; height: 730px; background: black;">
                                        <div id="#"></div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="videoElement">
                                        <video id="videoElement" autoplay style="width: 100%; height: 100%;"></video>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="rightBar bg-danger">
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <div class="uProf d-flex align-items-center justify-content-center mb-2">
                                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="topBotBar d-flex align-items-center">
                                    <div class="col-md-12 mx-auto d-flex align-items-center justify-content-between">
                                        <div>
                                            <button class="btn btn-primary" id="startButton" disabled>Start</button>
                                        </div>
                                        <div>
                                            <button class="btn btn-danger" id="openMic">Mic</button>
                                        </div>
                                        <div>
                                            <button class="btn btn-primary" id="openCam">Camera</button>
                                        </div>
                                        <div>
                                            <button class="btn btn-success" id="stopButton" disabled>Stop</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="col-lg-4 col-md-4">
                    <div class="card video-box userLiveStrm">
                        <div class="card" style="padding: 15px; background: black;">
                            <div class="d-flex align-items-center">
                                <img src="https://stagingweblink.com/custom-backend/live-stream-square/public/storage/uploads/users/tyJct6iBOy.jpeg" alt="User Profile" class="rounded-circle" width="40">
                                <a href="javascript:void(0);" class="ml-2 text-white">
                                    {{ Auth::user()->name }}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('css')
    <style>

    </style>
@endsection

@section('js')
    <script>
        const openCamButton = document.getElementById('openCam');
        const openMicButton = document.getElementById('openMic');
        const startButton = document.getElementById('startButton');
        const stopButton = document.getElementById('stopButton');
        const videoElement = document.getElementById('videoElement');
        let mediaRecorder;
        let recordedChunks = [];
        let micEnabled = true;
        let camEnabled = true;

        openCamButton.addEventListener('click', async () => {
            try {
                const stream = await navigator.mediaDevices.getUserMedia({
                    video: camEnabled,
                    audio: micEnabled,
                });
                videoElement.srcObject = stream;
                openCamButton.disabled = true;
                startButton.disabled = false;
            } catch (error) {
                console.error('Error accessing camera:', error);
            }
        });


        openMicButton.addEventListener('click', async () => {
            micEnabled = !micEnabled;
            openMicButton.textContent = micEnabled ? 'Mic' : 'Mic Off';
            try {
                const stream = await navigator.mediaDevices.getUserMedia({
                    video: camEnabled,
                    audio: micEnabled,
                });
                videoElement.srcObject = stream;
            } catch (error) {
                console.error('Error accessing microphone:', error);
            }
        });

        startButton.addEventListener('click', async () => {
            try {
                // Disable the start button and enable the stop button
                startButton.disabled = true;
                stopButton.disabled = false;

                // Start capturing video from the camera
                const stream = await navigator.mediaDevices.getUserMedia({
                    video: camEnabled,
                    audio: micEnabled,
                });

                videoElement.srcObject = stream;

                // Initialize MediaRecorder to capture video data
                mediaRecorder = new MediaRecorder(stream);

                // Set up event listeners
                mediaRecorder.ondataavailable = handleDataAvailable;
                mediaRecorder.onstop = handleStop;

                // Start recording
                mediaRecorder.start();

                // Function to handle recording stop event
                function handleStop() {
                    const blob = new Blob(recordedChunks, {
                        type: 'video/webm'
                    });
                    const url = URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'Streaming.webm';
                    document.body.appendChild(a);
                    a.click();
                    recordedChunks = [];

                    // Enable the start button and disable the stop button
                    startButton.disabled = false;
                    stopButton.disabled = true;
                }
            } catch (error) {
                console.error('Error accessing camera:', error);
            }
        });

        stopButton.addEventListener('click', () => {
            if (mediaRecorder && mediaRecorder.state !== 'inactive') {
                mediaRecorder.stop();
            }
        });

        function handleDataAvailable(event) {
            if (event.data && event.data.size > 0) {
                recordedChunks.push(event.data);
            }
        }

    </script>
@endsection
