<?php

use Illuminate\Support\Facades\Route;

// use App\Http\Controllers\squarevideo\SquarevideoController

use App\Http\Controllers\VideoPlayerController;

use App\Http\Controllers\Auth\RegisterController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------user
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

if(version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}


//===================== Admin Routes =====================//

Route::group(['middleware' => ['auth', 'roles'],'roles' => 'admin','prefix'=>'admin'], function () {


    Route::get('/','Admin\AdminController@dashboard');

    Route::get('/dashboard','Admin\AdminController@dashboard')->name('admin.dashboard');
    
    Route::get('account/settings','Admin\UsersController@getSettings');
    Route::post('account/settings','Admin\UsersController@saveSettings');

    Route::get('project', function () {
        return view('dashboard.index-project');
    });

    Route::get('analytics', function () {
        return view('admin.dashboard.index-analytics');
    });
    
    //Change Movie Controller
    Route::get('change-popular-status','Admin\\ProductController@changeStatus')->name('changePopularStatus');

    Route::get('logo/edit','Admin\AdminController@logoEdit')->name('admin.logo.edit');
    Route::post('logo/upload','Admin\AdminController@logoUpload')->name('logo_upload');
    
    Route::get('favicon/edit','Admin\AdminController@faviconEdit')->name('admin.favicon.edit');
    
    Route::post('favicon/upload','Admin\AdminController@faviconUpload')->name('favicon_upload');

    Route::get('config/setting', 'Admin\AdminController@configSetting')->name('admin.config.setting');

    Route::get('contact/inquiries','Admin\AdminController@contactSubmissions');
    Route::get('contact/inquiries/{id}','Admin\AdminController@inquiryshow');
    Route::get('newsletter/inquiries','Admin\AdminController@newsletterInquiries');
    
    Route::any('contact/submissions/delete/{id}','Admin\AdminController@contactSubmissionsDelete');
    Route::any('newsletter/inquiries/delete/{id}','Admin\AdminController@newsletterInquiriesDelete'); 
    
    /* Config Setting Form Submit Route */
    Route::post('config/setting','Admin\AdminController@configSettingUpdate')->name('config_settings_update');




//==============================================================//

//==================== Error pages Routes ====================//
    Route::get('403',function (){
        return view('pages.403');
    });

    Route::get('404',function (){
        return view('pages.404');
    });

    Route::get('405',function (){
        return view('pages.405');
    });

    Route::get('500',function (){
        return view('pages.500');
    });
//============================================================//

    #Permission management
    Route::get('permission-management','PermissionController@getIndex');
    Route::get('permission/create','PermissionController@create');
    Route::post('permission/create','PermissionController@save');
    Route::get('permission/delete/{id}','PermissionController@delete');
    Route::get('permission/edit/{id}','PermissionController@edit');
    Route::post('permission/edit/{id}','PermissionController@update');

    #Role management
    Route::get('role-management','Admin\RolesController@index');
    Route::get('role/create','Admin\RolesController@create');
    Route::post('role/create','Admin\RolesController@store');
    Route::get('role/delete/{id}','Admin\RolesController@delete');
    Route::get('role/edit/{id}','Admin\RolesController@edit');
    Route::post('role/edit/{id}','Admin\RolesController@update');

    #CRUD Generator
    Route::get('/crud-generator', ['uses' => 'ProcessController@getGenerator']);
    Route::post('/crud-generator', ['uses' => 'ProcessController@postGenerator']);

    # Activity log
    Route::get('activity-log','LogViewerController@getActivityLog');
    Route::get('activity-log/data', 'LogViewerController@activityLogData')->name('activity-log.data');

    #User Management routes
    Route::get('users','Admin\\UsersController@Index');
    Route::get('user/create','Admin\\UsersController@create');
    Route::post('user/create','Admin\\UsersController@save');
    Route::get('user/edit/{id}','Admin\\UsersController@edit')->name('admin.edit.user');
    Route::post('user/edit/{id}','Admin\\UsersController@update');
    Route::get('user/delete/{id}','Admin\\UsersController@destroy')->name('admin.delete.user');
    Route::get('user/deleted/','Admin\\UsersController@getDeletedUsers');
    Route::get('user/restore/{id}','Admin\\UsersController@restoreUser');
    

    Route::resource('product', 'Admin\\ProductController');
    Route::get('product/{id}/delete', ['as' => 'product.delete', 'uses' => 'Admin\\ProductController@destroy']);
    Route::get('order/list', ['as' => 'order.list', 'uses' => 'Admin\\ProductController@orderList']);
    Route::get('order/detail/{id}', ['as' => 'order.list.detail', 'uses' => 'Admin\\ProductController@orderListDetail']);
    
     //Order Status Change Routes//
    Route::get('status/completed/{id}','Admin\\ProductController@updatestatuscompleted')->name('status.completed');
    Route::get('status/pending/{id}','Admin\\ProductController@updatestatusPending')->name('status.pending');
    

});

// product create
Route::get('product/new-product-create', 'Admin\ShoppingController@createProductPage')->name('new-product-create');
Route::get('product/new-products', 'Admin\ShoppingController@allNewProduct')->name('new-products');
Route::post('product/new-product-create','Admin\ShoppingController@createProductPost')->name('admin.product.create.post');
Route::get('product/edit/{id?}/new-product', 'Admin\ShoppingController@editNewProduct')->name('edit-new-product');
Route::post('product/new-product-update','Admin\ShoppingController@updateProductPost')->name('admin.product.update.post');

Route::get('product/new-product/{id?}/delete', 'Admin\ShoppingController@newProductDelete')->name('new-product-delete');

// partnership data
Route::get('/partnerships-data', 'Admin\ShoppingController@partnershipsData')->name('partnerships-data');
Route::get('/agency-application', 'Admin\ShoppingController@agencyApplication')->name('agency-application');
Route::get('/spot-light/application', 'Admin\ShoppingController@spotLightApplication')->name('spot-light-application');
Route::get('/streaming-schedules', 'Admin\ShoppingController@streaminSchedules')->name('streaming-schedules');


//==============================================================//

//Log Viewer
Route::get('log-viewers', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@index')->name('log-viewers');
Route::get('log-viewers/logs', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@listLogs')->name('log-viewers.logs');
Route::delete('log-viewers/logs/delete', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@delete')->name('log-viewers.logs.delete');
Route::get('log-viewers/logs/{date}', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@show')->name('log-viewers.logs.show');
Route::get('log-viewers/logs/{date}/download', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@download')->name('log-viewers.logs.download');
Route::get('log-viewers/logs/{date}/{level}', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@showByLevel')->name('log-viewers.logs.filter');
Route::get('log-viewers/logs/{date}/{level}/search', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@search')->name('log-viewers.logs.search');
Route::get('log-viewers/logcheck', '\Arcanedev\LogViewer\Http\Controllers\LogViewerController@logCheck')->name('log-viewers.logcheck');


Route::get('auth/{provider}/','Auth\SocialLoginController@redirectToProvider');
Route::get('{provider}/callback','Auth\SocialLoginController@handleProviderCallback');
Route::get('logout','Auth\LoginController@logout');
Auth::routes();



// authentication
Route::get('signup','GuestController@signup')->name('signup');
Route::post('/signup', [RegisterController::class, 'registerPost'])->name('signup.post');

Route::get('signin','GuestController@signin')->name('signin');

// Route::get('/forgot-password', [PasswordController::class, 'forgotPage'])->name('forgot.get');
// Route::post('/forgot-password', [PasswordController::class, 'forgotPost'])->name('forgot.post');

// Route::get('/reset/{token}/password', [PasswordController::class, 'resetPage'])->name('reset.get');
// Route::post('/reset-password', [PasswordController::class, 'resetPost'])->name('reset.post');


//===================== Account Area Routes =====================//

Route::get('account','LoggedInController@account')->name('account');
Route::get('orders','LoggedInController@orders')->name('orders');
Route::get('account-detail','LoggedInController@accountDetail')->name('accountDetail');


Route::post('update/account','LoggedInController@updateAccount')->name('update.account');
Route::post('update/password','LoggedInController@updatePass')->name('update.password');
Route::get('signout', function() {
        Auth::logout();
        
        Session::flash('flash_message', 'You have logged out  Successfully'); 
        Session::flash('alert-class', 'alert-success'); 
        
        return redirect('signin');
});

Route::get('logout','Auth\LoginController@logout');
Auth::routes();

Route::get('account/friends','LoggedInController@friends')->name('friends');
Route::get('account/upload','LoggedInController@upload')->name('upload');
Route::get('account/password','LoggedInController@password')->name('password');

Route::get('/success','OrderController@success')->name('success');

Route::post('update/profile','LoggedInController@update_profile')->name('update_profile');
Route::post('update/uploadPicture','LoggedInController@uploadPicture')->name('uploadPicture');


//===================== Front Routes =====================//
Route::get('/coming-soon','HomeController@cs')->name('coming-soon');


Route::get('/','HomeController@index')->name('home');
Route::get('about','HomeController@about')->name('About');
Route::get('square-videos','HomeController@squareVideo')->name('squareVideo');
Route::get('movies','HomeController@movies')->name('Movies');
Route::get('calender','HomeController@calender')->name('Calender');
Route::get('term-of-use','HomeController@guideline')->name('Guideline');
Route::get('privacy-policy','HomeController@privacyPolicy')->name('privacyPolicy');
Route::get('broadcaster-guidelines','HomeController@broadcaster')->name('broadcaster');
Route::get('uploading-agreement','HomeController@uploadAgree')->name('uploadAgree');
Route::get('upcoming-classes','HomeController@upcoming_classes')->name('upcoming-classes');
Route::get('online-classes/{id?}','HomeController@online_classes')->name('classes');
Route::get('learn-to-play','HomeController@play')->name('play');
// Route::get('store','HomeController@store')->name('store');
Route::get('contact','HomeController@contact')->name('contact');

Route::get('merchandise','MerchandiseController@index')->name('merchandise');
Route::get('merchandise/purchase/{purchaseId}','MerchandiseController@purchase')->name('merchandise.purchase');
Route::get('merchandise/purchase/success/{userWallet}','MerchandiseController@purchaseSuccess')->name('merchandise.purchase.success');
Route::get('merchandise/convert/{id}','MerchandiseController@convertStrips')->name('merchandise.convert.strips');

Route::post('careerSubmit','HomeController@careerSubmit')->name('contactUsSubmit');
Route::post('newsletter-submit','HomeController@newsletterSubmit')->name('newsletterSubmit');
Route::post('update-content','HomeController@updateContent')->name('update-content');

//=================================================================//

Route::get('lang/{lang}', ['as' => 'lang.switch', 'uses' => 'LanguageController@switchLang']);

/*
Route::get('/test', function() {
    App::setlocale('arab');
    dd(App::getlocale());
    if(App::setlocale('arab')) {
        
    }
});
*/
/* Form Validation */


//===================== Shop Routes Below ========================//

Route::get('store','ProductController@shop')->name('shop');
Route::get('store-detail/{id}','ProductController@shopDetail')->name('shopDetail');
Route::get('category-detail/{id}','ProductController@categoryDetail')->name('categoryDetail');

Route::post('/cartAdd', 'ProductController@saveCart')->name('save_cart');
Route::any('/remove-cart/{id}', 'ProductController@removeCart')->name('remove_cart'); 
Route::post('/updateCart', 'ProductController@updateCart')->name('update_cart');
Route::get('/cart', 'ProductController@cart')->name('cart');
Route::get('/payment', 'OrderController@payment')->name('payment');
Route::get('invoice/{id}','LoggedInController@invoice')->name('invoice');
Route::get('/payment', 'OrderController@payment')->name('payment');
Route::get('/checkout', 'OrderController@checkout')->name('checkout');
Route::post('/place-order', 'OrderController@placeOrder')->name('order.place');
Route::post('/new-order', 'OrderController@newOrder')->name('new.place');
Route::post('shipping', 'ProductController@shipping')->name('shipping');


// new cart , checkout
Route::get('/new-store', 'ShoppingController@newStore')->name('new.store');
Route::get('/store/{total?}/checkout', 'ShoppingController@newCheckout')->name('new.checkout');
Route::get('/new-cart', 'ShoppingController@newCart')->name('new.cart');

// post to cart
Route::get('/cart/{id?}/item', 'ShoppingController@newCartPost')->name('item.cart.post');
Route::post('/store-checkout', 'ShoppingController@newCheckoutPost')->name('checkout.post');

// update cart
Route::post('/cart-update', 'ShoppingController@newCartUpdate')->name('new.cart.update');
Route::post('/cart-remove', 'ShoppingController@newCartRemove')->name('new.cart.remove');

/*wishlist*/
Route::get('/wishlist', 'WishlistController@index')->name('customer.wishlist.list');
Route::any('/wishlist/add/{id?}', 'WishlistController@addwishlist')->name('wishlist.add');
Route::any('/wishlist/add/{id?}', 'WishlistController@addwishlist')->name('wishlist.add');
/*wishlist end*/

Route::post('/language-form', 'ProductController@language')->name('language');


//==============================================================//

Route::get('user-ip', 'HomeController@getusersysteminfo');

//===================== New Crud-Generators Routes Will Auto Display Below ========================//
route::get('status/delivered/{id}','admin\\productcontroller@updatestatusdelivered')->name('status.delivered');
route::get('status/cancelled/{id}','admin\\productcontroller@updatestatuscancelled')->name('status.cancelled');

Route::resource('admin/blog', 'Admin\\BlogController');
Route::resource('admin/category', 'Admin\\CategoryController');

Route::resource('admin/banner', 'Admin\\BannerController', ['names' => 'admin.banner']);
Route::get('admin/banner/{id}/delete', ['as' => 'banner.delete', 'uses' => 'Admin\\BannerController@destroy']);
Route::resource('admin/category', 'Admin\\CategoryController');
Route::resource('admin/attributes', 'Admin\\AttributesController');
Route::resource('admin/attributes-value', 'Admin\\AttributesValueController');
Route::post('admin/get-attributes', 'Admin\\AttributesValueController@getdata')->name('get-attributes');
Route::post('admin/pro-img-id-delet', 'Admin\\AttributesValueController@img_delete')->name('pro-img-id-delet');
Route::post('admin/delete-product-variant', 'Admin\\AttributesValueController@deleteProVariant')->name('delete.product.variant');
Route::resource('admin/testimonial', 'Admin\\TestimonialController');
Route::resource('admin/page', 'Admin\\PageController');
Route::resource('about/about', 'Admin, User\\AboutController');
Route::resource('news/news', 'Admin\\NewsController');

Route::resource('traning-videos', 'TraningVideosController');
Route::resource('upcomingclasses', 'UpcomingclassesController');
Route::resource('whatwedo/whatwedo', 'whatwedo\WhatwedoController');

Route::resource('creator/creator', 'creator\CreatorController');
Route::post('creator/creator/create', 'creator\CreatorController@storeCreatorVideo')->name('admin.store.creator.video');
Route::post('creator/creator/update', 'creator\CreatorController@updateCreatorVideo')->name('admin.update.creator.video');

Route::resource('shortfilm/shortfilm', 'shortfilm\ShortfilmController');
Route::post('shortfilm/shortfilm/create', 'shortfilm\ShortfilmController@storeShortVideo')->name('admin.store.short.video');
Route::post('shortfilm/shortfilm/update', 'shortfilm\ShortfilmController@updateShortVideo')->name('admin.update.short.video');



Route::resource('squarevideo/squarevideo', 'squarevideo\SquarevideoController');
Route::post('squarevideo/squarevideo/create', 'squarevideo\SquarevideoController@storeSqVideo')->name('admin.store.sq.video');
Route::post('squarevideo/squarevideo/update', 'squarevideo\SquarevideoController@updateSqVideo')->name('admin.update.sq.video');


// creator acount 
Route::get('/account-details', 'HomeController@userAccountInfo')->name('get.user.account');

// stor sq videos
Route::post('/account/square-video/store', 'CreatorVideoController@storeSqVideo')->name('creator.store.video');
Route::post('/account/square-video/update', 'CreatorVideoController@updateSqVideo')->name('creator.update.video');
Route::get('/account/square/{id}/video/delete', 'CreatorVideoController@destroyVideo')->name('creator.delete.video');

// store series
Route::post('/account/square-series/store', 'CreatorVideoController@storeSqVideoSeries')->name('creator.store.series');
Route::post('/account/square-series/update', 'CreatorVideoController@updateSqVideoSeries')->name('creator.update.series');
Route::get('/account/square/{id}/series/delete', 'CreatorVideoController@destroyVideoSeries')->name('creator.delete.series');

// stor short reels
Route::post('/account/short-video/store', 'CreatorFilmsController@storeShortVideo')->name('creator.store.film');
Route::post('/account/short-video/update', 'CreatorFilmsController@updateShortVideo')->name('creator.update.film');
Route::get('/account/short/{id}/video/delete', 'CreatorFilmsController@destroyVideo')->name('creator.delete.film');

// store short films
Route::post('/account/short-film/store', 'CreatorFilmsController@storeShortFilm')->name('store.short.film');
Route::post('/account/short-film/update', 'CreatorFilmsController@updateShortFilm')->name('update.short.film');
Route::get('/account/short/{id}/film/delete', 'CreatorFilmsController@destroyShortFilm')->name('delete.short.film');

// display video
Route::get('/square/video/{id}/player', 'VideoPlayerController@viewsquareVideo')->name('get.square.video.player');
Route::get('/shortfilm/video/{id}/player', 'VideoPlayerController@viewshortfilmVideo')->name('get.shortfilm.video.player');

// live streaming page
Route::get('/go/{id?}/streaming', 'StreamingController@viewStreamingPage')->name('get.streaming.page');

// scheduling 
Route::get('/stream-schedule', 'StreamingController@streamSchedulePage')->name('stream.schedule.page');
Route::post('/stream-schedule', 'StreamingController@streamSchedulePost')->name('stream.schedule.post');


// partnership forms
Route::get('/partnership-form', 'StreamingController@viewPartnershipPage')->name('get.partnership.page');
Route::get('/agency-application', 'StreamingController@viewagencyApplicationPage')->name('get.agency-application.page');
Route::get('/spot-light-form', 'StreamingController@viewSpotLightForm')->name('get.spot-light.page');

Route::post('/partnership-form', 'StreamingController@storePartnership')->name('partnership.post');
Route::post('/agency-form', 'StreamingController@storeAgencyForm')->name('agency.form.post');
Route::post('/spot-light-post', 'StreamingController@spotLightForm')->name('spot.light.post');



