@extends('layouts.main')

@section('css')



<link rel="stylesheet" href="{{asset('css/trip-taken.css')}}">
<link rel="stylesheet" href="{{asset('css/chatbox.css')}}">
<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">-->

<style>
.nav.flex-column {
    background-color: transparent;
    border-radius: 0;
    width: 100%;
    padding: 0;
}    
.date {
    text-decoration: none !important;
}
.trip-right p strong {
    text-decoration: none !important;
}
.Bottom-footer{
    position: relative;
    padding-top: 1rem;
    padding-bottom: 1rem;
    background: #ff7eae;
}
</style>
@endsection

@section('content')

<section class="home-sec1">
    <div class="container-fluid">
        <div class="row">
            <!--Recent Post-->
            @include('account.post')
            <div class="col-md-6">
                    <!--trip taken-->
                <div class="tab-content center-bar" id="myTabContent">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">                    
                                @foreach($my_trip as $key => $item)
                                @php
                                    $image = DB::table('new_trip_image')->where('trip_id',$item->id)->first();
                                @endphp
                                <a class="nav-link {{$key == 0?'active':''}}" style="background-image: url({{ ($item->image != '')?asset($item->image):asset($image->trip_image) }}) !important" id="v-pills-{{$key}}-tab" data-toggle="pill" href="#v-pills-{{$key}}" role="tab" aria-controls="v-pills-{{$key}}" aria-selected="true">
                                    <span class="d-flex justify-content-between main-span">
                                        <span class="main-location">
                                            <h3>{{$item->location}}</h3> 
                                        </span>
                                        <span class="date">{{ date('d-m-Y', strtotime($item->start_date)) }}</span>
                                    </span>
                                </a>
                                @endforeach
                                
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="tab-content" id="v-pills-tabContent">
                                @foreach($my_trip as $key => $value)
                                @php
                                    $image = DB::table('new_trip_image')->where('trip_id',$value->id)->get();
                                @endphp
                                <div class="tab-pane  {{$key == 0?'active':''}}" id="v-pills-{{$key}}" role="tabpanel" aria-labelledby="v-pills-{{$key}}-tab">
                                    <div class="trip-right trip-right-2">
                                        <h6>{{$value->location}}</h6>
                                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownShare" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fa-solid fa-ellipsis-vertical"></i>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="navbarDropdownShare">
                                          <a class="dropdown-item" href="{{route('tripDetail',['slug'=>$value->slug])}}"><i class="fa-solid fa-asterisk"></i>View Detail</a>
                                        </div>
                                    </div>
                                    @if($value->image !='' || count($image)>0)
                                    <div class="swiper-main">
                                        <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff" class="swiper mySwiper{{$key}} mySwiperMain" >
                                            <div class="swiper-wrapper">
                                                
                                                @if(count($image)>0)
                                                    @foreach($image as $key1 => $item)
                                                        <div class="swiper-slide">
                                                            <img src="{{asset($item->trip_image)}}" />
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="swiper-slide">
                                                        <img src="{{asset($value->image)}}" />
                                                    </div>
                                                @endif
                                                
                                            </div>
                                            <div class="swiper-button-next"></div>
                                            <div class="swiper-button-prev"></div>
                                        </div>
                                        <div thumbsSlider="" class="swiper mySwiperfirst{{$key}} mySwiper">
                                            <div class="swiper-wrapper">
                                                @if(count($image)>0)
                                                    @foreach($image as $key2 => $item)
                                                    <div class="swiper-slide">
                                                        <img src="{{asset($item->trip_image)}}" />
                                                    </div>
                                                    @endforeach
                                                @else
                                                    <div class="swiper-slide">
                                                        <img src="{{asset($value->image)}}" />
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                        <script>
                                            var swiper = new Swiper(".mySwiperfirst{{$key}}", {
                                              spaceBetween: 10,
                                              slidesPerView: 4,
                                              freeMode: true,
                                              watchSlidesProgress: true,
                                            });
                                            var swiper{{$key}} = new Swiper(".mySwiper{{$key}}", {
                                              spaceBetween: 10,
                                              navigation: {
                                                nextEl: '.swiper-button-next',
                                                prevEl: '.swiper-button-prev',
                                              },
                                              thumbs: {
                                                swiper: swiper,
                                              },
                                            });
                                        </script>
                                    </div>
                                    @endif
                                    <div class="trip-right">
                                        @if($value->loca_stars != '')
                                        
                                        <p><strong>Location Rating:</strong>  
                                            <span>
                                                @for($x = 0 ; $x < $value->loca_stars; $x++)
                                                   <i class="fa fa-star" aria-hidden="true"></i>
                                                @endfor
                                            </span>  
                                        </p>
                                        @endif
                                        @if($value->airline != '')
                                        <p><strong>Airline:</strong>  <span>{{ $value->airline }}</span>  </p>
                                        @endif
                                        @if($value->airline_cost != '')
                                        <p><strong>Airline Cost:</strong> <span>${{ $value->airline_cost }}</span> </p>
                                        @endif
                                        @if($value->flight_quantity != '')
                                        <p><strong>Quantity of Flighs:</strong>  <span>{{ $value->flight_quantity }}</span> </p>
                                        @endif
                                        @if($value->ticket_date != '')
                                        <p><strong>Date Tickets were booked:</strong> <span>{{ date('d-m-Y', strtotime($value->ticket_date))  }}</span></p>
                                        @endif
                                        @if($value->airline_rating != '')
                                        
                                        <p><strong>Airline Rating:</strong>  
                                            <span>
                                                @for($x = 0 ; $x < $value->airline_rating; $x++)
                                                   <i class="fa fa-star" aria-hidden="true"></i>
                                                @endfor
                                            </span>  
                                        </p>
                                        @endif
                                        @if($value->accommodation != '')
                                        <p><strong>Accommodation:</strong> <span>{{ $value->accommodation }}</span></p>
                                        @endif
                                        @if($value->accommodation_link != '')
                                        <p><strong>Accommodation Link:</strong> <span>{{ $value->accommodation_link }}</span></p>
                                        @endif
                                        @if($value->acco_other_link != '')
                                        <p><strong>Other Accommodation Link:</strong> <span>{{ $value->acco_other_link }}</span></p>
                                        @endif
                                        @if($value->accommodation_cost != '')
                                        <p><strong>Accommodation Cost:</strong> <span>${{ $value->accommodation_cost }}</span></p>
                                        @endif
                                        @if($value->acco_thoughts_cost != '')
                                        <p><strong>Thoughts on Cost:</strong> <span>{{ $value->acco_thoughts_cost }}</span></p>
                                        @endif
                                        @if($value->accommodation_comment != '')
                                        <p><strong>Comments Related to Accommodation:</strong> <span>{{ $value->accommodation_comment }}</span></p>
                                        @endif
                                        @if($value->accoma_rating != '')
                                        
                                        <p><strong>Accommodation Rating:</strong>  
                                            <span>
                                                @for($x = 0 ; $x < $value->accoma_rating; $x++)
                                                   <i class="fa fa-star" aria-hidden="true"></i>
                                                @endfor
                                            </span>  
                                        </p>
                                        @endif
                                        @if($value->restaurants != '')
                                        <p><strong>Restaurant:</strong> <span>{{ $value->restaurants }}</span></p>
                                        @endif
                                        @if($value->kids_family_friendly != '')
                                        <p><strong>Kids Family Freindly:</strong> <span>{{ $value->kids_family_friendly }}</span></p>
                                        @endif
                                        @if($value->other_restraunts_option != '')
                                        <p><strong>Other Restraunts:</strong> <span> {{ $value->other_restraunts_option }}</span></p>
                                        @endif
                                        @if($value->restraunt_best_thing != '')
                                        <p><strong>Best Thing That Ate their:</strong> <span>{{ $value->restraunt_best_thing }}</span></p>
                                        @endif
                                        @if($value->restranut_comment != '')
                                        <p><strong>Comments Related to Restraunt:</strong> <span>{{ $value->restranut_comment }}</span></p>
                                        @endif
                                        @if($value->restaurants_rating != '')
                                        
                                        <p><strong>Restaurant Rating:</strong>  
                                            <span>
                                                @for($x = 0 ; $x < $value->restaurants_rating; $x++)
                                                   <i class="fa fa-star" aria-hidden="true"></i>
                                                @endfor
                                            </span>  
                                        </p>
                                        @endif
                                        @if($value->rental_car != '')
                                        <p><strong>Rental Car:</strong> <span>{{ $value->rental_car }}</span></p>
                                        @endif
                                        @if($value->car_cost != '')
                                        <p><strong>Rental  Cost:</strong> <span>${{ $value->car_cost }}</span></p>
                                        @endif
                                        @if($value->car_availability != '')
                                        <p><strong>Rental Availability:</strong> <span>{{ $value->car_availability }}</span></p>
                                        @endif
                                        @if($value->car_quality != '')
                                        <p><strong>Quality of Car:</strong> <span>{{ $value->car_quality }}</span></p>
                                        @endif
                                        @if($value->car_checkin != '')
                                        <p><strong>Check-In Date:</strong> <span>{{ $value->car_checkin }}</span></p>
                                        @endif
                                        @if($value->rental_comment != '')
                                        <p><strong>Rental Comment:</strong> <span>{{ $value->rental_comment }}</span></p>
                                        @endif
                                        @if($value->rental_rating != '')
                                        
                                        <p><strong>Rental Rating:</strong>  
                                            <span>
                                                @for($x = 0 ; $x < $value->rental_rating; $x++)
                                                   <i class="fa fa-star" aria-hidden="true"></i>
                                                @endfor
                                            </span>  
                                        </p>
                                        @endif
                                        <p><strong>Excursions:</strong> <span>{{ $value->excursions_car }}</span></p>
                                        <p><strong>Overall Comment:</strong> <span>{{ $value->comments }}</span></p>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            <!--trip taken-->
            </div>
            @include('account.chatbox')
            <!--Online Friends-->
            @include('account.friends')
        </div>
    </div>
</section>



@include('layouts/front.footer')

@endsection
@section('js')

@endsection