<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\inquiry;
use App\schedule;
use App\newsletter;
use App\ContactQuery;
use App\post;
use App\banner;
use App\imagetable;
use DB;
use View;
use Session;
use App\Http\Helpers\UserSystemInfoHelper;
use App\Http\Traits\HelperTrait;
use Auth;
use App\Profile;
use App\Page;
use Image;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\ValidationException; // Import ValidationException

class HomeController extends Controller
{
    use HelperTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
     // use Helper;

    public function __construct()
    {
        //$this->middleware('auth');

        $logo = imagetable::
                     select('img_path')
                     ->where('table_name','=','logo')
                     ->first();

        $favicon = imagetable::
                     select('img_path')
                     ->where('table_name','=','favicon')
                     ->first();

        View()->share('logo',$logo);
        View()->share('favicon',$favicon);

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $page = DB::table('pages')->where('id', 1)->first();
        $section = DB::table('section')->where('page_id',1)->get();
        $blogs = DB::table('blogs')->orderBy('id','desc')->take(3)->get();
        $testimonial = DB::table('testimonials')->get();
       return view('new-index', compact('page','blogs','section','testimonial'));
    }

    public function about(){
        $page = DB::table('pages')->where('id',2)->first();
        $section = DB::table('section')->where('page_id',2)->get();
        return view('about', compact('page','section'));
    }
    public function blogs(){
        if(isset($_GET['search'])){

            $keyword = $_GET['search'];
            $blogs = DB::table('blogs')->where('name','LIKE','%'.$keyword.'%')->paginate(3);
        }else{
            $keyword="";
            $blogs = DB::table('blogs')->paginate(3);
        }
        $page = DB::table('pages')->where('id',3)->first();
        $section = DB::table('section')->where('page_id',3)->get();

        $latestBlog = DB::table('blogs')->orderBy('id','desc')->take(1)->first();
        // dd($blogs);
        return view('blogs', compact('page','section','blogs','latestBlog','keyword'));
    }

    public function contact(){
        $page = DB::table('pages')->where('id',4)->first();
        $section = DB::table('section')->where('page_id',4)->get();
        return view('contact',compact('page','section'));
    }

    public function careerSubmit(Request $request)
    {
        $data = $request->validate([
            'name'        => 'required|string',
            'email'       => 'required|email',
            'phone'       => 'nullable|string',
            'subject'     => 'nullable|string',
            'description' => 'required|string',
        ]);
    
        $name = $request->name;
        $email = $request->email;
    
        try {
            // Send email
            Mail::send('contact-email', ['lead' => $data, 'url' => $request->url], function ($message) use ($email, $name) {
                $message->to('webinfo@stagingweblink.com');
                $message->subject('Contact Query from Tucker Trips');
                $message->from($email, $name);
            });
            
            // dd($data);
            // Save data to database
            ContactQuery::create($data);
    
            return back()->with('message', 'Thank you for contacting us. We will get back to you asap');
        } catch (\Exception $e) {
            return back()->withErrors(['error' => 'Failed to send email. Please try again later.']);
        }
    }



    public function newsletterSubmit(Request $request){

        $is_email = newsletter::where('newsletter_email',$request->newsletter_email)->count();
        if($is_email == 0) {
            $inquiry = new newsletter;
            $inquiry->newsletter_email = $request->newsletter_email;
            $inquiry->save();
            return response()->json(['message'=>'Thank you for contacting us. We will get back to you asap', 'status' => true]);

        }else{
            return response()->json(['message'=>'Email already exists', 'status' => false]);
        }

    }

    public function updateContent(Request $request){
        $id = $request->input('id');
        $keyword = $request->input('keyword');
        $htmlContent = $request->input('htmlContent');
        if($keyword == 'page'){
            $update = DB::table('pages')
                        ->where('id', $id)
                        ->update(array('content' => $htmlContent));

            if($update){
                return response()->json(['message'=>'Content Updated Successfully', 'status' => true]);
            }else{
                return response()->json(['message'=>'Error Occurred', 'status' => false]);
            }
        }else if($keyword == 'section'){
            $update = DB::table('section')
                        ->where('id', $id)
                        ->update(array('value' => $htmlContent));
            if($update){
                return response()->json(['message'=>'Content Updated Successfully', 'status' => true]);
            }else{
                return response()->json(['message'=>'Error Occurred', 'status' => false]);
            }
        }
    }
    
    public function updateProfileStatus(Request $request)
    {
        // dd($request->all());
        // Get the authenticated user
        $user = Auth::user();
        
        // Update the is_profile column value
        $user->update(['is_profile' => '1']);
        // Return the updated user's data as a JSON response
        return response()->json([
            'message' => 'Profile status updated successfully',
            'is_profile' => $user->is_profile
        ]);
    }

    public function searchTrips()
    {
        // Retrieve the location query parameter from the request
        $query = $_GET['query'];
        // Perform the search using the like operator
        $data1 = DB::table('new_trip')->get();
        $data = DB::table('new_trip')->where('location', 'like', '%' . $query . '%')->get();
        // Output the search results
        // dd($location,$data,$data1);
        return view('account.searched-trips',compact('data'));
    }
    
    public function comingSoon()
    {
        // dd($data1);
        return view('coming-soon-wp');
    }

}
