<?php

namespace App\Http\Controllers;
use Hash;
use Illuminate\Http\Request;
use App\inquiry;
use App\newsletter;
use App\Program;
use App\imagetable;
use App\Banner;
use DB;
use View;
use File;
use App\orders_products;
use App\orders;
use App\CopiedTrip;
use App\Post;
use App\Product;
use App\sharePost;
use App\StatusImage;
use App\PostsImage;
use Auth;
use Session;
use App\Http\Traits\HelperTrait;
use Image;
use App\User;
use App\Friends;
use Illuminate\Support\Facades\Validator;


class LoggedInController extends Controller
{
	use HelperTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
	 // use Helper;

    public function __construct()
    {

		// $this->middleware('guest');
        $this->middleware('auth');
        $logo = imagetable::
                     select('img_path')
                     ->where('table_name','=','logo')
                     ->first();

		$favicon = imagetable::
                     select('img_path')
                     ->where('table_name','=','favicon')
                     ->first();

        View()->share('logo',$logo);
		View()->share('favicon',$favicon);
        //View()->share('config',$config);
        
        
    }

	public function orders()
    {

		$orders = orders::where('orders.user_id', Auth::user()->id)
				->orderBy('orders.id', 'desc')
				->get();
		return view('account.orders',['ORDERS'=>$orders]);

	}

	public function account()
    {

		$post = Post::orderBy('id','desc')->get();
		$status = StatusImage::where('user_id','!=',Auth::user()->id)->get();
		$my_trip = DB::table('new_trip')->where('user_id', Auth::user()->id)->where('isFeatured',2)->orderBy('id', 'desc')->get();
	    $future_trip = DB::table('new_trip')->where('user_id', Auth::user()->id)->where('isFeatured',1)->orderBy('id', 'desc')->get();
	    $share_trips_id = sharePost::where('userId', Auth::user()->id)->orderBy('id','desc')->get();
	    $arrayShare = []; 
	    foreach($share_trips_id as $key => $value){
	      array_push($arrayShare,$value->postId);
	    }
	    $share_tripe = Db::table('new_trip')->whereIn('id',$arrayShare)->get();
	    $recent_post = DB::table('posts')->groupBy('user_id')->orderBy('id','desc')->get();
	    
	    $recentchats  = DB::table('message')->where('reciever_id',Auth::user()->id)->where('sender_id','!=','1')->groupBy('sender_id')->take(3)->get();
		return view('account.index',['post'=>$post, 'future_trip' => $future_trip,'status'=>$status,'share_trips'=>$share_trips,'my_trip'=>$my_trip,'share_tripe'=>$share_tripe,'recentchats'=>$recentchats]);

	}
	
	public function searchUser(Request $request){
	    $name = $request->name;
	    if($name != null){
	        $users = User::where('name', 'LIKE', "%".$name."%")->where('id','!=',1)->where('id','!=',Auth::user()->id)->get();
	    }else{
	        $users = User::where('id','!=',1)->where('id','!=',Auth::user()->id)->get();
	    }
	    return response()->json(['status' => true, 'message' => 'Get Search User List', 'data' => $users]);
	}
	
	public function deleteFeed($id = '') 
	{
	   // $pId = $_POST['id'];
        $post = DB::table('posts')->where('id', $id)->first();
        // dd($post,$id);
        if ($post) {
            // Delete comments associated with the post
            DB::table('posts_comment')->where('post_id', $post->id)->delete();
            // Delete images associated with the post
            DB::table('posts_images')->where('post_id', $post->id)->delete();
            // Delete likes associated with the post
            DB::table('post_like')->where('post_id', $post->id)->delete();
            // Finally, delete the post itself
            DB::table('posts')->where('id', $post->id)->delete();
            // Optionally, you can return a response or redirect after deletion
            // return response()->json(['message' => 'Feed deleted successfully']);
            return back()->with('message' , 'Feed deleted successfully');
        } else {
            // Handle the case where the post is not found
            return back()->with('message' , 'Post not found');
            // return response()->json(['error' => 'Post not found'], 404);
        }
    }
    
    public function editFeed(Request $request , $id)
    {
        $post = DB::table('posts')->where('id', $id)->first();
        if ($post) {
            $comments = DB::table('posts_comment')->where('post_id', $post->id)->first();
            $images = DB::table('posts_images')->where('post_id', $post->id)->first();
            $likes = DB::table('post_like')->where('post_id', $post->id)->first();
            return view('account.post-update', compact('post', 'comments', 'images', 'likes'));
        } else {
            return back()->with('message', 'Post not found');
        }
    }
    
    public function updateFeed(Request $request)
    {
        $post = Post::where('id', $request->post_id)->where('user_id', $request->user_id)->first();
        $imgs = DB::table('posts_images')->where('post_id', $request->post_id)->first();
    
        if ($post && $imgs) {
            // dd($request->all(),$post,$imgs);
            $post->content = $request->content;
            
            $path = $request->post_file;
            if (File::exists($path)) {
                File::delete($path);
            }
    
            if ($request->hasFile('post_file')) {
                $file = $request->file('post_file');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $path = $file->move('uploads/posts/', $fileName);
                $imgs->file = $path;
                $imgs->save();
            }
    
            $post->save();
    
            return back()->with('message', 'Post updated successfully!');
        } else {
            return back()->with('message', 'Post not found or no associated image');
        }
    }

	public function tripTaken(){
	    $status = StatusImage::where('user_id','!=',Auth::user()->id)->get();
	    $my_trip = DB::table('new_trip')->where('user_id', Auth::user()->id)->where('isFeatured',2)->orderBy('id', 'desc')->get();
	    $recentchats  = DB::table('message')->where('reciever_id',Auth::user()->id)->where('sender_id','!=','1')->groupBy('sender_id')->take(3)->get();
	    return view('account.triptaken',['my_trip'=>$my_trip,'recentchats'=>$recentchats]);
	}
	
	public function futureTrip(){
	    
	    $future_trip = DB::table('new_trip')->where('user_id', Auth::user()->id)->where('isFeatured',1)->orderBy('id', 'desc')->get();
	    $recentchats  = DB::table('message')->where('reciever_id',Auth::user()->id)->where('sender_id','!=','1')->groupBy('sender_id')->take(3)->get();
	    return view('account.futureTrip',['future_trip'=>$future_trip,'recentchats'=>$recentchats]);
	}
	
	public function shareTrip(){
	    $shareTripId =  DB::table('share_posts')->where('userId','!=',Auth::user()->id)->get();
	    $arrayship = [];
	    foreach($shareTripId as $item){
	        array_push($arrayship,$item->postId);
	    }
	    $share_trip = DB::table('new_trip')->whereIn('id',$arrayship)->get();
	   // dd($shareTrip);
	   
	    $recentchats  = DB::table('message')->where('reciever_id',Auth::user()->id)->where('sender_id','!=','1')->groupBy('sender_id')->take(3)->get();
	    return view('account.sahreTrip',['share_trip'=>$share_trip,'recentchats'=>$recentchats]);
	}
	
	public function tripDetail($slug = '', $id =''){
	    $tripDetail = DB::table('new_trip')->where('slug',$slug)->where('id', $id)->first();
	    $recentchats  = DB::table('message')->where('reciever_id',Auth::user()->id)->where('sender_id','!=','1')->groupBy('sender_id')->take(3)->get();
	    return view('account.trip-detail',['tripDetail'=>$tripDetail,'recentchats'=>$recentchats]);
	}
	
	public function editTrip($id = ''){
	    $tripDetail = DB::table('new_trip')->where('id',$id)->first();
	    
	    return view('account.trip-edit',['tripDetail'=>$tripDetail,'recentchats'=>$recentchats]);
	}
	
	public function updateProfile(){
	    
	    return view('account.profile');
	}

    public function message($id){
        
        $user = User::where('id',$id)->first();
        $recieverMessage = DB::table('message')->where('sender_id',$id)->orderBy('id','ASC')->get();
        $senderMessage  = DB::table('message')->where('sender_id',Auth::user()->id)->orderBy('id','ASC')->get();
        $messages = DB::table('message')->orderBy('id','ASC')->get();
        return view('account.message',['user'=>$user,'recieverMessage'=>$recieverMessage,'senderMessage'=>$senderMessage,'messages'=>$messages]);
    }
    
	public function update_profile(Request $request) {

		$user = DB::table('profiles')->where('id', Auth::user()->id)->first();

		$validateArr = array();
		$messageArr = array();
		$insertArr = array();
		$validateArr = [

			'uname' => 'required',
			'email' => array(),

		 ];

		 if($user->email != $_POST['email']) {
			$validateArr['email'] = 'required|unique:users,email,NULL,id';
		 }

		if(trim($_POST['password']) != "") {

			$validateArr['password'] = 'required|min:6|confirmed';
            $validateArr['password_confirmation'] = 'required|min:6';
		}

		$this->validate($request,$validateArr,$messageArr);

		$insertArr['name'] = $_POST['uname'];
		$insertArr['email'] = $_POST['email'];

		if(trim($_POST['password']) != "") {
				$insertArr['password'] = Hash::make($_POST['password']);
		}

		DB::table('users')
		->where('id', Auth::user()->id)
		->update(
					$insertArr
				);


		Session::flash('message', 'Your Profile Settings has been changed');
		Session::flash('alert-class', 'alert-success');
		return back();

	}

	public function uploadPicture(Request $request) {
       
		$user = DB::table('profiles')->where('id', Auth::user()->id)->first();

        if ($file = $request->file('profilePhoto')) {
            // $extension = $file->extension()?: 'jpg|png';
            // $destinationPath = public_path() . '/storage/uploads/users/';
            // $safeName = str_random(10) . '.' . $extension;
           
            // $file->move($destinationPath, $safeName);
            // //delete old pic if exists
            // if (File::exists($destinationPath . $user->pic)) {
            //     File::delete($destinationPath . $user->pic);
            // }
            // //save new file path into db
            // $profile->pic = $safeName;
            
            $user = DB::table('profiles')->where('id', Auth::user()->id)->first();
            $image_path = public_path($user->pic); 
            
            if(File::exists($image_path)) {
                File::delete($image_path);
            }

            $file = $request->file('profilePhoto');
            $fileNameExt = $request->file('profilePhoto')->getClientOriginalName();
            $fileNameForm = str_replace(' ', '_', $fileNameExt);
            $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
            $fileExt = $request->file('profilePhoto')->getClientOriginalExtension();
            $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
            $pathToStore = public_path('/storage/uploads/users/');
            Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);

            $insertArr['pic'] = '/storage/uploads/users/'.$fileNameToStore;  
            
            
            
        }   
            $insertArrFirst['name'] = $request->fname;
            $insertArrFirst['email'] = $request->email;
    		DB::table('users')
    		->where('id', Auth::user()->id)
    		->update(
    					$insertArrFirst
    				);
    		
// 			$insertArr['pic'] = $destinationPath.$safeName;
            $insertArr['bio'] = $request->personalDetail;
            $insertArr['lname'] = $request->lname;
            $insertArr['country'] = $request->country;
            $insertArr['qualification'] = $request->qualification;
            $insertArr['facebook'] = $request->facebook;
            $insertArr['twitter'] = $request->twitter;
            $insertArr['instagram'] = $request->instagram;
            
            
			DB::table('profiles')
			->where('user_id', Auth::user()->id)
			->update(
						$insertArr
					);

		Session::flash('message', 'Your Profile has been changed');
		Session::flash('alert-class', 'alert-success');
		return back();

	}

    public function updateAccount(Request $request) 
    {
        $userData = [
            'name' => $request->input('name'),
            'email' => $request->input('email'),
        ];
    
        $profileData = [
            'lname' => $request->input('lname'),
            'bio' => $request->input('bio'),
            'pic' => $request->input('profile'),
            'localisation' => $request->input('localisation'),
            'dob' => $request->input('dob'),
            'gender' => $request->input('gender'),
            'country' => $request->input('country'),
            'state' => $request->input('state'),
            'city' => $request->input('city'),
            'address' => $request->input('address'),
            'postal' => $request->input('postal'),
            'qualification' => $request->input('qualification'),
            'facebook' => $request->input('facebook'),
            'twitter' => $request->input('twitter'),
            'instagram' => $request->input('instagram'),
        ];
        
        $uData = DB::table('profiles')->where('user_id',Auth::id())->first();
        
        // dd($userData,$profileData,$uData);
    
        $password = $request->input('password');
        $confirmPassword = $request->input('password_confirmation');
    
        if ($password != '' && $password == $confirmPassword) {
            $userData['password'] = Hash::make($password);
        } elseif ($password != '' && $password != $confirmPassword) {
            // Passwords do not match
            return back()->with('flash_message', 'Password do not match')->with('alert-class', 'alert-danger');
        }
    
        // Update user data in 'users' table
        DB::table('users')
            ->where('id', Auth::user()->id)
            ->update($userData);
    
        // Update profile data in 'profiles' table
        DB::table('profiles')
            ->where('user_id', Auth::user()->id)
            ->update($profileData);
    
        // Flash message for success
        Session::flash('message', 'Your account has been updated successfully');
        Session::flash('alert-class', 'alert-success');
    
        return back();
    }

	public function accountDetail()
    {
		$orders = orders::where('orders.user_id', Auth::user()->id)
						->orderBy('orders.id', 'desc')
						->get();

		return view('account.account',['ORDERS'=>$orders]);

	}
	
	public function newaccountDetail()
    {
		return view('account.new-account');
	}

	public function invoice($id)
    {
		$order_id = $id;
		$order = orders::where('id',$order_id)->first();
		$order_products = orders_products::where('orders_id',$order_id)->get();

		return view('account.invoice')->with('title','Invoice #'.$order_id)->with(compact('order','order_products'))->with('order_id',$order_id);;
	}

	public function friends()
    {   
		return view('account.friends',compact(['friendsData'=>$friendsData]));

	}
	
	public function chatUsers()
    {   
		return view('account.users');
	}
    
	public function upload()
    {
		return view('account.upload');

	}

	public function password()
    {
		return view('account.password');

	}
	
	public function updateStatusImage(Request $request){
	    $validation = Validator::make($request->all(), [
	        'select_file' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
	   ]);
	   
	   if($validation->passes()){
	       $image = $request->file('select_file');
	       $new_name = rand() . '.' . $image->getClientOriginalExtension();
	       $image->move(public_path('status'), $new_name);
	       $image_path = "status/".$new_name;
	       DB::table('status_image')->insert(
                ['image' => $image_path, 'user_id' => Auth::user()->id]
            );
            $imageStatus = asset($image_path);
	       return response()->json([
	           'status' => true,
	           'imageStatus'=>$imageStatus,
	           'message'   => 'Image Upload Successfully'
	       ]);
	   }else{
	       return response()->json([
	           'status' => false,
	           'message'   => $validation->errors()->all()
	       ]);
	   }
    }
    
    public function findFreind(Request $request){
        $name = $request->dataName;
        
        $user = User::with('profile')->where('name', 'like', '%' .$name . '%')->get();
        
        return response()->json([
            'status' => true,
            'user'   => $user
        ]);
        
    }
    
    public function getUserImage(Request $request){
        
        $userImage = 
        $img = $userImage->pic;
        
        return response()->json([
            'status' => true,
            'user'   => $img
        ]);
                
        
    }
    
    public function searchFriends(Request $request)
    {
        $query = $request->input('query');
    
        // Search for users by name
        $users = DB::table('users')->where('name', 'like', '%' . $query . '%')->get();
    
        // Retrieve profiles for each user
        $userProfiles = [];
        foreach ($users as $user) {
            $profile = DB::table('profiles')->where('user_id', $user->id)->first();
            $userProfiles[] = [
                'user' => $user,
                'profile' => $profile,
            ];
        }
    
        return response()->json($userProfiles);
    }
    
    public function startCaht(Request $request){
        // dd($request->user_id);
        $user = User::with('profile')->where('id', $request->user_id)->first();
        $userChat = DB::table('message')->where('sender_id',Auth::user()->id)->where('reciever_id',$request->user_id)->orderBy('id','ASC')->get();
        $otherUserChat = DB::table('message')->where('sender_id',$request->user_id)->where('reciever_id',Auth::user()->id)->orderBy('id','ASC')->get();
        $messages = DB::table('message')->orderBy('id','desc')->get();
        $AuthUserImage = DB::table('profiles')->where('user_id',Auth::user()->id)->first();
        return response()->json([
            'status' => true,
            'user'   => $user,
            'userChat'=>$userChat,
            'otherUserChat'=>$otherUserChat,
            'messages'=>$messages,
            'AuthUserImage'=>$AuthUserImage->pic
        ]);
    }
    
    public function messageMiniPost (Request $request){
        $this->validate($request, ['comment' => 'required']);
        $reciever_id = $request->reciverId;
        $senderId = Auth::user()->id;
        $message = $request->comment;
        DB::table('message')->insert(
            ['message' => $message, 'sender_id' => Auth::user()->id, 'reciever_id' => $reciever_id]
            
        );
        
        return response()->json(['message'=>$message,'user'=>Auth::user()->profile ,'status' => true]);
    }
    
    public function updateTripPost(Request $request){
        // dd($request->all());
        $tripUpdate = DB::table('new_trip')->where('id',$request->trip_id)->update(
            [
                'slug'=>preg_replace('/[^a-z0-9-]+/', '-', strtolower(trim( $request->input('new-location')))),
                'user_id' => Auth::user()->id,
                'location' => $request->input('new-location'),
                'start_date' => $request->input('new-start-date'),
                'end_date' => $request->input('new-end-date'),
                'date_comment'=>$request->input('date-comment'),
                'airline' => $request->input('new-airline'),
                'airline_cost' => $request->input('airline-cost'),
                'flight_quantity' => $request->input('flight-quantity'),
                'ticket_date' => $request->input('ticket-booked'),
                'accommodation' => $request->input('new-accommodation'),
                'accommodation_link' => $request->input('accoma_link'),
                'acco_other_link' => $request->input('accoma_another_link'),
                'accommodation_cost' => $request->input('accoma_cost'),
                'acco_thoughts_cost' => $request->input('accoma_thoughts_cost'),
                'accommodation_comment' => $request->input('accommodation_comment'),
                'restaurants' => $request->input('new-restaurants'),
                'kids_family_friendly' => $request->input('friendly-restaurants'),
                'other_restraunts_option' => $request->input('other-restaurants'),
                'restraunt_best_thing' => $request->input('best-thing-restaurants'),
                'restranut_comment' => $request->input('comments-restaurants'),
                'rental_car' => $request->input('new-rental-car'),
                'car_cost' => $request->input('rental-cost'),
                'car_availability' => $request->input('rental-avaibility'),
                'car_quality' => $request->input('rental-quality'),
                'car_checkin' => $request->input('rental-check-date'),
                'rental_comment' => $request->input('rental-comment'),
                'excursions_car' => $request->input('new-excursions-car'),
                'comments' => $request->input('new-comments'),
                'isFeatured'=>$request->input('isFeatured'),
                'airline_rating'=>$request->input('air-stars'),
                'accoma_rating'=>$request->input('acco-stars'),
                'restaurants_rating'=>$request->input('rest-stars'),
                'rental_rating'=>$request->input('rent-stars'),
                'loca_stars'=>$request->input('loca-stars')
            ]
        );
        
        foreach($request->file('new-images') as $key => $value)
        {   
            // dd($value);
            $file = $value;
            $fileNameExt = $file->getClientOriginalName();
            $fileNameForm = str_replace(' ', '_', $fileNameExt);
            $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
            $fileExt = $file->getClientOriginalExtension();
            $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
            $pathToStore = public_path('/storage/uploads/trip/');
            Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);
            $pic = '/storage/uploads/trip/'.$fileNameToStore;
            
            DB::table('new_trip_image')->insert(
                [ 
                    'trip_id'=> $request->trip_id,
                    'trip_image'=>$pic
                ]
            );
        }
        
        return back()->with('success','Trip Successfully Updated');
        // return response()->json([
        //     'status' => true,
        //     'message'   => 'Trip Successfully Updated'
        // ]);
    }
    
    public function newTripPost(Request $request){
        
        if($request->ctrId){
            // dd('Copied trip',$request->all());
            $pic = '';
            $trip = DB::table('new_trip')->insert(
                [   'slug'=>preg_replace('/[^a-z0-9-]+/', '-', strtolower(trim( $request->input('new-location')))),
                    'user_id' => Auth::user()->id,
                    'location' => $request->input('new-location'),
                    'start_date' => $request->input('new-end-date'),
                    'end_date' => $request->input('new-end-date'),
                    'date_comment'=>$request->input('date-comment'),
                    'airline' => $request->input('new-airline'),
                    'airline_cost' => $request->input('airline-cost'),
                    'flight_quantity' => $request->input('flight-quantity'),
                    'ticket_date' => $request->input('ticket-booked'),
                    'accommodation' => $request->input('new-accommodation'),
                    'accommodation_link' => $request->input('accoma_link'),
                    'acco_other_link' => $request->input('accoma_another_link'),
                    'accommodation_cost' => $request->input('accoma_cost'),
                    'acco_thoughts_cost' => $request->input('accoma_thoughts_cost'),
                    'accommodation_comment' => $request->input('accommodation_comment'),
                    'restaurants' => $request->input('new-restaurants'),
                    'kids_family_friendly' => $request->input('friendly-restaurants'),
                    'other_restraunts_option' => $request->input('other-restaurants'),
                    'restraunt_best_thing' => $request->input('best-thing-restaurants'),
                    'restranut_comment' => $request->input('comments-restaurants'),
                    'rental_car' => $request->input('new-rental-car'),
                    'car_cost' => $request->input('rental-cost'),
                    'car_availability' => $request->input('rental-avaibility'),
                    'car_quality' => $request->input('rental-quality'),
                    'car_checkin' => $request->input('rental-check-date'),
                    'rental_comment' => $request->input('rental-comment'),
                    'excursions_car' => $request->input('new-excursions-car'),
                    'comments' => $request->input('new-comments'),
                    'isFeatured'=>$request->input('isFeatured'),
                    'airline_rating'=>$request->input('air-stars'),
                    'accoma_rating'=>$request->input('acco-stars'),
                    'restaurants_rating'=>$request->input('rest-stars'),
                    'rental_rating'=>$request->input('rent-stars'),
                    'loca_stars'=>$request->input('loca-stars')
                ]
            );
            $trip_id = DB::table('new_trip')->where('user_id',Auth::user()->id)->orderBy('id','desc')->first();
            // dump($trip_id->id);
            foreach($request->file('new-images') as $key => $value)
            {   
                // dd($value);
                $file = $value;
                $fileNameExt = $file->getClientOriginalName();
                $fileNameForm = str_replace(' ', '_', $fileNameExt);
                $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
                $fileExt = $file->getClientOriginalExtension();
                $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
                $pathToStore = public_path('/storage/uploads/trip/');
                Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);
                $pic = '/storage/uploads/trip/'.$fileNameToStore;
                
                DB::table('new_trip_image')->insert(
                    [ 
                        'trip_id'=>$trip_id->id,
                        'trip_image'=>$pic
                    ]
                );
            }
            if ($trip) {
                $trp = CopiedTrip::where('id', $request->ctrId)
                    ->where('user_id', Auth::id())
                    ->first();
            
                if ($trp) {
                    $trp->delete();
                }
            }
            return redirect()->route('account')->with('success', 'New trip Submitted Successfully');
            // return response()->json([
            //     'status' => true,
            //     'message'   => 'New trip Submitted Successfully'
            // ]);
        }
        // dd('New trip',$request->all());
        $pic = '';
        $trip = DB::table('new_trip')->insert(
            [   'slug'=>preg_replace('/[^a-z0-9-]+/', '-', strtolower(trim( $request->input('new-location')))),
                'user_id' => Auth::user()->id,
                'location' => $request->input('new-location'),
                'start_date' => $request->input('new-end-date'),
                'end_date' => $request->input('new-end-date'),
                'date_comment'=>$request->input('date-comment'),
                'airline' => $request->input('new-airline'),
                'airline_cost' => $request->input('airline-cost'),
                'flight_quantity' => $request->input('flight-quantity'),
                'ticket_date' => $request->input('ticket-booked'),
                'accommodation' => $request->input('new-accommodation'),
                'accommodation_link' => $request->input('accoma_link'),
                'acco_other_link' => $request->input('accoma_another_link'),
                'accommodation_cost' => $request->input('accoma_cost'),
                'acco_thoughts_cost' => $request->input('accoma_thoughts_cost'),
                'accommodation_comment' => $request->input('accommodation_comment'),
                'restaurants' => $request->input('new-restaurants'),
                'kids_family_friendly' => $request->input('friendly-restaurants'),
                'other_restraunts_option' => $request->input('other-restaurants'),
                'restraunt_best_thing' => $request->input('best-thing-restaurants'),
                'restranut_comment' => $request->input('comments-restaurants'),
                'rental_car' => $request->input('new-rental-car'),
                'car_cost' => $request->input('rental-cost'),
                'car_availability' => $request->input('rental-avaibility'),
                'car_quality' => $request->input('rental-quality'),
                'car_checkin' => $request->input('rental-check-date'),
                'rental_comment' => $request->input('rental-comment'),
                'excursions_car' => $request->input('new-excursions-car'),
                'comments' => $request->input('new-comments'),
                'isFeatured'=>$request->input('isFeatured'),
                'airline_rating'=>$request->input('air-stars'),
                'accoma_rating'=>$request->input('acco-stars'),
                'restaurants_rating'=>$request->input('rest-stars'),
                'rental_rating'=>$request->input('rent-stars'),
                'loca_stars'=>$request->input('loca-stars')
            ]
        );
        $trip_id = DB::table('new_trip')->where('user_id',Auth::user()->id)->orderBy('id','desc')->first();
        // dump($trip_id->id);
        foreach($request->file('new-images') as $key => $value)
        {   
            // dd($value);
            $file = $value;
            $fileNameExt = $file->getClientOriginalName();
            $fileNameForm = str_replace(' ', '_', $fileNameExt);
            $fileName = pathinfo($fileNameForm, PATHINFO_FILENAME);
            $fileExt = $file->getClientOriginalExtension();
            $fileNameToStore = $fileName.'_'.time().'.'.$fileExt;
            $pathToStore = public_path('/storage/uploads/trip/');
            Image::make($file)->save($pathToStore . DIRECTORY_SEPARATOR. $fileNameToStore);
            $pic = '/storage/uploads/trip/'.$fileNameToStore;
            
            DB::table('new_trip_image')->insert(
                [ 
                    'trip_id'=>$trip_id->id,
                    'trip_image'=>$pic
                ]
            );
        }
        return response()->json([
            'status' => true,
            'message'   => 'New trip Submitted Successfully'
        ]);
    }
    
    public function newTripPage()
    {
        return view('account.new-trip');
    }
    
    public function tripCopied(Request $request)
    {
        $trip_id = $request->trip_id;
        
        // Check if the trip_id already exists
        $existingCopy = DB::table('copied_trips')
            ->where('user_id', Auth::user()->id)
            ->where('trip_id', $trip_id)
            ->first();
    
        if ($existingCopy) {
            // Trip has already been copied
            return response()->json(['message' => 'Trip already copied.', 'status' => false]);
        }
    
        // Trip not found, proceed with insertion
        $copied_trip_id = DB::table('copied_trips')->insertGetId([
            'user_id' => Auth::user()->id,
            'trip_id' => $trip_id
        ]);
    
        return response()->json(['message' => 'Copied Trip Data Successfully !!!', 'status' => true, 'copied_trip_id' => $copied_trip_id]);
    }

    public function copiedTripPage($id)
    {
        // Fetch copied trip details based on the copied_trip_id
        $copiedTrip = DB::table('copied_trips')->where('id', $id)->first();
        
        if (!$copiedTrip) {
            // Handle case where copied trip is not found
            abort(404);
        }
    
        // Fetch original trip details from 'new_trip' table
        $originalTrip = DB::table('new_trip')->where('id', $copiedTrip->trip_id)->first();
        // dd($originalTrip);
        return view('account.copied-trip-form', compact('originalTrip','copiedTrip'));
    }

    
    public function freindPost(Request $request)
    {
        if (!Auth::user()) {
            return response()->json(['success' => false, 'message' => 'Please login or create an account first to participate']);
        }
    
        $friendId = $request->input('friendId');
        $friendship = Friends::where('user_id', Auth::user()->id)
            ->where('friend_id', $friendId)
            ->first();
        if ($friendship) {
            $friendship->delete();
            return response()->json([
                'success' => true,
                'message' => 'Friend removed from friend list',
                'data' => null,
            ]);
        } else {
            $friend = new Friends();
            $friend->user_id = Auth::user()->id;
            $friend->friend_id = $friendId;
            $friend->save();
    
            return response()->json([
                'success' => true,
                'message' => 'Friend added to friend list',
                'data' => $friend,
            ]);
        }
    }

    
    public function deleteTripImage(Request $request){
        
        DB::table('new_trip_image')->where('id',$request->imageId)->delete();
        return response()->json([
            'status' => true,
            'message'   => 'Image Submitted Successfully'
        ]);
    }
    
    public function delteTrip(Request $request){
        DB::table('new_trip')->where('id',$request->postId)->delete();
        DB::table('share_posts')->where('postId',$request->postId)->delete();
        return response()->json([
            'status' => true,
            'message'   => 'Trip Delete Succefully Successfully'
        ]);
    }
    
    public function addFriend(Request $request){
        $user_id = $request->user_id;
        $id = Auth::user()->id;
        $data = DB::table('friends')->where('user_id', $id)->where('friend_id', $user_id)->first();
        $message = '';
        $status = false;
        if($data == null){
            $status = true;
            DB::table('friends')->insert(
                [ 
                    'user_id'=> $id,
                    'friend_id'=> $user_id
                ]
            );
            $message = "Friend Added Successfully";
        }else{
            DB::table('friends')->where('user_id', $id)->where('friend_id', $user_id)->delete();
            $message = "Friend Deleted Successfully";
        }
        return response()->json([
            'status' => $status,
            'message' => $message
        ]);
        
    }

}

