<?php

namespace App\Http\Controllers;

use App\Post;
use Illuminate\Http\Request;
use Image;
use DB;
use Auth;
class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    
    public function likePost(Request $request){
        $post_id = $request->post_id;
        $data = DB::table('post_like')->where('user_id', Auth::user()->id)->where('post_id', $post_id)->first();
        if(count($data) == 0){
            $post_like = 1;
            $inserted_data = DB::table('post_like')->insert(
                ['user_id' => Auth::user()->id, 'post_id' => $post_id, 'post_like' => 1]
            );
        }else{
            $post_data = DB::table('post_like')->where('user_id', Auth::user()->id)->where('post_id', $post_id)->first();
            if($post_data->post_like == 1){
                $post_like = 0;   
                DB::table('post_like')
                ->where('user_id', Auth::user()->id)
                ->where('post_id', $post_id)
                ->update([
                    'post_like' => 0,
                ]);
            }else{
                $post_like = 1;   
                DB::table('post_like')
                ->where('user_id', Auth::user()->id)
                ->where('post_id', $post_id)
                ->update([
                    'post_like' => 1,
                ]);
            }
        }
        return response()->json(['post_like'=> $post_like ,'status' => true]);
    }
    
    public function sharePost(Request $request){
        $post_id = $request->post_id;
        DB::table('share_posts')->insert(
            [ 'userId' => Auth::user()->id, 'postId' => $post_id]
        );
        return response()->json(['message'=>'Post Share Successfully', 'status' => true]);
    }
    
    
    
    public function commentPost(Request $request){
        $post_id = $request->post_id;
        $message = $request->message;
        DB::table('posts_comment')->insert(
            ['message' => $message, 'user_id' => Auth::user()->id, 'post_id' => $post_id]
        );
        return response()->json(['message'=>$message,'user'=>Auth::user()->profile ,'status' => true]);
    }
    
    public function messagePost(Request $request){
         $this->validate($request, ['comment' => 'required']);
        $reciever_id = $request->reciverId;
        $senderId = Auth::user()->id;
        $message = $request->comment;
        DB::table('message')->insert(
            ['message' => $message, 'sender_id' => Auth::user()->id, 'reciever_id' => $reciever_id]
            
        );
        
        return response()->json(['message'=>$message,'user'=>Auth::user()->profile ,'status' => true]);
        
    }
    public function store(Request $request)
    {
       
        $post = new Post;
        $post->user_id = auth()->user()->id;
        $post->content = $request->content;
        $post->save();
        foreach($request->images as $value){
            $destination_path = 'uploads/posts/';
                $fileName = $value->getClientOriginalName();
                $profileImage = date("Ymd").$fileName;

                Image::make($value)->save(public_path($destination_path) . DIRECTORY_SEPARATOR. $profileImage);

                
            DB::table('posts_images')->insert(
                [
                    'post_id'=>$post->id,
                    'image'=> $destination_path.$profileImage
                ]
			);
        }
        
        $posts = DB::table('posts')->where('id',$post->id)->first();
        $postImages = DB::table('posts_images')->where('post_id',$post->id)->get();
        if(Auth::user()->profile->pic != ''){
            $userImg = asset(Auth::user()->profile->pic);
        }else{
            $userImg = asset(images/userImage.jpg);
        }
        
        $userName = Auth::user()->name;
        return response()->json(['post'=>$posts,'postImages'=>$postImages ,'userImg'=>$userImg,'userName'=>$userName,'status' => true]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function show(Post $post)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function edit(Post $post)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Post $post)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post $post)
    {
        //
    }
    
    
}
